/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.util.BadFormatException;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.RTPPacketReceiver;
import com.sun.media.rtp.util.UDPPacketReceiver;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;

public class RTPRawReceiver
extends PacketFilter {
    private OverallStats stats;

    public String filtername() {
        return "RTP Raw Packet Receiver";
    }

    public RTPRawReceiver() {
    }

    public RTPRawReceiver(DatagramSocket sock, OverallStats stats) {
        this.setSource(new UDPPacketReceiver(sock, 2000));
        this.stats = stats;
    }

    public RTPRawReceiver(int remoteport, String remoteaddress, OverallStats stats) throws UnknownHostException, IOException, SocketException {
        this.setSource(new UDPPacketReceiver(remoteport & 0xFFFFFFFE, remoteaddress, 2000));
        this.stats = stats;
    }

    public RTPRawReceiver(RTPPushDataSource networkdatasource, OverallStats stats) {
        this.setSource(new RTPPacketReceiver(networkdatasource));
        this.stats = stats;
    }

    public Packet handlePacket(Packet p2, int index) {
        return null;
    }

    public Packet handlePacket(Packet p2, SessionAddress a2, boolean b2) {
        return null;
    }

    public Packet handlePacket(Packet p2) {
        RTPPacket result;
        this.stats.update(0, 1);
        this.stats.update(1, p2.length);
        try {
            result = this.parse(p2);
        }
        catch (BadFormatException badFormatException) {
            this.stats.update(2, 1);
            return null;
        }
        return result;
    }

    public RTPPacket parse(Packet packet) throws BadFormatException {
        RTPPacket p2 = new RTPPacket(packet);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(p2.data, p2.offset, p2.length));
        try {
            int firstbyte = in.readUnsignedByte();
            if ((firstbyte & 0xC0) != 128) {
                throw new BadFormatException();
            }
            if ((firstbyte & 0x10) != 0) {
                p2.extensionPresent = true;
            }
            int padlen = 0;
            if ((firstbyte & 0x20) != 0) {
                padlen = p2.data[p2.offset + p2.length - 1] & 0xFF;
            }
            firstbyte &= 0xF;
            p2.payloadType = in.readUnsignedByte();
            p2.marker = p2.payloadType >> 7;
            p2.payloadType &= 0x7F;
            p2.seqnum = in.readUnsignedShort();
            p2.timestamp = (long)in.readInt() & 0xFFFFFFFFL;
            p2.ssrc = in.readInt();
            p2.csrc = new int[firstbyte];
            int i2 = 0;
            while (i2 < p2.csrc.length) {
                p2.csrc[i2] = in.readInt();
                ++i2;
            }
            int offset = 12 + (p2.csrc.length << 2);
            if (p2.extensionPresent) {
                p2.extensionType = in.readUnsignedShort();
                int extlen = in.readUnsignedShort();
                p2.extension = new byte[extlen <<= 2];
                in.readFully(p2.extension);
                offset += extlen + 4;
            }
            p2.payloadlength = p2.length - (offset + padlen);
            if (p2.payloadlength < 1) {
                throw new BadFormatException();
            }
            p2.payloadoffset = offset + p2.offset;
        }
        catch (EOFException eOFException) {
            throw new BadFormatException("Unexpected end of RTP packet");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        return p2;
    }
}

