/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SourceRTPPacket;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import javax.media.Buffer;
import javax.media.format.AudioFormat;

public class RTPDemultiplexer {
    private SSRCCache cache;
    private Buffer buffer;

    public RTPDemultiplexer(SSRCCache c2) {
        this.cache = c2;
        this.buffer = new Buffer();
    }

    public String consumerString() {
        return "RTP DeMultiplexer";
    }

    public void demuxpayload(Packet p2) {
        this.demuxpayload((RTPPacket)p2);
    }

    public void demuxpayload(SourceRTPPacket sp) {
        SSRCInfo info = sp.ssrcinfo;
        RTPPacket p2 = sp.p;
        info.payloadType = p2.payloadType;
        if (info.dstream != null) {
            this.buffer.setData(p2.base.data);
            this.buffer.setFlags(0);
            if (p2.marker == 1) {
                this.buffer.setFlags(this.buffer.getFlags() | 0x400);
            }
            this.buffer.setLength(p2.payloadlength);
            this.buffer.setOffset(p2.payloadoffset);
            this.buffer.setTimeStamp(p2.timestamp);
            if (info.dstream.getFormat() instanceof AudioFormat) {
                this.buffer.setTimeStamp(0L);
            }
            this.buffer.setSequenceNumber(p2.seqnum);
            this.buffer.setFormat(info.dstream.getFormat());
            info.dstream.add(this.buffer, info.wrapped);
        }
    }
}

