/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.util.Signed;
import javax.media.rtp.rtcp.Feedback;

public class RTCPReportBlock
implements Feedback {
    int ssrc;
    int fractionlost;
    int packetslost;
    long lastseq;
    int jitter;
    long lsr;
    long dlsr;
    long receiptTime;

    public long getSSRC() {
        return this.ssrc;
    }

    public int getFractionLost() {
        return this.fractionlost;
    }

    public long getNumLost() {
        return this.packetslost;
    }

    public long getXtndSeqNum() {
        return this.lastseq;
    }

    public long getJitter() {
        return this.jitter;
    }

    public long getLSR() {
        return this.lsr;
    }

    public long getDLSR() {
        return this.dlsr;
    }

    public String toString() {
        long printssrc = this.ssrc;
        if (this.ssrc < 0) {
            printssrc = Signed.UnsignedInt(this.ssrc);
        }
        return "\t\tFor source " + printssrc + "\n\t\t\tFraction of packets lost: " + this.fractionlost + " (" + (double)this.fractionlost / 256.0 + ")" + "\n\t\t\tPackets lost: " + this.packetslost + "\n\t\t\tLast sequence number: " + this.lastseq + "\n\t\t\tJitter: " + this.jitter + "\n\t\t\tLast SR packet received at time " + this.lsr + "\n\t\t\tDelay since last SR packet received: " + this.dlsr + " (" + (double)this.dlsr / 65536.0 + " seconds)\n";
    }

    public static String toString(RTCPReportBlock[] reports) {
        String s = "";
        int i2 = 0;
        while (i2 < reports.length) {
            s = String.valueOf(s) + reports[i2];
            ++i2;
        }
        return s;
    }
}

