/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.video.BasicVideoRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public class JPEGRenderer
extends BasicVideoRenderer {
    private static final String MyName = "JPEG Renderer";
    private VideoFormat supportedJPEG = new VideoFormat("jpeg", null, -1, Format.byteArray, -1.0f);
    private VideoFormat supportedMJPG = new VideoFormat("mjpg", null, -1, Format.byteArray, -1.0f);
    static boolean nativeAvail;

    public JPEGRenderer() {
        super(MyName);
        this.supportedFormats = new VideoFormat[2];
        this.supportedFormats[0] = this.supportedJPEG;
        this.supportedFormats[1] = this.supportedMJPG;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        if (nativeAvail) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            this.reset();
            return format;
        }
        return null;
    }

    public synchronized int doProcess(Buffer buffer) {
        if (this.component == null) {
            return 0;
        }
        if (!buffer.getFormat().equals(this.inputFormat)) {
            Format in = buffer.getFormat();
            if (!in.matches(this.supportedJPEG)) {
                return 1;
            }
            this.inputFormat = (VideoFormat)in;
        }
        Dimension size = this.inputFormat.getSize();
        Object data = buffer.getData();
        if (!(data instanceof byte[])) {
            return 1;
        }
        Image im = Toolkit.getDefaultToolkit().createImage((byte[])data);
        MediaTracker tracker = new MediaTracker(this.component);
        Dimension d2 = this.component.getSize();
        this.outWidth = d2.width;
        this.outHeight = d2.height;
        tracker.addImage(im, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {}
        Graphics g2 = this.component.getGraphics();
        if (g2 != null) {
            g2.drawImage(im, 0, 0, this.outWidth, this.outHeight, 0, 0, size.width, size.height, this.component);
        }
        return 0;
    }

    protected void repaint() {
    }

    static {
        try {
            JMFSecurityManager.loadLibrary("jmjpeg");
            nativeAvail = true;
        }
        catch (Throwable throwable) {}
    }
}

