/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.util.WindowUtil;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.IndexedColorFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class GDIRenderer
extends BasicVideoRenderer {
    private static boolean available;
    private int blitter;
    protected Object data;
    private int defbitsPerPixel;
    private int defrMask;
    private int defgMask;
    private int defbMask;
    private int offsetX;
    private int offsetY;
    private int bytesPerPixel = 4;
    private int bitsPerPixel;
    private int rMask;
    private int gMask;
    private int bMask;
    private int pixelStride;
    private int lineStride;
    private boolean flipped;
    private int handle;
    protected VideoFormat defaultFormat;

    private synchronized native boolean gdiInitialize();

    private synchronized native boolean gdiSetComponent(int var1);

    private synchronized native boolean gdiSetOutputSize(int var1, int var2);

    private synchronized native boolean gdiDraw(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, boolean var12, int var13);

    private synchronized native boolean gdiFree();

    public GDIRenderer() {
        super("Windows GDI Renderer");
        if (available) {
            if (this.gdiInitialize()) {
                Class arrayType = this.defbitsPerPixel <= 8 ? Format.byteArray : (this.defbitsPerPixel <= 16 ? Format.shortArray : (this.defbitsPerPixel <= 24 ? Format.byteArray : Format.intArray));
                this.defaultFormat = new RGBFormat(null, -1, arrayType, -1.0f, this.defbitsPerPixel, this.defbitsPerPixel != 24 ? 1 : 0, this.defrMask, this.defgMask, this.defbMask, this.defbitsPerPixel == 24 ? 3 : 1, -1, -1, -1);
                this.supportedFormats = new VideoFormat[8];
                this.supportedFormats[0] = this.defaultFormat;
                this.supportedFormats[1] = new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 1, 31744, 992, 31, 1, -1, -1, -1);
                this.supportedFormats[2] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 16, 0, 31744, 992, 31, 2, -1, -1, 1);
                this.supportedFormats[3] = new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 1, 63488, 2016, 31, 1, -1, -1, -1);
                this.supportedFormats[4] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 16, 0, 63488, 2016, 31, 2, -1, -1, 1);
                this.supportedFormats[5] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 0, 3, 2, 1, 3, -1, -1, -1);
                this.supportedFormats[6] = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 1, 0xFF0000, 65280, 255, 1, -1, -1, -1);
                this.supportedFormats[7] = new RGBFormat(null, -1, Format.byteArray, -1.0f, 32, 0, 3, 2, 1, 4, -1, -1, -1);
            } else {
                System.err.println("GDIRenderer. gdiInitialize() failed");
                available = false;
            }
        }
    }

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("GDI not available !!!");
        }
        this.handle = 0;
        if (this.blitter == 0) {
            this.gdiInitialize();
        }
        if (this.blitter == 0) {
            throw new ResourceUnavailableException("GDIRenderer couldn't open");
        }
    }

    public synchronized void reset() {
        this.handle = 0;
    }

    public void close() {
        if (available) {
            this.gdiFree();
        }
    }

    public Format setInputFormat(Format format) {
        if (!available) {
            return null;
        }
        if (super.setInputFormat(format) != null) {
            if (this.inputFormat instanceof RGBFormat) {
                RGBFormat rgbf = (RGBFormat)this.inputFormat;
                this.bitsPerPixel = rgbf.getBitsPerPixel();
                this.rMask = rgbf.getRedMask();
                this.gMask = rgbf.getGreenMask();
                this.bMask = rgbf.getBlueMask();
                this.lineStride = rgbf.getLineStride();
                this.pixelStride = rgbf.getPixelStride();
                boolean bl = this.flipped = rgbf.getFlipped() == 1;
                if (this.inputFormat.getDataType() == Format.byteArray && this.bitsPerPixel > 16) {
                    int bypp = this.bitsPerPixel / 8;
                    this.rMask = 255 << (this.rMask - 1) * 8;
                    this.gMask = 255 << (this.gMask - 1) * 8;
                    this.bMask = 255 << (this.bMask - 1) * 8;
                }
            } else if (this.inputFormat instanceof IndexedColorFormat) {
                this.bitsPerPixel = 8;
                this.lineStride = ((IndexedColorFormat)format).getLineStride();
            } else {
                return null;
            }
            if (this.outWidth == -1 || this.outHeight == -1) {
                this.outWidth = this.inWidth;
                this.outHeight = this.inHeight;
            }
            if (this.component != null) {
                this.component.setSize(this.outWidth, this.outHeight);
            }
            return format;
        }
        return null;
    }

    protected int doProcess(Buffer buffer) {
        return this.doProcess(buffer, false);
    }

    protected synchronized int doProcess(Buffer buffer, boolean repainting) {
        if (!available || this.component == null) {
            return 0;
        }
        if (this.handle == 0) {
            this.handle = WindowUtil.getWindowHandle(this.component);
        }
        if (this.handle == 0) {
            return 0;
        }
        if (!repainting && !buffer.getFormat().equals(this.inputFormat) && this.setInputFormat(buffer.getFormat()) == null) {
            return 1;
        }
        if (!repainting) {
            this.data = buffer.getData();
        }
        int elSize = 1;
        if (this.data instanceof short[]) {
            elSize = 2;
        } else if (this.data instanceof int[]) {
            elSize = 4;
        }
        this.bytesPerPixel = this.bitsPerPixel / 8;
        if (this.outWidth > 0 && this.outHeight > 0) {
            int returned = this.gdiDraw(this.data, elSize, this.bytesPerPixel, this.inWidth, this.inHeight, this.lineStride / this.pixelStride, this.outWidth, this.outHeight, this.rMask, this.gMask, this.bMask, this.flipped, this.handle) ? 0 : 1;
            return returned;
        }
        return 0;
    }

    protected synchronized void repaint() {
        if (!this.isStarted() && this.data != null) {
            this.doProcess(null, true);
        }
    }

    protected synchronized void setAvailable(boolean available) {
        super.setAvailable(available);
        this.handle = 0;
    }

    static {
        try {
            JMFSecurityManager.loadLibrary("jmgdi");
            available = true;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }
}

