/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.video;

import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.vfw.BitMapInfo;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class AviParser
extends BasicPullParser {
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("video.x_msvideo")};
    private PullSourceStream stream;
    private CachedStream cacheStream;
    private Track[] tracks;
    private Seekable seekableStream;
    private int numSupportedTracks;
    private int length;
    private int audioTrack = -1;
    private int videoTrack = -1;
    private static final int SIZE_OF_AVI_INDEX = 16;
    private static final int AVIH_HEADER_LENGTH = 56;
    private static final int STRH_HEADER_LENGTH = 56;
    private static final int STRF_VIDEO_HEADER_LENGTH = 40;
    private static final int STRF_AUDIO_HEADER_LENGTH = 16;
    static final int AVIF_HASINDEX = 16;
    static final int AVIF_MUSTUSEINDEX = 32;
    static final int AVIF_ISINTERLEAVED = 256;
    static final int AVIF_WASCAPTUREFILE = 65536;
    static final int AVIF_COPYRIGHTED = 131072;
    static final int AVIF_KEYFRAME = 16;
    static final String AUDIO = "auds";
    static final String VIDEO = "vids";
    static final String LISTRECORDCHUNK = "rec ";
    static final String VIDEO_MAGIC = "dc";
    static final String VIDEO_MAGIC_JPEG = "db";
    static final String VIDEO_MAGIC_IV32a = "iv";
    static final String VIDEO_MAGIC_IV32b = "32";
    static final String VIDEO_MAGIC_IV31 = "31";
    static final String VIDEO_MAGIC_CVID = "id";
    static final String AUDIO_MAGIC = "wb";
    private int usecPerFrame;
    private long nanoSecPerFrame;
    private int maxBytesPerSecond;
    private int paddingGranularity;
    private int flags;
    private int totalFrames;
    private int initialFrames;
    private int numTracks;
    private int suggestedBufferSize;
    private int width;
    private int height;
    private TrakList[] trakList;
    private int idx1MinimumChunkOffset;
    private int moviOffset;
    private Time duration = Duration.DURATION_UNKNOWN;
    private boolean moviChunkSeen = false;
    private boolean idx1ChunkSeen = false;
    private int maxAudioChunkIndex;
    private int maxVideoChunkIndex;
    private int extraHeaderLength;
    private byte[] codecSpecificHeader;
    private Object seekSync = new Object();

    protected boolean supports(SourceStream[] streams) {
        return this.seekable;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.stream = (PullSourceStream)this.streams[0];
        this.seekableStream = (Seekable)((Object)this.streams[0]);
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks != null) {
            return this.tracks;
        }
        if (this.seekableStream == null) {
            return new Track[0];
        }
        this.readHeader();
        if (!this.moviChunkSeen) {
            throw new BadHeaderException("No movi chunk");
        }
        if (!this.idx1ChunkSeen) {
            throw new BadHeaderException("Currently files with no idx1 chunk are not supported");
        }
        if (this.numTracks <= 0) {
            throw new BadHeaderException("Error parsing header");
        }
        this.tracks = new Track[this.numTracks];
        int i2 = 0;
        while (i2 < this.tracks.length) {
            TrakList trakInfo = this.trakList[i2];
            if (trakInfo.trackType.equals(AUDIO)) {
                this.tracks[i2] = new AudioTrack(trakInfo);
            } else if (trakInfo.trackType.equals(VIDEO)) {
                this.tracks[i2] = new VideoTrack(trakInfo);
            }
            ++i2;
        }
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        String magicRIFF = this.readString(this.stream);
        if (!magicRIFF.equals("RIFF")) {
            throw new BadHeaderException("AVI Parser: expected string RIFF, got " + magicRIFF);
        }
        this.length = this.readInt(this.stream, false);
        this.length += 8;
        String magicAVI = this.readString(this.stream);
        if (!magicAVI.equals("AVI ")) {
            throw new BadHeaderException("AVI Parser: expected string AVI, got " + magicAVI);
        }
        int currentTrack = 0;
        while (this.getLocation(this.stream) <= (long)(this.length - 12)) {
            String next = this.readString(this.stream);
            int subchunkLength = this.readInt(this.stream, false);
            if (next.equals("LIST")) {
                String subchunk = this.readString(this.stream);
                if (subchunk.equals("hdrl")) {
                    this.parseHDRL();
                    continue;
                }
                if (subchunk.equals("strl")) {
                    this.parseSTRL(subchunkLength, currentTrack);
                    ++currentTrack;
                    continue;
                }
                if (subchunk.equals("movi")) {
                    this.parseMOVI(subchunkLength - 4);
                    continue;
                }
                this.skip(this.stream, subchunkLength - 4);
                continue;
            }
            if (next.equals("idx1")) {
                this.parseIDX1(subchunkLength);
                continue;
            }
            this.skip(this.stream, subchunkLength);
            if ((subchunkLength & 1) <= 0) continue;
            this.skip(this.stream, 1);
        }
        if (this.totalFrames != 0 && this.usecPerFrame != 0) {
            this.duration = new Time((long)this.usecPerFrame * (long)this.totalFrames * 1000L);
        }
    }

    private long getLocation() {
        return this.getLocation(this.stream);
    }

    private void parseHDRL() throws BadHeaderException {
        try {
            String next = this.readString(this.stream);
            if (!next.equals("avih")) {
                throw new BadHeaderException("AVI Parser: expected string AVIH, got " + next);
            }
            int headerLength = this.readInt(this.stream, false);
            this.parseAVIH(headerLength);
            this.trakList = new TrakList[this.numTracks];
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseSTRL(int length, int currentTrack) throws BadHeaderException {
        try {
            if (currentTrack >= this.trakList.length) {
                throw new BadHeaderException("inconsistent number of strl atoms");
            }
            length -= 12;
            while (length >= 12) {
                String subchunkid = this.readString(this.stream);
                int subchunkLength = this.readInt(this.stream, false);
                if (subchunkid.equals("strh")) {
                    this.parseSTRH(subchunkLength, currentTrack);
                } else if (subchunkid.equals("strf")) {
                    if (this.trakList[currentTrack] == null) {
                        throw new BadHeaderException("strf doesn't have a strh atom preceding it");
                    }
                    this.parseSTRF(subchunkLength, currentTrack);
                } else {
                    if ((subchunkLength & 1) > 0) {
                        ++subchunkLength;
                    }
                    this.skip(this.stream, subchunkLength);
                }
                length -= subchunkLength + 4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseSTRH(int length, int currentTrack) throws BadHeaderException {
        try {
            if (length < 56) {
                throw new BadHeaderException("strh: header length should be atleast " + 56 + " but is " + length);
            }
            this.trakList[currentTrack] = new TrakList();
            this.trakList[currentTrack].trackType = this.readString(this.stream);
            this.trakList[currentTrack].streamHandler = this.readString(this.stream);
            this.trakList[currentTrack].flags = this.readInt(this.stream, false);
            this.trakList[currentTrack].priority = this.readInt(this.stream, false);
            this.trakList[currentTrack].initialFrames = this.readInt(this.stream, false);
            this.trakList[currentTrack].scale = this.readInt(this.stream, false);
            this.trakList[currentTrack].rate = this.readInt(this.stream, false);
            this.trakList[currentTrack].start = this.readInt(this.stream, false);
            this.trakList[currentTrack].length = this.readInt(this.stream, false);
            this.trakList[currentTrack].suggestedBufferSize = this.readInt(this.stream, false);
            this.trakList[currentTrack].quality = this.readInt(this.stream, false);
            this.trakList[currentTrack].sampleSize = this.readInt(this.stream, false);
            this.skip(this.stream, 8);
            if (length - 56 > 0) {
                this.skip(this.stream, length - 56);
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseSTRF(int length, int currentTrack) throws BadHeaderException {
        block19: {
            try {
                String trackType = this.trakList[currentTrack].trackType;
                if (trackType.equals(VIDEO)) {
                    Video video = new Video();
                    video.size = this.readInt(this.stream, false);
                    video.width = this.readInt(this.stream, false);
                    video.height = this.readInt(this.stream, false);
                    video.planes = this.readShort(this.stream, false);
                    video.depth = this.readShort(this.stream, false);
                    byte[] intArray = new byte[4];
                    this.readBytes(this.stream, intArray, 4);
                    if (intArray[0] > 32) {
                        video.compressor = new String(intArray);
                    } else {
                        switch (intArray[0]) {
                            case 0: {
                                video.compressor = "rgb";
                                break;
                            }
                            case 1: {
                                video.compressor = "rle8";
                                break;
                            }
                            case 2: {
                                video.compressor = "rle4";
                                break;
                            }
                            case 3: {
                                video.compressor = "rgb";
                                break;
                            }
                        }
                    }
                    BitMapInfo bmi = new BitMapInfo();
                    bmi.biWidth = video.width;
                    bmi.biHeight = video.height;
                    bmi.biPlanes = video.planes;
                    bmi.biBitCount = video.depth;
                    bmi.fourcc = new String(video.compressor);
                    video.bitMapInfo = bmi;
                    bmi.biSizeImage = this.readInt(this.stream, false);
                    bmi.biXPelsPerMeter = this.readInt(this.stream, false);
                    bmi.biYPelsPerMeter = this.readInt(this.stream, false);
                    bmi.biClrUsed = this.readInt(this.stream, false);
                    bmi.biClrImportant = this.readInt(this.stream, false);
                    if (length - 40 > 0) {
                        bmi.extraSize = length - 40;
                        bmi.extraBytes = new byte[bmi.extraSize];
                        this.readBytes(this.stream, bmi.extraBytes, bmi.extraSize);
                    }
                    this.trakList[currentTrack].media = video;
                    this.trakList[currentTrack].media.maxSampleSize = this.trakList[currentTrack].suggestedBufferSize;
                    this.videoTrack = currentTrack;
                    break block19;
                }
                if (trackType.equals(AUDIO)) {
                    Audio audio = new Audio();
                    audio.formatTag = this.readShort(this.stream, false);
                    audio.channels = this.readShort(this.stream, false);
                    audio.sampleRate = this.readInt(this.stream, false);
                    audio.avgBytesPerSec = this.readInt(this.stream, false);
                    audio.blockAlign = this.readShort(this.stream, false);
                    audio.bitsPerSample = this.readShort(this.stream, false);
                    int remainingFormatSize = length - 16;
                    this.codecSpecificHeader = null;
                    short extraFieldsSize = 0;
                    if (remainingFormatSize >= 2) {
                        extraFieldsSize = this.readShort(this.stream, false);
                        remainingFormatSize -= 2;
                        if (extraFieldsSize > 0) {
                            this.codecSpecificHeader = new byte[extraFieldsSize];
                            this.readBytes(this.stream, this.codecSpecificHeader, this.codecSpecificHeader.length);
                            remainingFormatSize -= extraFieldsSize;
                        }
                        if (audio.formatTag == 2 || audio.formatTag == 17 || audio.formatTag == 49) {
                            if (extraFieldsSize < 2) {
                                throw new BadHeaderException("samplesPerBlock field not available for encoding" + audio.formatTag);
                            }
                            audio.samplesPerBlock = BasicPullParser.parseShortFromArray(this.codecSpecificHeader, false);
                        }
                    }
                    if (remainingFormatSize < 0) {
                        throw new BadHeaderException("Avi Parser: incorrect headersize in the STRF");
                    }
                    if (remainingFormatSize > 0) {
                        this.skip(this.stream, length - 16);
                    }
                    this.trakList[currentTrack].media = audio;
                    this.audioTrack = currentTrack;
                    break block19;
                }
                throw new BadHeaderException("strf: unsupported stream type " + trackType);
            }
            catch (IOException iOException) {
                throw new BadHeaderException("IOException when parsing hdrl");
            }
        }
    }

    private void parseAVIH(int length) throws BadHeaderException {
        try {
            if (length < 56) {
                throw new BadHeaderException("avih: header size is not 56");
            }
            this.usecPerFrame = this.readInt(this.stream, false);
            this.nanoSecPerFrame = this.usecPerFrame * 1000;
            this.maxBytesPerSecond = this.readInt(this.stream, false);
            this.paddingGranularity = this.readInt(this.stream, false);
            this.flags = this.readInt(this.stream, false);
            this.totalFrames = this.readInt(this.stream, false);
            this.initialFrames = this.readInt(this.stream, false);
            this.numTracks = this.readInt(this.stream, false);
            this.suggestedBufferSize = this.readInt(this.stream, false);
            this.width = this.readInt(this.stream, false);
            this.height = this.readInt(this.stream, false);
            this.skip(this.stream, 16);
            if (length - 56 > 0) {
                this.skip(this.stream, length - 56);
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseIDX1(int length) throws BadHeaderException {
        try {
            if (!this.moviChunkSeen) {
                throw new BadHeaderException("idx1 chunk appears before movi chunk");
            }
            int numIndices = length / 16;
            int i2 = 0;
            while (i2 < this.numTracks) {
                if (this.trakList[i2] == null) {
                    throw new BadHeaderException("Bad file format");
                }
                this.trakList[i2].chunkInfo = new AVIIndexEntry[numIndices];
                if (this.trakList[i2].trackType.equals(VIDEO)) {
                    this.trakList[i2].keyFrames = new int[numIndices];
                }
                ++i2;
            }
            this.idx1MinimumChunkOffset = Integer.MAX_VALUE;
            int i3 = 0;
            while (i3 < numIndices) {
                String id = this.readString(this.stream);
                if (id.equals(LISTRECORDCHUNK)) {
                    this.readInt(this.stream, false);
                    this.readInt(this.stream, false);
                    this.readInt(this.stream, false);
                } else {
                    int streamNumber = Integer.parseInt(id.substring(0, 2));
                    if (streamNumber < 0 || streamNumber >= this.numTracks) {
                        throw new BadHeaderException("index chunk has illegal stream # " + streamNumber);
                    }
                    int flag = this.readInt(this.stream, false);
                    int chunkOffset = this.readInt(this.stream, false);
                    int chunkLength = this.readInt(this.stream, false);
                    AVIIndexEntry[] chunkInfo = this.trakList[streamNumber].chunkInfo;
                    int index = this.trakList[streamNumber].maxChunkIndex;
                    chunkInfo[index] = new AVIIndexEntry();
                    chunkInfo[index].id = id;
                    chunkInfo[index].flag = flag;
                    chunkInfo[index].chunkOffset = chunkOffset;
                    chunkInfo[index].chunkLength = chunkLength;
                    if (this.trakList[streamNumber].trackType.equals(AUDIO)) {
                        int c2;
                        chunkInfo[index].cumulativeChunkLength = c2 = (this.trakList[streamNumber].tmpCumulativeChunkLength += chunkLength);
                    }
                    if (this.trakList[streamNumber].trackType.equals(VIDEO) && (flag & 0x10) > 0) {
                        int keyFrameIndex = this.trakList[streamNumber].numKeyFrames++;
                        this.trakList[streamNumber].keyFrames[keyFrameIndex] = index;
                    }
                    ++this.trakList[streamNumber].maxChunkIndex;
                    if (chunkOffset < this.idx1MinimumChunkOffset) {
                        this.idx1MinimumChunkOffset = chunkOffset;
                    }
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.numTracks) {
                if (this.trakList[i4].trackType.equals(VIDEO)) {
                    int numKeyFrames = this.trakList[i4].numKeyFrames;
                    int maxChunkIndex = this.trakList[i4].maxChunkIndex;
                    if (numKeyFrames > 0 && numKeyFrames < maxChunkIndex) {
                        this.trakList[i4].indexToKeyframeIndex = this.buildIndexToKeyFrameIndexTable(this.trakList[i4].keyFrames, numKeyFrames, maxChunkIndex);
                    }
                    this.trakList[i4].keyFrames = null;
                }
                ++i4;
            }
            if (this.idx1MinimumChunkOffset >= this.moviOffset) {
                this.moviOffset = 0;
            }
            this.moviOffset += 8;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing IDX1");
        }
        this.idx1ChunkSeen = true;
    }

    private void parseMOVI(int length) throws BadHeaderException {
        try {
            this.moviChunkSeen = true;
            if ((this.flags & 0x10) > 0) {
                this.moviOffset = (int)this.getLocation(this.stream) - 4;
                this.skip(this.stream, length);
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing movi");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time setPosition(Time where, int rounding) {
        int i2 = 0;
        while (true) {
            block15: {
                Object var7_6;
                int offsetWithinChunk;
                int chunkNumber;
                block14: {
                    block17: {
                        block16: {
                            if (i2 >= this.numTracks) {
                                return where;
                            }
                            chunkNumber = 0;
                            offsetWithinChunk = 0;
                            try {
                                int blockAlign;
                                TrakList trakInfo = this.trakList[i2];
                                if (trakInfo.trackType.equals(VIDEO)) {
                                    if (this.usecPerFrame == 0) break block14;
                                    chunkNumber = (int)(where.getNanoseconds() / this.nanoSecPerFrame);
                                    if (chunkNumber < 0) {
                                        chunkNumber = 0;
                                    } else if (chunkNumber >= trakInfo.maxChunkIndex) {
                                        var7_6 = null;
                                        ((MediaTrack)this.tracks[i2]).setChunkNumberAndOffset(chunkNumber, offsetWithinChunk);
                                        break block15;
                                    }
                                    if (trakInfo.indexToKeyframeIndex.length <= chunkNumber) break block14;
                                    chunkNumber = trakInfo.indexToKeyframeIndex[chunkNumber];
                                    break block14;
                                }
                                if (!trakInfo.trackType.equals(AUDIO)) break block14;
                                int bytePos = (int)(where.getSeconds() * (double)((Audio)trakInfo.media).avgBytesPerSec);
                                if (bytePos < 0) {
                                    bytePos = 0;
                                }
                                if (trakInfo.maxChunkIndex == 1) {
                                    if (bytePos >= trakInfo.chunkInfo[0].chunkLength) {
                                        chunkNumber = trakInfo.maxChunkIndex;
                                        break block16;
                                    }
                                    chunkNumber = 0;
                                    offsetWithinChunk = bytePos;
                                } else {
                                    chunkNumber = trakInfo.getChunkNumber(bytePos);
                                    if (chunkNumber >= trakInfo.maxChunkIndex) {
                                        break block17;
                                    }
                                    int approx = trakInfo.chunkInfo[chunkNumber].cumulativeChunkLength - trakInfo.chunkInfo[chunkNumber].chunkLength;
                                    offsetWithinChunk = bytePos - approx;
                                }
                                if ((offsetWithinChunk & 1) > 0) {
                                    --offsetWithinChunk;
                                }
                                if ((blockAlign = ((Audio)trakInfo.media).blockAlign) == 0) break block14;
                                offsetWithinChunk -= offsetWithinChunk % blockAlign;
                                break block14;
                            }
                            catch (Throwable throwable) {
                                var7_6 = null;
                                ((MediaTrack)this.tracks[i2]).setChunkNumberAndOffset(chunkNumber, offsetWithinChunk);
                                throw throwable;
                            }
                        }
                        var7_6 = null;
                        ((MediaTrack)this.tracks[i2]).setChunkNumberAndOffset(chunkNumber, offsetWithinChunk);
                        break block15;
                    }
                    var7_6 = null;
                    ((MediaTrack)this.tracks[i2]).setChunkNumberAndOffset(chunkNumber, offsetWithinChunk);
                    break block15;
                }
                var7_6 = null;
                ((MediaTrack)this.tracks[i2]).setChunkNumberAndOffset(chunkNumber, offsetWithinChunk);
            }
            ++i2;
        }
    }

    public Time getMediaTime() {
        return null;
    }

    public Time getDuration() {
        return this.duration;
    }

    public String getName() {
        return "Parser for avi file format";
    }

    private boolean isSupported(String trackType) {
        return trackType.equals(VIDEO) || trackType.equals(AUDIO);
    }

    private int[] buildIndexToKeyFrameIndexTable(int[] syncSamples, int numKeyFrames, int numberOfSamples) {
        int previous;
        int[] syncSampleMapping = new int[numberOfSamples];
        int index = 0;
        if (syncSamples[0] != 0) {
            syncSampleMapping[0] = 0;
            previous = 0;
        } else {
            syncSampleMapping[0] = 0;
            previous = 0;
            ++index;
        }
        while (index < numKeyFrames) {
            int next;
            syncSampleMapping[next] = next = syncSamples[index];
            int range = next - previous - 1;
            int j2 = previous + 1;
            while (j2 < next) {
                syncSampleMapping[j2] = (double)((float)(j2 - previous) / (float)range) <= 0.5 ? previous : next;
                ++j2;
            }
            previous = next;
            ++index;
        }
        int lastSyncFrame = syncSamples[numKeyFrames - 1];
        index = lastSyncFrame + 1;
        while (index < numberOfSamples) {
            syncSampleMapping[index] = lastSyncFrame;
            ++index;
        }
        return syncSampleMapping;
    }

    private abstract class Media {
        int maxSampleSize;

        abstract Format createFormat();

        Media() {
            AviParser.this = AviParser.this;
        }
    }

    private class Audio
    extends Media {
        int formatTag;
        int channels;
        int sampleRate;
        int avgBytesPerSec;
        int blockAlign;
        int bitsPerSample;
        int samplesPerBlock;
        AudioFormat format;

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String encodingString = (String)WavAudioFormat.formatMapper.get(new Integer(this.formatTag));
            if (encodingString == null) {
                encodingString = "unknown";
            }
            boolean signed = this.bitsPerSample > 8;
            this.format = new WavAudioFormat(encodingString, this.sampleRate, this.bitsPerSample, this.channels, this.blockAlign * 8, this.avgBytesPerSec, 0, signed ? 1 : 0, -1.0f, Format.byteArray, AviParser.this.codecSpecificHeader);
            return this.format;
        }

        public String toString() {
            System.out.println("Audio Media: " + this.format);
            System.out.println("Number of channels " + this.channels);
            System.out.println("average bytes per second " + this.avgBytesPerSec);
            System.out.println("sampleRate " + this.sampleRate);
            System.out.println("blockAlign " + this.blockAlign);
            System.out.println("bitsPerSample " + this.bitsPerSample);
            System.out.println("formatTag " + this.formatTag);
            return super.toString();
        }

        Audio() {
            AviParser.this = AviParser.this;
        }
    }

    private class Video
    extends Media {
        int size;
        int width;
        int height;
        int planes;
        int depth;
        String compressor;
        VideoFormat format;
        BitMapInfo bitMapInfo;

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            this.format = AviParser.this.usecPerFrame != 0 ? this.bitMapInfo.createVideoFormat(Format.byteArray, (float)(1.0 / (double)AviParser.this.usecPerFrame * 1000000.0)) : this.bitMapInfo.createVideoFormat(Format.byteArray);
            return this.format;
        }

        public String toString() {
            System.out.println("size is " + this.size);
            System.out.println("width is " + this.width);
            System.out.println("height is " + this.height);
            System.out.println("planes is " + this.planes);
            System.out.println("depth is " + this.depth);
            System.out.println("compressor is " + this.compressor);
            return super.toString();
        }

        Video() {
            AviParser.this = AviParser.this;
        }
    }

    private class TrakList {
        Time duration = Duration.DURATION_UNKNOWN;
        String trackType;
        String streamHandler;
        int flags;
        int priority;
        int initialFrames;
        int scale;
        int rate;
        int start;
        int length;
        int suggestedBufferSize;
        int quality;
        int sampleSize;
        Media media;
        boolean supported = true;
        AVIIndexEntry[] chunkInfo = new AVIIndexEntry[0];
        int maxChunkIndex;
        int[] indexToKeyframeIndex = new int[0];
        int[] keyFrames = new int[0];
        int numKeyFrames;
        int tmpCumulativeChunkLength;

        int getChunkNumber(int offset) {
            int i2 = 0;
            while (i2 < this.maxChunkIndex) {
                if (offset < this.chunkInfo[i2].cumulativeChunkLength) {
                    return i2;
                }
                ++i2;
            }
            return this.maxChunkIndex;
        }

        TrakList() {
            AviParser.this = AviParser.this;
        }
    }

    private abstract class MediaTrack
    implements Track {
        private TrakList trakInfo;
        private boolean enabled = true;
        private int numBuffers = 4;
        private Format format;
        private long sequenceNumber;
        private int chunkNumber;
        protected int useChunkNumber;
        protected int offsetWithinChunk = -1;
        protected int useOffsetWithinChunk;
        private AviParser parser = AviParser.this;
        private AVIIndexEntry indexEntry;
        private Object header;
        private TrackListener listener;

        MediaTrack(TrakList trakInfo) {
            AviParser.this = AviParser.this;
            this.trakInfo = trakInfo;
            this.format = trakInfo.media.createFormat();
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.trakInfo.duration;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        synchronized void setChunkNumberAndOffset(int number, int offset) {
            this.chunkNumber = number;
            this.offsetWithinChunk = offset;
        }

        public void readFrame(Buffer buffer) {
            byte[] data;
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            MediaTrack mediaTrack = this;
            synchronized (mediaTrack) {
                if (this.offsetWithinChunk == -1) {
                    this.useOffsetWithinChunk = 0;
                } else {
                    this.useOffsetWithinChunk = this.offsetWithinChunk;
                    this.offsetWithinChunk = -1;
                }
                this.useChunkNumber = this.chunkNumber;
            }
            if (this.useChunkNumber >= this.trakInfo.maxChunkIndex || this.useChunkNumber < 0) {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
            buffer.setFormat(this.format);
            this.indexEntry = this.trakInfo.chunkInfo[this.useChunkNumber];
            int chunkLength = this.indexEntry.chunkLength;
            Object obj = buffer.getData();
            buffer.setHeader(new Integer(this.indexEntry.flag));
            if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length < chunkLength) {
                data = new byte[chunkLength];
                buffer.setData(data);
            } else {
                data = (byte[])obj;
            }
            try {
                int actualBytesRead;
                Object object = AviParser.this.seekSync;
                synchronized (object) {
                    AviParser.this.seekableStream.seek(this.indexEntry.chunkOffset + AviParser.this.moviOffset + this.useOffsetWithinChunk);
                    actualBytesRead = this.parser.readBytes(AviParser.this.stream, data, chunkLength - this.useOffsetWithinChunk);
                    this.offsetWithinChunk = 0;
                    buffer.setTimeStamp(this.getTimeStamp());
                }
                buffer.setLength(actualBytesRead);
                if (this.trakInfo.trackType.equals(AviParser.VIDEO) && (this.trakInfo.indexToKeyframeIndex.length == 0 || this.useChunkNumber == this.trakInfo.indexToKeyframeIndex[this.useChunkNumber])) {
                    buffer.setFlags(buffer.getFlags() | 0x10);
                }
                buffer.setSequenceNumber(++this.sequenceNumber);
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            MediaTrack mediaTrack2 = this;
            synchronized (mediaTrack2) {
                if (this.chunkNumber == this.useChunkNumber) {
                    ++this.chunkNumber;
                }
            }
        }

        abstract void doReadFrame(Buffer var1);

        public int mapTimeToFrame(Time t) {
            return 0;
        }

        public Time mapFrameToTime(int frameNumber) {
            return null;
        }

        abstract long getTimeStamp();
    }

    private class AudioTrack
    extends MediaTrack {
        int channels;
        int avgBytesPerSec;
        AVIIndexEntry[] chunkInfo;

        AudioTrack(TrakList trakInfo) {
            super(trakInfo);
            AviParser.this = AviParser.this;
            this.channels = ((Audio)trakInfo.media).channels;
            this.avgBytesPerSec = ((Audio)trakInfo.media).avgBytesPerSec;
            this.chunkInfo = trakInfo.chunkInfo;
        }

        void doReadFrame(Buffer buffer) {
        }

        long getTimeStamp() {
            if (this.avgBytesPerSec > 0) {
                long bytes = this.useOffsetWithinChunk;
                if (this.useChunkNumber > 0) {
                    bytes += (long)this.chunkInfo[this.useChunkNumber - 1].cumulativeChunkLength;
                }
                return (long)((double)((float)bytes / (float)this.avgBytesPerSec) * 1.0E9);
            }
            return 0L;
        }
    }

    private class VideoTrack
    extends MediaTrack {
        int needBufferSize;
        boolean variableSampleSize = true;

        VideoTrack(TrakList trakInfo) {
            super(trakInfo);
            AviParser.this = AviParser.this;
        }

        void doReadFrame(Buffer buffer) {
        }

        long getTimeStamp() {
            return (long)(this.useChunkNumber * AviParser.this.usecPerFrame) * 1000L;
        }
    }

    private class AVIIndexEntry {
        public String id;
        public int flag;
        public int chunkOffset;
        public int chunkLength;
        public int cumulativeChunkLength;

        AVIIndexEntry() {
            AviParser.this = AviParser.this;
        }
    }
}

