/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;

public class AUMux
extends BasicMux {
    private static final int HEADER_SIZE = 24;
    private static final int UNKNOWN_ENCODING = -1;
    private AudioFormat audioFormat;
    private int sampleSizeInBits;
    private int encoding;
    private double sampleRate;
    private int channels;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, 1);

    public AUMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new ContentDescriptor("audio.basic");
    }

    public String getName() {
        return "Basic Audio Multiplexer";
    }

    public int setNumTracks(int nTracks) {
        if (nTracks != 1) {
            return 1;
        }
        return super.setNumTracks(nTracks);
    }

    protected void writeHeader() {
        this.bufClear();
        this.bufWriteInt(779316836);
        this.bufWriteInt(24);
        this.bufWriteInt(-1);
        this.bufWriteInt(this.encoding);
        this.bufWriteInt((int)this.sampleRate);
        this.bufWriteInt(this.channels);
        this.bufFlush();
    }

    public Format setInputFormat(Format format, int trackID) {
        String reason = null;
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.audioFormat = (AudioFormat)format;
        String encodingString = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        if (encodingString.equals("LINEAR")) {
            if (this.sampleSizeInBits > 8 && this.audioFormat.getEndian() == 0) {
                return null;
            }
            if (this.audioFormat.getSigned() == 0) {
                return null;
            }
            if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                this.audioFormat = (AudioFormat)this.audioFormat.intersects(this.bigEndian);
            }
        }
        this.encoding = this.getEncoding(encodingString, this.sampleSizeInBits);
        if (this.encoding == -1) {
            reason = "No support for encoding " + encodingString;
        }
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        if (reason == null) {
            return this.audioFormat;
        }
        return null;
    }

    protected void writeFooter() {
        this.seek(8);
        this.bufClear();
        this.bufWriteInt(this.fileSize - 24);
        this.bufFlush();
    }

    private int getEncoding(String encodingString, int sampleSizeInBits) {
        if (encodingString.equals("ULAW")) {
            return 1;
        }
        if (encodingString.equals("alaw")) {
            return 27;
        }
        if (encodingString.equals("LINEAR")) {
            if (sampleSizeInBits == 8) {
                return 2;
            }
            if (sampleSizeInBits == 16) {
                return 3;
            }
            if (sampleSizeInBits == 24) {
                return 4;
            }
            if (sampleSizeInBits == 32) {
                return 5;
            }
            return -1;
        }
        if (encodingString.equals("float")) {
            return 6;
        }
        if (encodingString.equals("double")) {
            return 7;
        }
        return -1;
    }
}

