/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.sun.media.BasicClock;
import com.sun.media.MediaTimeBase;
import com.sun.media.multiplexer.RawBufferMux;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;

public class RawSyncBufferMux
extends RawBufferMux
implements Clock {
    protected RawMuxTimeBase timeBase;
    Object startup = new Integer(0);
    boolean readyToStart = false;
    long[] mediaTime;
    boolean[] ready;
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = System.currentTimeMillis() * 1000000L;

    public RawSyncBufferMux() {
        this.timeBase = new RawMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {}
    }

    public boolean initializeTracks(Format[] trackFormats) {
        if (!super.initializeTracks(trackFormats)) {
            return false;
        }
        this.mediaTime = new long[trackFormats.length];
        int i2 = 0;
        while (i2 < this.mediaTime.length) {
            this.mediaTime[i2] = 0L;
            ++i2;
        }
        this.ready = new boolean[trackFormats.length];
        this.resetReady();
        return true;
    }

    public void reset() {
        super.reset();
        int i2 = 0;
        while (i2 < this.mediaTime.length) {
            this.mediaTime[i2] = 0L;
            ++i2;
        }
        this.timeBase.update();
        this.resetReady();
    }

    private void resetReady() {
        int i2 = 0;
        while (i2 < this.ready.length) {
            this.ready[i2] = false;
            ++i2;
        }
        this.readyToStart = false;
        Object object = this.startup;
        synchronized (object) {
            this.startup.notifyAll();
        }
    }

    private boolean checkReady() {
        if (this.readyToStart) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.ready.length) {
            if (!this.ready[i2]) {
                return false;
            }
            ++i2;
        }
        this.readyToStart = true;
        return true;
    }

    public String getName() {
        return "Raw Sync Buffer Multiplexer";
    }

    public int process(Buffer buffer, int trackID) {
        long timestamp;
        if (this.mc != null) {
            this.mc.process(buffer);
        }
        if (this.streams == null || buffer == null || trackID >= this.streams.length) {
            return 1;
        }
        if (buffer.isDiscard()) {
            return 0;
        }
        if (!this.readyToStart && this.streams.length > 1) {
            Object object = this.startup;
            synchronized (object) {
                this.ready[trackID] = true;
                if (this.checkReady()) {
                    this.startup.notifyAll();
                } else {
                    try {
                        while (!this.readyToStart) {
                            this.startup.wait(1000L);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if ((timestamp = buffer.getTimeStamp()) <= 0L && buffer.getFormat() instanceof AudioFormat) {
            timestamp = this.mediaTime[trackID];
            int n2 = trackID;
            this.mediaTime[n2] = this.mediaTime[n2] + this.getDuration(buffer);
        } else {
            this.mediaTime[trackID] = timestamp <= 0L ? System.currentTimeMillis() * 1000000L - this.systemStartTime : timestamp;
        }
        this.timeBase.update();
        return this.streams[trackID].process(buffer);
    }

    private long getDuration(Buffer buffer) {
        AudioFormat format = (AudioFormat)buffer.getFormat();
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        if (sampleSize == 0) {
            return 0L;
        }
        long duration = buffer.getLength() * 1000 * 8 / (sampleSize * 8000);
        return duration * 1000000L;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (master != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    public void syncStart(Time at) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                Object var3_3 = null;
                return;
            }
            this.started = true;
            this.clock.syncStart(at);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis() * 1000000L;
        }
    }

    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                Object var2_2 = null;
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    public void setStopTime(Time stopTime) {
        this.clock.setStopTime(stopTime);
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public void setMediaTime(Time now) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(now);
            int i2 = 0;
            while (i2 < this.mediaTime.length) {
                this.mediaTime[i2] = now.getNanoseconds();
                ++i2;
            }
            this.timeBase.update();
        }
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public float setRate(float factor) {
        if (factor == this.clock.getRate()) {
            return factor;
        }
        return this.clock.setRate(1.0f);
    }

    class RawMuxTimeBase
    extends MediaTimeBase {
        long ticks;
        boolean updated = false;

        public long getMediaTime() {
            if (!this.updated) {
                return this.ticks;
            }
            if (RawSyncBufferMux.this.mediaTime.length == 1) {
                this.ticks = RawSyncBufferMux.this.mediaTime[0];
            } else {
                this.ticks = RawSyncBufferMux.this.mediaTime[0];
                int i2 = 1;
                while (i2 < RawSyncBufferMux.this.mediaTime.length) {
                    if (RawSyncBufferMux.this.mediaTime[i2] < this.ticks) {
                        this.ticks = RawSyncBufferMux.this.mediaTime[i2];
                    }
                    ++i2;
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }

        RawMuxTimeBase() {
            RawSyncBufferMux.this = RawSyncBufferMux.this;
        }
    }
}

