/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicClock;
import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.MonitorAdapter;
import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;

public class RawBufferMux
extends BasicPlugIn
implements Multiplexer {
    protected ContentDescriptor[] supported;
    protected ContentDescriptor contentDesc;
    protected RawBufferDataSource source;
    protected RawBufferSourceStream[] streams;
    protected BasicClock clock;
    int master;
    boolean sourceDisconnected = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected int numTracks;
    protected Format[] trackFormats;
    protected MonitorAdapter mc;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    public RawBufferMux() {
        this.supported = new ContentDescriptor[1];
        this.supported[0] = new ContentDescriptor("raw");
    }

    public String getName() {
        return "Raw Buffer Multiplexer";
    }

    public void open() throws ResourceUnavailableException {
        this.initializeTracks(this.trackFormats);
        if (this.source == null || this.source.getStreams() == null) {
            throw new ResourceUnavailableException("DataSource and SourceStreams were not created succesfully.");
        }
        try {
            this.source.connect();
        }
        catch (IOException e2) {
            throw new ResourceUnavailableException(e2.getMessage());
        }
        int i2 = 0;
        while (i2 < this.trackFormats.length) {
            if (this.trackFormats[i2] instanceof VideoFormat && this.mc == null) {
                try {
                    this.mc = new MonitorAdapter((VideoFormat)this.trackFormats[i2]);
                }
                catch (UnsupportedFormatException unsupportedFormatException) {}
                if (this.mc != null) {
                    this.controls = new Control[1];
                    this.controls[0] = this.mc;
                    return;
                }
            }
            ++i2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {}
            this.source = null;
        }
    }

    public void reset() {
        int i2 = 0;
        while (i2 < this.streams.length) {
            this.streams[i2].reset();
            ++i2;
        }
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] fmt) {
        return this.supported;
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null), new VideoFormat(null)};
    }

    public DataSource getDataOutput() {
        return this.source;
    }

    public int setNumTracks(int nTracks) {
        this.numTracks = nTracks;
        this.trackFormats = new Format[nTracks];
        int i2 = 0;
        while (i2 < nTracks) {
            this.trackFormats[i2] = null;
            ++i2;
        }
        return nTracks;
    }

    public Format setInputFormat(Format input, int trackID) {
        if (trackID < this.numTracks) {
            this.trackFormats[trackID] = input;
        }
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.trackFormats[i2] == null) {
                return input;
            }
            ++i2;
        }
        return input;
    }

    public boolean initializeTracks(Format[] trackFormats) {
        if (this.source.getStreams() != null) {
            throw new Error("initializeTracks has been called previously. ");
        }
        this.source.initialize(trackFormats);
        this.streams = (RawBufferSourceStream[])this.source.getStreams();
        return true;
    }

    public int process(Buffer buffer, int trackID) {
        if (this.mc != null) {
            this.mc.process(buffer);
        }
        if (this.streams == null || buffer == null || trackID >= this.streams.length) {
            return 1;
        }
        return this.streams[trackID].process(buffer);
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor outputContentDescriptor) {
        if (BasicPlugIn.matches(outputContentDescriptor, this.supported) == null) {
            return null;
        }
        this.contentDesc = outputContentDescriptor;
        this.source = new RawBufferDataSource();
        return this.contentDesc;
    }

    static /* synthetic */ boolean access$4() {
        return securityPrivelege;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    class RawBufferDataSource
    extends BasicPushBufferDataSource {
        public RawBufferDataSource() {
            RawBufferMux.this = RawBufferMux.this;
            if (RawBufferMux.this.contentDesc == null) {
                return;
            }
            this.contentType = RawBufferMux.this.contentDesc.getContentType();
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        public void start() throws IOException {
            super.start();
            int i2 = 0;
            while (i2 < RawBufferMux.this.streams.length) {
                RawBufferMux.this.streams[i2].start();
                ++i2;
            }
        }

        public void stop() throws IOException {
            super.stop();
            int i2 = 0;
            while (i2 < RawBufferMux.this.streams.length) {
                RawBufferMux.this.streams[i2].stop();
                ++i2;
            }
        }

        public void connect() throws IOException {
            super.connect();
            RawBufferMux.this.sourceDisconnected = false;
        }

        public void disconnect() {
            super.disconnect();
            RawBufferMux.this.sourceDisconnected = true;
            int i2 = 0;
            while (i2 < RawBufferMux.this.streams.length) {
                RawBufferMux.this.streams[i2].stop();
                RawBufferMux.this.streams[i2].close();
                ++i2;
            }
        }

        private void initialize(Format[] trackFormats) {
            RawBufferMux.this.streams = new RawBufferSourceStream[trackFormats.length];
            int i2 = 0;
            while (i2 < trackFormats.length) {
                RawBufferMux.this.streams[i2] = new RawBufferSourceStream(trackFormats[i2]);
                if (RawBufferMux.this.clock != null && RawBufferMux.this.streams[i2].getFormat() instanceof AudioFormat) {
                    RawBufferMux.this.master = i2;
                }
                ++i2;
            }
        }
    }

    class RawBufferSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        Format format;
        CircularBuffer bufferQ;
        boolean started = false;
        Object startReq = new Integer(0);
        BufferTransferHandler handler;
        Thread streamThread;
        boolean closed = false;
        boolean draining = false;
        Object drainSync = new Object();

        public RawBufferSourceStream(Format fmt) {
            RawBufferMux.this = RawBufferMux.this;
            this.contentDescriptor = RawBufferMux.this.contentDesc;
            this.format = fmt;
            this.bufferQ = new CircularBuffer(5);
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "thread";
                        jmfSecurity.requestPermission(RawBufferMux.this.m, RawBufferMux.this.cl, RawBufferMux.this.args, 16);
                        RawBufferMux.this.m[0].invoke((Object)RawBufferMux.this.cl[0], RawBufferMux.this.args[0]);
                        permission = "thread group";
                        jmfSecurity.requestPermission(RawBufferMux.this.m, RawBufferMux.this.cl, RawBufferMux.this.args, 32);
                        RawBufferMux.this.m[0].invoke((Object)RawBufferMux.this.cl[0], RawBufferMux.this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                RawBufferSourceStream rbss = this;
                try {
                    Constructor cons = jdk12CreateThreadAction.cons;
                    this.streamThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread != null ? class$com$sun$media$util$MediaThread : (class$com$sun$media$util$MediaThread = RawBufferMux.class$("com.sun.media.util.MediaThread"))));
                }
                catch (Exception exception) {}
            } else {
                this.streamThread = new MediaThread(this, "RawBufferStream Thread");
            }
            if (this.streamThread != null) {
                this.streamThread.start();
            }
        }

        public Format getFormat() {
            return this.format;
        }

        public void setTransferHandler(BufferTransferHandler handler) {
            this.handler = handler;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read(Buffer buffer) throws IOException {
            if (this.closed) {
                throw new IOException("The source stream is closed");
            }
            Buffer current = null;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (true) {
                    if (this.bufferQ.canRead()) {
                        current = this.bufferQ.read();
                        this.bufferQ.notifyAll();
                        break;
                    }
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            if (current == null) return;
            if (current.isEOM()) {
                Object object = this.drainSync;
                synchronized (object) {
                    if (this.draining) {
                        this.draining = false;
                        this.drainSync.notifyAll();
                    }
                }
            }
            Object data = buffer.getData();
            buffer.setData(current.getData());
            current.setData(data);
            Object header = buffer.getHeader();
            buffer.setHeader(current.getHeader());
            current.setHeader(header);
            buffer.setTimeStamp(current.getTimeStamp());
            buffer.setFormat(current.getFormat());
            buffer.setLength(current.getLength());
            buffer.setEOM(current.isEOM());
            buffer.setFlags(current.getFlags());
            buffer.setOffset(current.getOffset());
            buffer.setSequenceNumber(current.getSequenceNumber());
            int length = current.getLength();
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
                return;
            }
        }

        protected void start() {
            Object object = this.startReq;
            synchronized (object) {
                if (this.started) {
                    Object var2_2 = null;
                    return;
                }
                this.started = true;
                this.startReq.notifyAll();
            }
        }

        protected void stop() {
            Object object = this.startReq;
            synchronized (object) {
                this.started = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        protected void close() {
            block8: {
                this.closed = true;
                if (this.streamThread == null) break block8;
                try {
                    Object object = this.bufferQ;
                    synchronized (object) {
                        this.bufferQ.notifyAll();
                    }
                    object = this.startReq;
                    synchronized (object) {
                        this.startReq.notifyAll();
                    }
                }
                catch (Exception exception) {}
            }
        }

        protected void reset() {
            Object object = this.bufferQ;
            synchronized (object) {
                while (this.bufferQ.canRead()) {
                    Buffer b2 = this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                this.bufferQ.notifyAll();
            }
            object = this.drainSync;
            synchronized (object) {
                if (this.draining) {
                    this.draining = false;
                    this.drainSync.notifyAll();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int process(Buffer filled) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (true) {
                    if (this.bufferQ.canWrite()) {
                        buffer = this.bufferQ.getEmptyBuffer();
                        this.bufferQ.notifyAll();
                        break;
                    }
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            Object bdata = buffer.getData();
            Object bheader = buffer.getHeader();
            buffer.setData(filled.getData());
            buffer.setHeader(filled.getHeader());
            filled.setData(bdata);
            filled.setHeader(bheader);
            buffer.setLength(filled.getLength());
            buffer.setEOM(filled.isEOM());
            buffer.setFlags(filled.getFlags());
            buffer.setTimeStamp(filled.getTimeStamp());
            buffer.setFormat(filled.getFormat());
            buffer.setOffset(filled.getOffset());
            buffer.setSequenceNumber(filled.getSequenceNumber());
            Object object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
            if (!filled.isEOM()) return 0;
            object = this.drainSync;
            synchronized (object) {
                this.draining = true;
                try {
                    this.drainSync.wait(3000L);
                }
                catch (Exception exception) {}
                return 0;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!this.started && !this.closed) {
                            this.startReq.wait();
                        }
                    }
                    object = this.bufferQ;
                    synchronized (object) {
                        while (!this.bufferQ.canRead() && !this.closed && this.started) {
                            try {
                                this.bufferQ.wait();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (this.closed) {
                        return;
                    }
                    if (!this.bufferQ.canRead() || this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException e2) {
                System.err.println("Thread " + e2.getMessage());
                return;
            }
        }
    }
}

