/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.datasink.file;

import com.sun.media.controls.FileWriterAdapter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.media.Control;
import javax.media.DataSink;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.datasink.EndOfFileEvent;
import javax.media.datasink.FileSizeLimitReachedEvent;
import javax.media.datasink.FileWritingErrorEvent;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class Handler
implements DataSink,
SourceTransferHandler,
Seekable {
    protected static final int NOT_INITIALIZED = 0;
    protected static final int OPENED = 1;
    protected static final int STARTED = 2;
    protected static final int CLOSED = 3;
    protected int state = 0;
    protected FileWriterAdapter fileWriterAdapter = new FileWriterAdapter(this);
    protected DataSource source;
    protected SourceStream[] streams;
    protected SourceStream stream;
    protected boolean push;
    protected Control[] controls;
    protected File file;
    protected RandomAccessFile raFile;
    protected MediaLocator locator;
    protected String contentType;
    protected int fileSize;
    protected int filePointer;
    protected static final int BUFFER_LEN = 65536;
    protected byte[] buffer = new byte[65536];

    public void setSource(DataSource ds) throws IncompatibleSourceException {
        if (!(ds instanceof PushDataSource) && !(ds instanceof PullDataSource)) {
            throw new IncompatibleSourceException("Incompatible datasource");
        }
        this.source = ds;
        if (this.source instanceof PushDataSource) {
            this.push = true;
            try {
                ((PushDataSource)this.source).connect();
            }
            catch (IOException iOException) {}
            this.streams = ((PushDataSource)this.source).getStreams();
        } else {
            this.push = false;
            try {
                ((PullDataSource)this.source).connect();
            }
            catch (IOException iOException) {}
            this.streams = ((PullDataSource)this.source).getStreams();
        }
        if (this.streams == null || this.streams.length != 1) {
            throw new IncompatibleSourceException("DataSource should have 1 stream");
        }
        this.stream = this.streams[0];
        this.contentType = this.source.getContentType();
        if (this.push) {
            ((PushSourceStream)this.stream).setTransferHandler(this);
        }
    }

    public void setOutputLocator(MediaLocator output) {
        this.locator = output;
    }

    public void open() throws IOException, SecurityException {
        if (this.state == 0 && this.locator != null) {
            String pathName = this.locator.getRemainder();
            while (pathName.charAt(0) == '/' && (pathName.charAt(1) == '/' || pathName.charAt(2) == ':')) {
                pathName = pathName.substring(1);
            }
            String fileSeparator = System.getProperty("file.separator");
            if (fileSeparator.equals("\\")) {
                pathName = pathName.replace('/', '\\');
            }
            this.file = new File(pathName);
            if (this.file.exists() && !this.file.delete()) {
                System.err.println("datasink open: Existing file " + pathName + " cannot be deleted. Check if " + "some other process is using " + " this file");
                throw new IOException("Existing file " + pathName + " cannot be deleted");
            }
            String parent = this.file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            try {
                this.raFile = new RandomAccessFile(this.file, "rw");
            }
            catch (IOException e2) {
                System.err.println("datasink open: IOException when creating RandomAccessFile " + pathName);
                throw e2;
            }
            this.setState(1);
        }
    }

    public MediaLocator getOutputLocator() {
        return this.locator;
    }

    public void start() throws IOException {
        if (this.state == 1) {
            if (this.source != null) {
                this.source.start();
            }
            this.setState(2);
        }
    }

    public void stop() throws IOException {
        if (this.state == 2) {
            if (this.source != null) {
                this.source.stop();
            }
            this.setState(1);
        }
    }

    protected void setState(int state) {
        Handler handler = this;
        synchronized (handler) {
            this.state = state;
        }
    }

    public void close() {
        this.close(null);
    }

    protected final void close(String reason) {
        Handler handler = this;
        synchronized (handler) {
            if (this.state == 3) {
                Object var3_6 = null;
                return;
            }
            this.setState(3);
        }
        if (reason != null) {
            this.sendFileWritingErrorEvent(reason);
        }
        try {
            this.source.stop();
        }
        catch (IOException e2) {
            System.err.println("IOException when stopping source " + e2);
        }
        if (this.push) {
            int i2 = 0;
            while (i2 < this.streams.length) {
                ((PushSourceStream)this.streams[i2]).setTransferHandler(null);
                ++i2;
            }
        }
        try {
            if (this.raFile != null) {
                this.raFile.close();
            }
            if (this.source != null) {
                this.source.disconnect();
            }
        }
        catch (IOException e3) {
            System.out.println("close: " + e3);
        }
        this.raFile = null;
        this.fileWriterAdapter.removeAllListeners();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = this.fileWriterAdapter;
        }
        return this.controls;
    }

    public Object getControl(String controlName) {
        if (controlName.equals("javax.media.datasink.FileWriterControl")) {
            return this.fileWriterAdapter;
        }
        return null;
    }

    public synchronized void transferData(PushSourceStream pss) {
        block7: {
            int totalRead = 0;
            int spaceAvailable = 65536;
            while (spaceAvailable > 0) {
                int bytesRead = 0;
                try {
                    bytesRead = pss.read(this.buffer, totalRead, spaceAvailable);
                }
                catch (IOException iOException) {}
                if (bytesRead <= 0) {
                    if (bytesRead != -1) break;
                    this.sendEndofFileEvent();
                    break;
                }
                totalRead += bytesRead;
                spaceAvailable -= bytesRead;
            }
            if (totalRead <= 0) break block7;
            try {
                this.raFile.write(this.buffer, 0, totalRead);
                this.filePointer += totalRead;
                if (this.filePointer > this.fileSize) {
                    this.fileSize = this.filePointer;
                }
                this.fileWriterAdapter.setBytesWritten(this.fileSize);
            }
            catch (IOException ioe) {
                this.sendFileWritingErrorEvent("Error in writing: " + ioe);
            }
        }
    }

    public synchronized long seek(long where) {
        if (this.raFile != null) {
            try {
                this.raFile.seek(where);
                this.filePointer = (int)where;
                return where;
            }
            catch (IOException ioe) {
                this.sendFileWritingErrorEvent("Error in seek: " + ioe);
            }
        }
        return -1L;
    }

    public long tell() {
        if (this.raFile != null) {
            try {
                return this.raFile.getFilePointer();
            }
            catch (IOException ioe) {
                this.sendFileWritingErrorEvent("Error in tell: " + ioe);
            }
        }
        return -1L;
    }

    public boolean isRandomAccess() {
        return true;
    }

    protected final void sendFileSizeLimitReachedEvent() {
        this.fileWriterAdapter.sendEvent(new FileSizeLimitReachedEvent(this.fileWriterAdapter, "File size limit of " + this.fileWriterAdapter.getFileSizeLimit() + " reached"));
    }

    protected final void sendEndofFileEvent() {
        this.fileWriterAdapter.sendEvent(new EndOfFileEvent(this.fileWriterAdapter));
    }

    protected final void sendFileWritingErrorEvent(String reason) {
        this.fileWriterAdapter.sendEvent(new FileWritingErrorEvent(this.fileWriterAdapter, reason));
    }
}

