/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.DataSink;
import javax.media.datasink.FileWriterControl;
import javax.media.datasink.FileWriterEvent;
import javax.media.datasink.FileWriterListener;

public class FileWriterAdapter
implements FileWriterControl {
    protected long fileSizeLimit = Long.MAX_VALUE;
    protected Panel panel;
    protected Vector listenerList = new Vector(2);
    protected long bytesWritten;
    protected DataSink dataSink;
    protected TextField textBytes;

    public FileWriterAdapter(DataSink ds) {
        this.dataSink = ds;
    }

    public synchronized void setFileSizeLimit(long size) {
        this.fileSizeLimit = size;
    }

    public synchronized long getFileSizeLimit() {
        return this.fileSizeLimit;
    }

    public void addFileWriterListener(FileWriterListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listenerList.contains(listener)) {
            this.listenerList.addElement(listener);
        }
    }

    public void removeFileWriterListener(FileWriterListener listener) {
        this.listenerList.removeElement(listener);
    }

    public void removeAllListeners() {
        this.listenerList.removeAllElements();
    }

    public void sendEvent(FileWriterEvent event) {
        if (!this.listenerList.isEmpty()) {
            Vector vector = this.listenerList;
            synchronized (vector) {
                Enumeration list = this.listenerList.elements();
                while (list.hasMoreElements()) {
                    FileWriterListener listener = (FileWriterListener)list.nextElement();
                    listener.fileWriterUpdate(event);
                }
            }
        }
    }

    public void setBytesWritten(long bytesWritten) {
        if (this.textBytes != null && bytesWritten > this.bytesWritten + 1024L) {
            ((TextComponent)this.textBytes).setText(Long.toString(bytesWritten / 1024L));
        }
        this.bytesWritten = bytesWritten;
    }

    public Component getControlComponent() {
        if (this.panel == null) {
            Label lab = new Label("KBytes written: ", 0);
            Button stop = new Button("Stop");
            this.textBytes = new TextField(9);
            this.panel = new Panel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add("West", lab);
            this.panel.add("Center", this.textBytes);
            this.panel.add("East", stop);
            stop.addActionListener(new 1());
        }
        return this.panel;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            if (FileWriterAdapter.this.dataSink != null) {
                FileWriterAdapter.this.dataSink.close();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

