/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.controls.AtomicControl;
import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import java.awt.Component;
import java.util.Vector;
import javax.media.Control;

public class AtomicControlAdapter
implements AtomicControl {
    protected Component component;
    private Vector listeners;
    protected boolean isdefault = false;
    protected Control parent;
    protected boolean enabled = true;

    public AtomicControlAdapter(Component c2, boolean def, Control parent) {
        this.component = c2;
        this.isdefault = def;
        this.parent = parent;
    }

    public boolean isDefault() {
        return this.isdefault;
    }

    public void setVisible(boolean visible) {
    }

    public boolean getVisible() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.component != null) {
            this.component.setEnabled(enabled);
        }
        this.informListeners();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setParent(Control p2) {
        this.parent = p2;
    }

    public Control getParent() {
        return this.parent;
    }

    public void addControlChangeListener(ControlChangeListener ccl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (ccl != null) {
            this.listeners.addElement(ccl);
        }
    }

    public void removeControlChangeListener(ControlChangeListener ccl) {
        if (this.listeners != null && ccl != null) {
            this.listeners.removeElement(ccl);
        }
    }

    public void informListeners() {
        if (this.listeners != null) {
            int i2 = 0;
            while (i2 < this.listeners.size()) {
                ControlChangeListener ccl = (ControlChangeListener)this.listeners.elementAt(i2);
                ccl.controlChanged(new ControlChangeEvent(this));
                ++i2;
            }
        }
    }

    public String getTip() {
        return null;
    }

    public void setTip(String tip) {
    }

    public Component getControlComponent() {
        return this.component;
    }

    public boolean isReadOnly() {
        return false;
    }
}

