/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.mpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.control.QualityControl;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class MpegVideo
extends BasicCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1998, 1999.";
    static final int VERSION_BUF_LEN = 70;
    static final int MPEG_INTERNAL_BUF_SIZE = 65536;
    static final int IN_STREAM_BUF_LEN = 102400;
    static final int OUT_FRAME_BUF_LEN = 270000;
    static final int NO_PICTURE = 0;
    static final int I_PICTURE = 1;
    static final int P_PICTURE = 2;
    static final int B_PICTURE = 3;
    static final int D_PICTURE = 4;
    static final int MPEG_NOERROR = 0;
    static final int MPEG_ERROR = -1;
    static final int MPEG_PARAM_ERROR = -2;
    static final int MPEG_BUF_ERROR = -3;
    static final int MPEG_ALLOC_ERROR = -4;
    static final int MPEG_EOS = -5;
    private Object methodsSync = new Object();
    protected VideoFormat[] supportedInFormats;
    protected VideoFormat[] supportedOutFormats;
    protected VideoFormat inputFormat;
    protected VideoFormat outputFormat;
    private boolean corruptedFlag = false;
    private boolean firstTimeFlag = true;
    private boolean inputEOMFlag = false;
    private boolean processEOMFlag = false;
    private boolean initTimeFlag = true;
    private long accumulatedTimeNs;
    private long deltaPictureTimeNS;
    private long[] pdata = new long[1];
    private byte[] versionBuf = new byte[70];
    private int[] inBytesReq = new int[1];
    private int frameNumber = -1;
    private byte[] inBufByte = new byte[102400];
    private byte[] outBufByte;
    private int inDataOffset;
    private int outBufOffset;
    private int numDataBytes;
    private int numFramesBehind;
    private int dropCount;
    private int[] imgWidth = new int[1];
    private int[] imgHeight = new int[1];
    private int[] imgType = new int[1];
    private int[] inBytesRead = new int[1];
    private int[] outBufWrote = new int[1];
    private static boolean available;
    private Control[] controls;
    private DC dc;

    private native int videoInitialize(long[] var1, byte[] var2, int var3, int var4);

    private native int initImageParam(long var1, byte[] var3, int var4, int var5, int[] var6, int[] var7);

    private native int videoDecode(long var1, byte[] var3, int var4, int var5, int var6, byte[] var7, int var8, int var9, int[] var10, int[] var11, int[] var12, int[] var13, int[] var14, int[] var15);

    private native int videoTerminate(long var1);

    private native int videoReset(long var1);

    private native int videoSeek(long var1);

    public MpegVideo() {
        if (available) {
            this.supportedInFormats = new VideoFormat[2];
            this.supportedInFormats[0] = new VideoFormat("mpeg");
            this.supportedInFormats[1] = new VideoFormat("MPGI");
            this.supportedOutFormats = new VideoFormat[1];
            this.supportedOutFormats[0] = new YUVFormat(2);
        } else {
            this.supportedInFormats = new VideoFormat[0];
        }
    }

    public String getName() {
        return "MPEG-1 Video Decoder";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutFormats;
        }
        if (format instanceof VideoFormat && BasicPlugIn.matches(format, this.supportedInFormats) != null) {
            VideoFormat inf = (VideoFormat)format;
            Dimension size = inf.getSize();
            if (size == null || size.width == 0 || size.height == 0) {
                size = new Dimension(320, 240);
            }
            int area = size.width * size.height;
            YUVFormat outf = new YUVFormat(size, area + (area >> 1), Format.byteArray, inf.getFrameRate(), 2, size.width, size.width >> 1, 0, area, area + (area >> 2));
            Format[] tempFormats = new Format[]{outf};
            return tempFormats;
        }
        return new Format[0];
    }

    public Format setInputFormat(Format in) {
        if (!(in instanceof VideoFormat) || BasicPlugIn.matches(in, this.supportedInFormats) == null) {
            return null;
        }
        this.inputFormat = (VideoFormat)in;
        float ftmp = this.inputFormat.getFrameRate();
        if (ftmp != 0.0f) {
            this.deltaPictureTimeNS = (long)(1.0E9 / (double)ftmp + 0.5);
        }
        return in;
    }

    public Format setOutputFormat(Format out) {
        if (out != null && out instanceof YUVFormat && ((YUVFormat)out).getYuvType() == 2) {
            this.outputFormat = (VideoFormat)out;
            return out;
        }
        return null;
    }

    public void open() throws ResourceUnavailableException {
        if (!available) {
            throw new ResourceUnavailableException("Can't find shared library jmmpegv");
        }
        Object object = this.methodsSync;
        synchronized (object) {
            if (this.videoInitialize(this.pdata, this.versionBuf, 0, 70) != 0) {
                throw new ResourceUnavailableException("MPEG video decoder initialization failed");
            }
            available = false;
            this.inBytesReq[0] = 65536;
            this.initTimeFlag = true;
        }
    }

    public void reset() {
        Object object = this.methodsSync;
        synchronized (object) {
            System.out.println("VV >>> Frame Dropped:  " + this.dropCount + "/" + (this.frameNumber + 1));
            System.out.flush();
            this.corruptedFlag = false;
            this.inputEOMFlag = false;
            this.processEOMFlag = false;
            this.initTimeFlag = true;
            this.inBytesReq[0] = 65536;
            this.frameNumber = -1;
            this.inDataOffset = 0;
            this.outBufOffset = 0;
            this.numDataBytes = 0;
            this.numFramesBehind = 0;
            this.dropCount = 0;
            int rc = this.videoSeek(this.pdata[0]);
            if (rc != 0) {
                this.corruptedFlag = true;
            }
        }
    }

    public void close() {
        Object object = this.methodsSync;
        synchronized (object) {
            System.out.println("VV >>> Frame Dropped:  " + this.dropCount + "/" + (this.frameNumber + 1));
            System.out.flush();
            this.videoTerminate(this.pdata[0]);
            this.corruptedFlag = false;
            this.firstTimeFlag = true;
            this.inputEOMFlag = false;
            this.processEOMFlag = false;
            this.initTimeFlag = true;
            this.pdata = new long[1];
            this.inBytesReq[0] = 65536;
            this.frameNumber = -1;
            this.inDataOffset = 0;
            this.outBufOffset = 0;
            this.numDataBytes = 0;
            this.numFramesBehind = 0;
            this.dropCount = 0;
            available = true;
        }
    }

    private boolean doInit(Buffer inbuffer, Buffer outbuffer) {
        int[] imgWidth = new int[1];
        int[] imgHeight = new int[1];
        Object data = inbuffer.getData();
        int bufLen = inbuffer.getLength();
        int offset = inbuffer.getOffset();
        if (bufLen < 512) {
            return false;
        }
        int rc = this.initImageParam(this.pdata[0], (byte[])data, offset, bufLen, imgWidth, imgHeight);
        if (rc != 0) {
            return false;
        }
        int frameWriteLen = (int)((double)(imgWidth[0] * imgHeight[0]) * 1.5);
        this.outBufByte = new byte[frameWriteLen];
        Dimension size = new Dimension(imgWidth[0], imgHeight[0]);
        int area = size.width * size.height;
        this.outputFormat = new YUVFormat(size, area + (area >> 1), Format.byteArray, this.inputFormat.getFrameRate(), 2, size.width, size.width >> 1, 0, area, area + (area >> 2));
        outbuffer.setFormat(this.outputFormat);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int process(Buffer inbuffer, Buffer outbuffer) {
        this.imgWidth[0] = 0;
        this.imgHeight[0] = 0;
        this.imgType[0] = 0;
        this.inBytesRead[0] = 0;
        this.outBufWrote[0] = 0;
        int returnResult = 0;
        Object object = this.methodsSync;
        synchronized (object) {
            if (!this.checkInputBuffer(inbuffer)) {
                return 1;
            }
            if (this.processEOMFlag) {
                this.propagateEOM(outbuffer);
                return 0;
            }
            if (this.corruptedFlag) {
                return 1;
            }
            if (this.isEOM(inbuffer)) {
                this.inputEOMFlag = true;
            }
            if (this.firstTimeFlag) {
                if (!this.doInit(inbuffer, outbuffer)) {
                    return 1;
                }
                this.firstTimeFlag = false;
            }
            if (this.numDataBytes < this.inBytesReq[0] && !this.inputEOMFlag) {
                byte[] data = (byte[])inbuffer.getData();
                int bufLen = inbuffer.getLength();
                int offset = inbuffer.getOffset();
                int num2read = 102400 - this.numDataBytes - 1;
                if (this.numDataBytes > 0 && this.inDataOffset > 0) {
                    System.arraycopy(this.inBufByte, this.inDataOffset, this.inBufByte, 0, this.numDataBytes);
                }
                this.inDataOffset = 0;
                if (num2read > bufLen) {
                    num2read = bufLen;
                }
                if (num2read > 0) {
                    System.arraycopy(data, offset, this.inBufByte, this.numDataBytes, num2read);
                }
                if (num2read < bufLen) {
                    returnResult |= 2;
                }
                inbuffer.setOffset(offset + num2read);
                inbuffer.setLength(bufLen - num2read);
                if (bufLen == num2read) {
                    inbuffer.setOffset(0);
                }
                if (num2read > 0) {
                    this.numDataBytes += num2read;
                }
                if (this.numDataBytes < this.inBytesReq[0]) {
                    return returnResult | 4;
                }
            } else if (this.inputEOMFlag) {
                if (this.processEOMFlag) {
                    this.propagateEOM(outbuffer);
                    return 0;
                }
            } else {
                returnResult |= 2;
            }
            ++this.frameNumber;
            if (this.initTimeFlag) {
                this.accumulatedTimeNs = inbuffer.getTimeStamp();
                this.initTimeFlag = false;
            }
            outbuffer.setFlags(0);
            outbuffer.setTimeStamp(this.accumulatedTimeNs);
            outbuffer.setFlags(32);
            outbuffer.setSequenceNumber(this.frameNumber);
            this.accumulatedTimeNs += this.deltaPictureTimeNS;
            byte[] outData = this.validateByteArraySize(outbuffer, this.outputFormat.getMaxDataLength());
            int rc = this.videoDecode(this.pdata[0], this.inBufByte, this.inDataOffset, this.numDataBytes, this.numFramesBehind, outData, 0, this.outputFormat.getMaxDataLength(), this.imgWidth, this.imgHeight, this.imgType, this.inBytesRead, this.outBufWrote, this.inBytesReq);
            if (rc != 0) {
                if (rc == -5) {
                    this.propagateEOM(outbuffer);
                    this.processEOMFlag = true;
                    return 0;
                }
                System.out.println("MPEG VIDEO: decode process error  rc:" + rc);
                System.out.flush();
                this.corruptedFlag = true;
                return 1;
            }
            this.updateOutput(outbuffer, this.outputFormat, this.outBufWrote[0], 0);
            this.numDataBytes -= this.inBytesRead[0];
            this.inDataOffset += this.inBytesRead[0];
            if (this.outBufWrote[0] != 0) return returnResult |= 4;
            outbuffer.setDiscard(true);
            if (this.imgType[0] == 0) return returnResult |= 4;
            ++this.dropCount;
            return returnResult |= 4;
        }
    }

    public Object[] getControls() {
        if (this.dc == null) {
            this.dc = new DC();
            this.controls = new Control[1];
            this.controls[0] = this.dc;
        }
        return this.controls;
    }

    void setMpegFramesBehind(int num) {
        this.numFramesBehind = num;
    }

    static {
        try {
            JMFSecurityManager.loadLibrary("jmmpegv");
            available = true;
        }
        catch (Exception exception) {
            available = false;
        }
    }

    class DC
    implements FrameProcessingControl,
    QualityControl {
        public int getFramesDropped() {
            return 0;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean setMinimalProcessing(boolean on) {
            MpegVideo.this.setMpegFramesBehind(5);
            return true;
        }

        public void setFramesBehind(float framesBehind) {
            MpegVideo.this.setMpegFramesBehind((int)framesBehind);
        }

        public float setQuality(float quality) {
            return 1.0f;
        }

        public float getQuality() {
            return 1.0f;
        }

        public float getPreferredQuality() {
            return 1.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return false;
        }

        DC() {
            MpegVideo.this = MpegVideo.this;
        }
    }
}

