/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.sun.media.BasicCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class GainCodec
extends BasicCodec {
    private static String GainCodec = "GainCodec";
    public float gain = 2.0f;

    public void setGain(float newGain) {
        this.gain = newGain;
    }

    public String getName() {
        return GainCodec;
    }

    public GainCodec() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, -1, -1, -1, -1.0, Format.shortArray)};
        this.outputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, -1, -1, -1, -1.0, Format.shortArray)};
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (!(in instanceof AudioFormat)) {
            return this.outputFormats;
        }
        AudioFormat iaf = (AudioFormat)in;
        if (!iaf.getEncoding().equals("LINEAR") || iaf.getDataType() != Format.shortArray) {
            return new Format[0];
        }
        AudioFormat oaf = new AudioFormat("LINEAR", iaf.getSampleRate(), 16, iaf.getChannels(), 0, 1, iaf.getFrameSizeInBits(), iaf.getFrameRate(), Format.shortArray);
        return new Format[]{oaf};
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        short[] inBuffer = (short[])inputBuffer.getData();
        int inLength = inputBuffer.getLength();
        int inOffset = inputBuffer.getOffset();
        int samplesNumber = inLength;
        short[] outBuffer = this.validateShortArraySize(outputBuffer, samplesNumber);
        int i2 = 0;
        while (i2 < samplesNumber) {
            int sample = inBuffer[inOffset + i2];
            if ((sample = (int)((float)sample * this.gain)) > Short.MAX_VALUE) {
                sample = Short.MAX_VALUE;
            } else if (sample < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            outBuffer[i2] = (short)sample;
            ++i2;
        }
        this.updateOutput(outputBuffer, this.outputFormat, samplesNumber, 0);
        return 0;
    }

    public static void main(String[] args) {
        GainCodec codec = new GainCodec();
        Format[] ifmt = codec.getSupportedInputFormats();
        Format[] ofmt = codec.getSupportedOutputFormats(null);
        Buffer inp = new Buffer();
        Buffer out = new Buffer();
        short[] buffer = new short[100];
        int i2 = 0;
        while (i2 < 100) {
            buffer[i2] = (short)(i2 + 20500);
            ++i2;
        }
        inp.setData(buffer);
        inp.setLength(10);
        inp.setOffset(0);
        codec.setGain(1.6f);
        int rc = codec.process(inp, out);
        System.out.println("rc=" + rc);
        short[] outbuf = (short[])out.getData();
        System.out.println("length=" + out.getLength());
        System.out.println("offset=" + out.getOffset());
        int i3 = 0;
        while (i3 < outbuf.length) {
            System.out.println(String.valueOf(i3) + " " + outbuf[i3]);
            ++i3;
        }
        inp.setLength(0);
        inp.setEOM(true);
        rc = codec.process(inp, out);
        System.out.println("rc=" + rc);
        outbuf = (short[])out.getData();
        System.out.println("length=" + out.getLength());
        System.out.println("offset=" + out.getOffset());
        int i4 = 0;
        while (i4 < outbuf.length) {
            System.out.println(String.valueOf(i4) + " " + outbuf[i4]);
            ++i4;
        }
    }
}

