/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.VideoFormatChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;

public class SaveAsVideoPanel
extends Panel
implements ActionListener {
    private TrackControl trackControl;
    private VideoFormat formatOld;
    private Format[] arrSupportedFormats;
    private Vector vectorContSuppFormats = new Vector();
    private String strContentType;
    private ActionListener listenerEnableTrack;
    private VideoFormatChooser chooserVideoFormat;

    public SaveAsVideoPanel(TrackControl trackControl, ActionListener listenerEnableTrack) {
        this.trackControl = trackControl;
        this.listenerEnableTrack = listenerEnableTrack;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setContentType(String strContentType) {
        this.arrSupportedFormats = this.trackControl.getSupportedFormats();
        this.strContentType = strContentType;
        int nSize = this.arrSupportedFormats.length;
        this.vectorContSuppFormats = new Vector();
        int i2 = 0;
        while (i2 < nSize) {
            if (this.arrSupportedFormats[i2] instanceof VideoFormat) {
                VideoFormat formatVideo = (VideoFormat)this.arrSupportedFormats[i2];
                this.vectorContSuppFormats.addElement(formatVideo);
            }
            ++i2;
        }
        this.chooserVideoFormat.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void updateTrack() {
        if (!this.chooserVideoFormat.isTrackEnabled()) {
            this.trackControl.setEnabled(false);
            return;
        }
        Format format = this.chooserVideoFormat.getFormat();
        if (format == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match chosen video format.Track will be disabled.");
            this.trackControl.setEnabled(false);
        } else {
            this.trackControl.setEnabled(true);
            this.trackControl.setFormat(format);
        }
    }

    private void init() throws Exception {
        this.formatOld = (VideoFormat)this.trackControl.getFormat();
        this.arrSupportedFormats = this.trackControl.getSupportedFormats();
        this.setLayout(new BorderLayout());
        this.chooserVideoFormat = new VideoFormatChooser(this.arrSupportedFormats, this.formatOld, true, this);
        this.add((Component)this.chooserVideoFormat, "North");
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals("ACTION_VIDEO_TRACK_ENABLED")) {
            ActionEvent eventNew = new ActionEvent(this, 1001, event.getActionCommand());
            this.listenerEnableTrack.actionPerformed(eventNew);
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_DISABLED")) {
            ActionEvent eventNew = new ActionEvent(this, 1001, event.getActionCommand());
            this.listenerEnableTrack.actionPerformed(eventNew);
        }
    }

    private Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }
}

