/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.AudioFormatChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;

public class SaveAsAudioPanel
extends Panel
implements ActionListener {
    private TrackControl trackControl;
    private AudioFormat formatOld;
    private Format[] arrSupportedFormats;
    private Vector vectorContSuppFormats = new Vector();
    private String strContentType;
    private ActionListener listenerEnableTrack;
    private AudioFormatChooser chooserAudioFormat;

    public SaveAsAudioPanel(TrackControl trackControl, ActionListener listenerEnableTrack) {
        this.trackControl = trackControl;
        this.listenerEnableTrack = listenerEnableTrack;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setContentType(String strContentType) {
        this.arrSupportedFormats = this.trackControl.getSupportedFormats();
        this.strContentType = strContentType;
        int nSize = this.arrSupportedFormats.length;
        this.vectorContSuppFormats = new Vector();
        int i2 = 0;
        while (i2 < nSize) {
            if (this.arrSupportedFormats[i2] instanceof AudioFormat) {
                AudioFormat formatAudio = (AudioFormat)this.arrSupportedFormats[i2];
                this.vectorContSuppFormats.addElement(formatAudio);
            }
            ++i2;
        }
        this.chooserAudioFormat.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void updateTrack() {
        if (!this.chooserAudioFormat.isTrackEnabled()) {
            this.trackControl.setEnabled(false);
            return;
        }
        Format format = this.chooserAudioFormat.getFormat();
        if (format == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match choosen audio format. Track will be disabled.");
            this.trackControl.setEnabled(false);
        } else {
            this.trackControl.setEnabled(true);
            this.trackControl.setFormat(format);
        }
    }

    private void init() throws Exception {
        this.formatOld = (AudioFormat)this.trackControl.getFormat();
        this.arrSupportedFormats = this.trackControl.getSupportedFormats();
        this.setLayout(new BorderLayout());
        this.chooserAudioFormat = new AudioFormatChooser(this.arrSupportedFormats, this.formatOld, true, this);
        this.add((Component)this.chooserAudioFormat, "North");
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            ActionEvent eventNew = new ActionEvent(this, 1001, event.getActionCommand());
            this.listenerEnableTrack.actionPerformed(eventNew);
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_DISABLED")) {
            ActionEvent eventNew = new ActionEvent(this, 1001, event.getActionCommand());
            this.listenerEnableTrack.actionPerformed(eventNew);
        }
    }

    private Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }
}

