/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class PanelMediaTargetNetwork
extends Panel
implements TextListener {
    private Panel panelLabels;
    private Panel panelAddress;
    private Panel panelPort;
    private Panel panelTtl;
    private TextField[][] arrTextVideoTrackAddress;
    private TextField[][] arrTextAudioTrackAddress;
    private TextField[] arrTextVideoPort;
    private TextField[] arrTextAudioPort;
    private Choice[] arrComboVideoTtl;
    private Choice[] arrComboAudioTtl;
    private int nVideoCount;
    private int nAudioCount;
    private static final int MAX_TRACK_COUNT = 8;

    public PanelMediaTargetNetwork() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String[] getVideoAddresses() {
        String[] arrValues = new String[this.nVideoCount];
        int i2 = 0;
        while (i2 < this.nVideoCount) {
            arrValues[i2] = this.arrTextVideoTrackAddress[i2][0].getText().trim();
            int j2 = 1;
            while (j2 < 4) {
                arrValues[i2] = String.valueOf(arrValues[i2]) + "." + this.arrTextVideoTrackAddress[i2][j2].getText().trim();
                ++j2;
            }
            ++i2;
        }
        return arrValues;
    }

    public String[] getAudioAddresses() {
        String[] arrValues = new String[this.nAudioCount];
        int i2 = 0;
        while (i2 < this.nAudioCount) {
            arrValues[i2] = this.arrTextAudioTrackAddress[i2][0].getText().trim();
            int j2 = 1;
            while (j2 < 4) {
                arrValues[i2] = String.valueOf(arrValues[i2]) + "." + this.arrTextAudioTrackAddress[i2][j2].getText().trim();
                ++j2;
            }
            ++i2;
        }
        return arrValues;
    }

    public String[] getVideoPorts() {
        String[] arrValues = new String[this.nVideoCount];
        int i2 = 0;
        while (i2 < this.nVideoCount) {
            arrValues[i2] = this.arrTextVideoPort[i2].getText().trim();
            ++i2;
        }
        return arrValues;
    }

    public String[] getAudioPorts() {
        String[] arrValues = new String[this.nAudioCount];
        int i2 = 0;
        while (i2 < this.nAudioCount) {
            arrValues[i2] = this.arrTextAudioPort[i2].getText().trim();
            ++i2;
        }
        return arrValues;
    }

    public String[] getVideoTtls() {
        String[] arrValues = new String[this.nVideoCount];
        int i2 = 0;
        while (i2 < this.nVideoCount) {
            arrValues[i2] = this.arrComboVideoTtl[i2].getSelectedItem().trim();
            ++i2;
        }
        return arrValues;
    }

    public String[] getAudioTtls() {
        String[] arrValues = new String[this.nAudioCount];
        int i2 = 0;
        while (i2 < this.nAudioCount) {
            arrValues[i2] = this.arrComboAudioTtl[i2].getSelectedItem().trim();
            ++i2;
        }
        return arrValues;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "North");
        Panel panelDescription = new Panel(new GridLayout(0, 1));
        panel.add((Component)panelDescription, "North");
        panelDescription.add(new Label("Enter the Session Address and Port Number for each track"));
        panelDescription.add(new Label("to export. (e.g. address: 224.123.111.101 & port: 22224)"));
        this.panelLabels = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)this.panelLabels, "West");
        this.panelAddress = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)this.panelAddress, "Center");
        Panel panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "East");
        this.panelPort = new Panel(new GridLayout(0, 1, 6, 6));
        panelTemp.add((Component)this.panelPort, "Center");
        this.panelTtl = new Panel(new GridLayout(0, 1, 6, 6));
        panelTemp.add((Component)this.panelTtl, "East");
        this.arrTextVideoTrackAddress = new TextField[8][4];
        this.arrTextAudioTrackAddress = new TextField[8][4];
        this.arrTextVideoPort = new TextField[8];
        this.arrTextAudioPort = new TextField[8];
        this.arrComboVideoTtl = new Choice[8];
        this.arrComboAudioTtl = new Choice[8];
        int i2 = 0;
        while (i2 < 8) {
            int j2 = 0;
            while (j2 < 4) {
                this.arrTextVideoTrackAddress[i2][j2] = new TextField();
                this.arrTextVideoTrackAddress[i2][j2].addTextListener(this);
                this.arrTextAudioTrackAddress[i2][j2] = new TextField();
                this.arrTextAudioTrackAddress[i2][j2].addTextListener(this);
                ++j2;
            }
            this.arrTextVideoPort[i2] = new TextField(5);
            this.arrTextAudioPort[i2] = new TextField(5);
            this.arrComboVideoTtl[i2] = new Choice();
            this.arrComboVideoTtl[i2].addItem("1");
            this.arrComboVideoTtl[i2].addItem("2");
            this.arrComboVideoTtl[i2].addItem("3");
            this.arrComboVideoTtl[i2].addItem("4");
            this.arrComboVideoTtl[i2].addItem("8");
            this.arrComboVideoTtl[i2].addItem("16");
            this.arrComboVideoTtl[i2].addItem("32");
            this.arrComboVideoTtl[i2].addItem("64");
            this.arrComboVideoTtl[i2].addItem("128");
            this.arrComboVideoTtl[i2].addItem("255");
            this.arrComboAudioTtl[i2] = new Choice();
            this.arrComboAudioTtl[i2].addItem("1");
            this.arrComboAudioTtl[i2].addItem("2");
            this.arrComboAudioTtl[i2].addItem("3");
            this.arrComboAudioTtl[i2].addItem("4");
            this.arrComboAudioTtl[i2].addItem("8");
            this.arrComboAudioTtl[i2].addItem("16");
            this.arrComboAudioTtl[i2].addItem("32");
            this.arrComboAudioTtl[i2].addItem("64");
            this.arrComboAudioTtl[i2].addItem("128");
            this.arrComboAudioTtl[i2].addItem("255");
            ++i2;
        }
    }

    public void setTracks(boolean[] arrVideoTracksEnabled, boolean[] arrAudioTracksEnabled) {
        int j2;
        Panel panelAddressEntry;
        this.nVideoCount = arrVideoTracksEnabled.length;
        this.nAudioCount = arrAudioTracksEnabled.length;
        this.panelLabels.removeAll();
        this.panelAddress.removeAll();
        this.panelPort.removeAll();
        this.panelTtl.removeAll();
        Label label = new Label("Track:", 1);
        this.panelLabels.add(label);
        label = new Label("Session Address:", 1);
        this.panelAddress.add(label);
        label = new Label("Port:", 1);
        this.panelPort.add(label);
        label = new Label("TTL:", 1);
        this.panelTtl.add(label);
        int i2 = 0;
        while (i2 < this.nVideoCount) {
            label = new Label("Video " + (i2 + 1), 0);
            label.setEnabled(arrVideoTracksEnabled[i2]);
            this.panelLabels.add(label);
            panelAddressEntry = new Panel(new GridLayout(1, 0, 2, 2));
            this.panelAddress.add(panelAddressEntry);
            j2 = 0;
            while (j2 < 4) {
                this.arrTextVideoTrackAddress[i2][j2].setEnabled(arrVideoTracksEnabled[i2]);
                panelAddressEntry.add(this.arrTextVideoTrackAddress[i2][j2]);
                ++j2;
            }
            this.arrTextVideoPort[i2].setEnabled(arrVideoTracksEnabled[i2]);
            this.panelPort.add(this.arrTextVideoPort[i2]);
            this.arrComboVideoTtl[i2].setEnabled(arrVideoTracksEnabled[i2]);
            this.panelTtl.add(this.arrComboVideoTtl[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nAudioCount) {
            label = new Label("Audio " + (i2 + 1), 0);
            label.setEnabled(arrAudioTracksEnabled[i2]);
            this.panelLabels.add(label);
            panelAddressEntry = new Panel(new GridLayout(1, 0, 2, 2));
            this.panelAddress.add(panelAddressEntry);
            j2 = 0;
            while (j2 < 4) {
                this.arrTextAudioTrackAddress[i2][j2].setEnabled(arrAudioTracksEnabled[i2]);
                panelAddressEntry.add(this.arrTextAudioTrackAddress[i2][j2]);
                ++j2;
            }
            this.arrTextAudioPort[i2].setEnabled(arrAudioTracksEnabled[i2]);
            this.panelPort.add(this.arrTextAudioPort[i2]);
            this.arrComboAudioTtl[i2].setEnabled(arrAudioTracksEnabled[i2]);
            this.panelTtl.add(this.arrComboAudioTtl[i2]);
            ++i2;
        }
    }

    public void textValueChanged(TextEvent event) {
        TextField textField;
        String strValue;
        Object objectSource = event.getSource();
        if (objectSource instanceof TextField && (strValue = (textField = (TextField)objectSource).getText()).length() > 2) {
            textField.transferFocus();
        }
    }

    public boolean checkValidFields(boolean boolDisplayMessage) {
        int nValue;
        String strValue;
        int j2;
        int i2 = 0;
        while (i2 < this.nVideoCount) {
            j2 = 0;
            while (j2 < 4) {
                if (this.arrTextVideoTrackAddress[i2][j2].isEnabled()) {
                    strValue = this.arrTextVideoTrackAddress[i2][j2].getText();
                    try {
                        nValue = Integer.valueOf(strValue);
                    }
                    catch (Exception exception) {
                        nValue = -1;
                    }
                    if (nValue < 0 || nValue > 255) {
                        if (boolDisplayMessage) {
                            MessageDialog.createErrorDialog(this.getFrame(), "Invalid session address for Video " + (i2 + 1));
                        }
                        return false;
                    }
                }
                ++j2;
            }
            if (this.arrTextVideoPort[i2].isEnabled()) {
                strValue = this.arrTextVideoPort[i2].getText();
                try {
                    nValue = Integer.valueOf(strValue);
                }
                catch (Exception exception) {
                    nValue = -1;
                }
                if (nValue < 0 || (nValue & 1) == 1) {
                    if (boolDisplayMessage) {
                        MessageDialog.createErrorDialog(this.getFrame(), "Invalid port number for Video " + (i2 + 1));
                    }
                    return false;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nAudioCount) {
            j2 = 0;
            while (j2 < 4) {
                if (this.arrTextAudioTrackAddress[i2][j2].isEnabled()) {
                    strValue = this.arrTextAudioTrackAddress[i2][j2].getText();
                    try {
                        nValue = Integer.valueOf(strValue);
                    }
                    catch (Exception exception) {
                        nValue = -1;
                    }
                    if (nValue < 0 || nValue > 255) {
                        if (boolDisplayMessage) {
                            MessageDialog.createErrorDialog(this.getFrame(), "Invalid session address for Audio " + (i2 + 1));
                        }
                        return false;
                    }
                }
                ++j2;
            }
            if (this.arrTextAudioPort[i2].isEnabled()) {
                strValue = this.arrTextAudioPort[i2].getText();
                try {
                    nValue = Integer.valueOf(strValue);
                }
                catch (Exception exception) {
                    nValue = -1;
                }
                if (nValue < 0 || (nValue & 1) == 1) {
                    if (boolDisplayMessage) {
                        MessageDialog.createErrorDialog(this.getFrame(), "Invalid port number for Audio " + (i2 + 1));
                    }
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    private Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }
}

