/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

abstract class AbstractFilter
extends OutputStream {
    protected char[] translationTable = latin1TranslationTable;
    protected boolean[] specialsTable = noSpecialsTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;

    static {
        noSpecialsTable = new boolean[256];
        int n = 0;
        while (n < 256) {
            AbstractFilter.noSpecialsTable[n] = false;
            ++n;
        }
        allSpecialsTable = new boolean[256];
        n = 0;
        while (n < 256) {
            AbstractFilter.allSpecialsTable[n] = true;
            ++n;
        }
        latin1TranslationTable = new char[256];
        n = 0;
        while (n < 256) {
            AbstractFilter.latin1TranslationTable[n] = (char)n;
            ++n;
        }
    }

    public void readFromReader(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray)) >= 0) {
            int n2 = 0;
            while (n2 < n) {
                this.write(cArray[n2]);
                ++n2;
            }
        }
    }

    public void readFromStream(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) >= 0) {
            this.write(byArray, 0, n);
        }
    }

    protected abstract void write(char var1) throws IOException;

    public void write(int n) throws IOException {
        if (n < 0) {
            n += 256;
        }
        if (this.specialsTable[n]) {
            this.writeSpecial(n);
        } else {
            char c = this.translationTable[n];
            if (c != '\u0000') {
                this.write(c);
            }
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write(string.charAt(n2));
            ++n2;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        StringBuffer stringBuffer = null;
        while (n2 > 0) {
            short s = byArray[n];
            if (s < 0) {
                s = (short)(s + 256);
            }
            if (this.specialsTable[s]) {
                if (stringBuffer != null) {
                    this.write(stringBuffer.toString());
                    stringBuffer = null;
                }
                this.writeSpecial(s);
            } else {
                char c = this.translationTable[s];
                if (c != '\u0000') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
            }
            --n2;
            ++n;
        }
        if (stringBuffer != null) {
            this.write(stringBuffer.toString());
        }
    }

    protected abstract void writeSpecial(int var1) throws IOException;
}

