/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.JIntegerTextField;
import javax.swing.colorchooser.SmartGridLayout;
import javax.swing.colorchooser.SyntheticImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel {
    float[] hsb = new float[3];
    AbstractHSBImage palette;
    AbstractHSBImage sliderPalette;
    JSlider slider;
    JIntegerTextField hField;
    JIntegerTextField sField;
    JIntegerTextField bField;
    JTextField redField;
    JTextField greenField;
    JTextField blueField;
    boolean isAdjusting = false;
    boolean isUpdatingOften = false;
    Point paletteSelection = new Point();
    JLabel paletteLabel;
    JLabel sliderPaletteLabel;
    JRadioButton hRadio;
    JRadioButton sRadio;
    JRadioButton bRadio;
    Image paletteImage;
    Image sliderImage;
    static final int PALETTE_DIMENSION = 200;
    static final int MAX_HUE_VALUE = 359;
    static final int MAX_SATURATION_VALUE = 99;
    static final int MAX_BRIGHTNESS_VALUE = 99;
    int sliderType = 0;
    static final int HUE_SLIDER = 0;
    static final int SATURATION_SLIDER = 1;
    static final int BRIGHTNESS_SLIDER = 2;

    protected void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(mouseEvent.getX(), mouseEvent.getY(), DefaultHSBChooserPanel.this.hsb);
                DefaultHSBChooserPanel.this.updateHSB(DefaultHSBChooserPanel.this.hsb[0], DefaultHSBChooserPanel.this.hsb[1], DefaultHSBChooserPanel.this.hsb[2]);
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = DefaultHSBChooserPanel.this.paletteLabel.getWidth();
                int n2 = DefaultHSBChooserPanel.this.paletteLabel.getHeight();
                int n3 = mouseEvent.getX();
                int n4 = mouseEvent.getY();
                if (n3 >= n) {
                    n3 = n - 1;
                }
                if (n4 >= n2) {
                    n4 = n2 - 1;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(n3, n4, DefaultHSBChooserPanel.this.hsb);
                DefaultHSBChooserPanel.this.updateHSB(DefaultHSBChooserPanel.this.hsb[0], DefaultHSBChooserPanel.this.hsb[1], DefaultHSBChooserPanel.this.hsb[2]);
            }
        });
    }

    protected void addSliderListeners() {
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = DefaultHSBChooserPanel.this.slider.getModel().getValueIsAdjusting();
                if (bl && DefaultHSBChooserPanel.this.isUpdatingOften || !bl) {
                    int n = DefaultHSBChooserPanel.this.slider.getValue();
                    int n2 = DefaultHSBChooserPanel.this.slider.getMaximum() + 1;
                    float f = (float)n / (float)n2;
                    int n3 = DefaultHSBChooserPanel.this.paletteSelection.x;
                    int n4 = DefaultHSBChooserPanel.this.paletteSelection.y;
                    DefaultHSBChooserPanel.this.palette.getHSBForLocation(n3, n4, DefaultHSBChooserPanel.this.hsb);
                    switch (DefaultHSBChooserPanel.this.sliderType) {
                        case 0: {
                            DefaultHSBChooserPanel.this.updateHSB(f, DefaultHSBChooserPanel.this.hsb[1], DefaultHSBChooserPanel.this.hsb[2]);
                            break;
                        }
                        case 1: {
                            DefaultHSBChooserPanel.this.updateHSB(DefaultHSBChooserPanel.this.hsb[0], f, DefaultHSBChooserPanel.this.hsb[2]);
                            break;
                        }
                        case 2: {
                            DefaultHSBChooserPanel.this.updateHSB(DefaultHSBChooserPanel.this.hsb[0], DefaultHSBChooserPanel.this.hsb[1], f);
                            break;
                        }
                    }
                }
            }
        });
    }

    protected void buildChooser() {
        Color color = this.getColorFromModel();
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.hsb);
        this.setLayout(new BorderLayout());
        JComponent jComponent = this.buildSliderPalettePanel();
        this.add((Component)jComponent, "West");
        JPanel jPanel = new JPanel(new SmartGridLayout(1, 3));
        JComponent jComponent2 = this.buildHSBControls();
        jPanel.add(jComponent2);
        jPanel.add(new JLabel(" "));
        JComponent jComponent3 = this.buildRGBControls();
        jPanel.add(jComponent3);
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)jPanel, "Center");
    }

    protected JComponent buildHSBControls() {
        String string = UIManager.getString("ColorChooser.hsbHueText");
        String string2 = UIManager.getString("ColorChooser.hsbSaturationText");
        String string3 = UIManager.getString("ColorChooser.hsbBrightnessText");
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        this.hField = new JIntegerTextField(0, 359, (int)(this.hsb[0] * 359.0f));
        this.sField = new JIntegerTextField(0, 100, (int)(this.hsb[1] * 100.0f));
        this.bField = new JIntegerTextField(0, 100, (int)(this.hsb[2] * 100.0f));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.hRadio = new JRadioButton(string);
        buttonGroup.add(this.hRadio);
        this.hRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultHSBChooserPanel.this.setHueMode();
            }
        });
        this.sRadio = new JRadioButton(string2);
        buttonGroup.add(this.sRadio);
        this.sRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultHSBChooserPanel.this.setSaturationMode();
            }
        });
        this.bRadio = new JRadioButton(string3);
        buttonGroup.add(this.bRadio);
        this.bRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultHSBChooserPanel.this.setBrightnessMode();
            }
        });
        this.hRadio.setSelected(true);
        NumberListener numberListener = new NumberListener();
        this.hField.getDocument().addDocumentListener(numberListener);
        this.sField.getDocument().addDocumentListener(numberListener);
        this.bField.getDocument().addDocumentListener(numberListener);
        jPanel.add(this.hRadio);
        jPanel.add(this.hField);
        jPanel.add(this.sRadio);
        jPanel.add(this.sField);
        jPanel.add(this.bRadio);
        jPanel.add(this.bField);
        return jPanel;
    }

    protected JComponent buildRGBControls() {
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        Color color = this.getColorFromModel();
        this.redField = new JTextField(String.valueOf(color.getRed()));
        this.redField.setEditable(false);
        this.greenField = new JTextField(String.valueOf(color.getGreen()));
        this.greenField.setEditable(false);
        this.blueField = new JTextField(String.valueOf(color.getBlue()));
        this.blueField.setEditable(false);
        String string = UIManager.getString("ColorChooser.hsbRedText");
        String string2 = UIManager.getString("ColorChooser.hsbGreenText");
        String string3 = UIManager.getString("ColorChooser.hsbBlueText");
        jPanel.add(new JLabel(string));
        jPanel.add(this.redField);
        jPanel.add(new JLabel(string2));
        jPanel.add(this.greenField);
        jPanel.add(new JLabel(string3));
        jPanel.add(this.blueField);
        return jPanel;
    }

    protected JComponent buildSliderPalettePanel() {
        JPanel jPanel = new JPanel();
        this.palette = new SaturationBrightnessImage(200, 200, this.hsb[0]);
        this.sliderPalette = new HueImage(16, 200);
        this.slider = new JSlider(1, 0, 359, 0);
        this.slider.setPaintTrack(false);
        Dimension dimension = this.slider.getPreferredSize();
        this.slider.setPreferredSize(new Dimension(dimension.width, 215));
        this.slider.setInverted(true);
        this.addSliderListeners();
        this.paletteLabel = this.createPaletteLabel();
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.addPaletteListeners();
        jPanel.add(this.paletteLabel);
        jPanel.add(this.slider);
        this.sliderPaletteLabel = new JLabel();
        this.sliderImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderImage));
        jPanel.add(this.sliderPaletteLabel);
        return jPanel;
    }

    protected JLabel createPaletteLabel() {
        return new JLabel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setColor(Color.white);
                graphics.drawOval(DefaultHSBChooserPanel.this.paletteSelection.x - 4, DefaultHSBChooserPanel.this.paletteSelection.y - 4, 8, 8);
            }
        };
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.hsbNameText");
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    protected void repaintPaletteSelection() {
        this.paletteLabel.repaint();
    }

    protected void setBrightnessMode() {
        this.sliderType = 2;
        this.slider.setInverted(false);
        this.slider.setMaximum(99);
        this.palette = new HueSaturationImage(200, 200, this.hsb[0], this.hsb[2]);
        this.sliderPalette = new BrightnessImage(16, 200, this.hsb[0]);
        this.paletteImage.flush();
        this.sliderImage.flush();
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderImage));
        this.updateHSB(this.hsb[0], this.hsb[1], this.hsb[2]);
        this.repaint();
    }

    protected void setHueMode() {
        this.sliderType = 0;
        this.slider.setInverted(true);
        this.slider.setMaximum(359);
        this.palette = new SaturationBrightnessImage(200, 200, this.hsb[0]);
        this.sliderPalette = new HueImage(16, 200);
        this.paletteImage.flush();
        this.sliderImage.flush();
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderImage));
        this.updateHSB(this.hsb[0], this.hsb[1], this.hsb[2]);
        this.repaint();
    }

    protected void setSaturationMode() {
        this.sliderType = 1;
        this.slider.setInverted(false);
        this.slider.setMaximum(99);
        this.palette = new HueBrightnessImage(200, 200, this.hsb[0], this.hsb[1]);
        this.sliderPalette = new SaturationImage(16, 200, this.hsb[0]);
        this.paletteImage.flush();
        this.sliderImage.flush();
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderImage));
        this.updateHSB(this.hsb[0], this.hsb[1], this.hsb[2]);
        this.repaint();
    }

    public void updateChooser() {
        if (!this.isAdjusting) {
            Color color = this.getColorFromModel();
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.hsb);
            this.updateHSB(this.hsb[0], this.hsb[1], this.hsb[2]);
        }
    }

    protected void updateHSB(float f, float f2, float f3) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.updatePalette(f, f2, f3);
            this.updateSliderPalette(f, f2, f3);
            this.updateSlider(f, f2, f3);
            this.updateHSBTextFields(f, f2, f3);
            Color color = new Color(this.palette.getRGBForLocation(this.paletteSelection.x, this.paletteSelection.y));
            this.updateRGBTextFields(color);
            this.getColorSelectionModel().setSelectedColor(color);
            this.isAdjusting = false;
        }
    }

    protected void updateHSBTextFields(float f, float f2, float f3) {
        int n = Math.round(f * 359.0f);
        int n2 = Math.round(f2 * 100.0f);
        int n3 = Math.round(f3 * 100.0f);
        if (this.hField.getIntegerValue() != n) {
            this.hField.setText(String.valueOf(n));
        }
        if (this.sField.getIntegerValue() != n2) {
            this.sField.setText(String.valueOf(n2));
        }
        if (this.bField.getIntegerValue() != n3) {
            this.bField.setText(String.valueOf(n3));
        }
    }

    protected void updatePalette(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        switch (this.sliderType) {
            case 0: {
                if (f != this.palette.getHue()) {
                    this.palette.setHue(f);
                    this.palette.nextFrame(0);
                }
                n = 200 - (int)(f2 * 200.0f);
                n2 = 200 - (int)(f3 * 200.0f);
                break;
            }
            case 1: {
                if (f2 != this.palette.getSaturation()) {
                    this.palette.setSaturation(f2);
                    this.palette.nextFrame(0);
                }
                n = (int)(f * 200.0f);
                n2 = 200 - (int)(f3 * 200.0f);
                break;
            }
            case 2: {
                if (f3 != this.palette.getBrightness()) {
                    this.palette.setBrightness(f3);
                    this.palette.nextFrame(0);
                }
                n = (int)(f * 200.0f);
                n2 = 200 - (int)(f2 * 200.0f);
                break;
            }
        }
        this.paletteSelection.setLocation(n, n2);
        this.repaintPaletteSelection();
    }

    protected void updateRGBTextFields(Color color) {
        this.redField.setText(String.valueOf(color.getRed()));
        this.greenField.setText(String.valueOf(color.getGreen()));
        this.blueField.setText(String.valueOf(color.getBlue()));
    }

    protected void updateSlider(float f, float f2, float f3) {
        float f4 = 0.0f;
        switch (this.sliderType) {
            case 0: {
                f4 = f;
                break;
            }
            case 1: {
                f4 = f2;
                break;
            }
            case 2: {
                f4 = f3;
                break;
            }
        }
        this.slider.setValue(Math.round(f4 * (float)(this.slider.getMaximum() + 1)));
    }

    protected void updateSliderPalette(float f, float f2, float f3) {
        if (this.sliderType != 0 && f != this.sliderPalette.getHue()) {
            this.sliderPalette.setHue(f);
            this.sliderPalette.nextFrame(0);
        }
    }

    class NumberListener
    implements DocumentListener {
        NumberListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updatePanel(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updatePanel(documentEvent);
        }

        private void updatePanel(DocumentEvent documentEvent) {
            float f = (float)DefaultHSBChooserPanel.this.hField.getIntegerValue() / 359.0f;
            float f2 = (float)DefaultHSBChooserPanel.this.sField.getIntegerValue() / 100.0f;
            float f3 = (float)DefaultHSBChooserPanel.this.bField.getIntegerValue() / 100.0f;
            DefaultHSBChooserPanel.this.updateHSB(f, f2, f3);
        }
    }

    abstract class AbstractHSBImage
    extends SyntheticImage {
        protected float h = 0.0f;
        protected float s = 0.0f;
        protected float b = 0.0f;
        protected float[] hsb = new float[3];
        protected boolean isDirty = true;

        protected AbstractHSBImage(int n, int n2, float f, float f2, float f3) {
            super(n, n2);
            this.setHSB(f, f2, f3);
        }

        protected int HSBtoRGB(float f, float f2, float f3) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (f2 == 0.0f) {
                n2 = n3 = (int)(f3 * 255.0f);
                n = n3;
            } else {
                double d = (double)f3 * 255.0;
                int n4 = (int)d;
                double d2 = f >= 0.0f ? (double)(f - (float)((int)f)) : (double)f - Math.floor(f);
                int n5 = (int)(d2 *= 6.0);
                double d3 = d2 - (double)n5;
                int n6 = (int)(d * (1.0 - (double)f2));
                int n7 = (int)(d * (1.0 - (double)f2 * d3));
                int n8 = (int)(d * (1.0 - (double)f2 * (1.0 - d3)));
                switch (n5) {
                    case 0: {
                        n = n4;
                        n2 = n8;
                        n3 = n6;
                        break;
                    }
                    case 1: {
                        n = n7;
                        n2 = n4;
                        n3 = n6;
                        break;
                    }
                    case 2: {
                        n = n6;
                        n2 = n4;
                        n3 = n8;
                        break;
                    }
                    case 3: {
                        n = n6;
                        n2 = n7;
                        n3 = n4;
                        break;
                    }
                    case 4: {
                        n = n8;
                        n2 = n6;
                        n3 = n4;
                        break;
                    }
                    case 5: {
                        n = n4;
                        n2 = n6;
                        n3 = n7;
                        break;
                    }
                }
            }
            return 0xFF000000 | n << 16 | n2 << 8 | n3;
        }

        public synchronized void addConsumer(ImageConsumer imageConsumer) {
            this.isDirty = true;
            super.addConsumer(imageConsumer);
        }

        protected void computeRow(int n, int[] nArray) {
            if (n == 0) {
                AbstractHSBImage abstractHSBImage = this;
                synchronized (abstractHSBImage) {
                    try {
                        while (!this.isDirty) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                    this.isDirty = false;
                }
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = this.getRGBForLocation(n2, n);
                ++n2;
            }
        }

        public final float getBrightness() {
            return this.b;
        }

        public abstract void getHSBForLocation(int var1, int var2, float[] var3);

        public final float getHue() {
            return this.h;
        }

        public int getRGBForLocation(int n, int n2) {
            this.getHSBForLocation(n, n2, this.hsb);
            return this.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        }

        public int getRGBForMouseEvent(MouseEvent mouseEvent) {
            return this.getRGBForLocation(mouseEvent.getX(), mouseEvent.getY());
        }

        public final float getSaturation() {
            return this.s;
        }

        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame(int n) {
            this.isDirty = true;
            this.notifyAll();
        }

        public final void setBrightness(float f) {
            this.b = f;
        }

        public void setHSB(float f, float f2, float f3) {
            this.setHue(f);
            this.setSaturation(f2);
            this.setBrightness(f3);
        }

        public final void setHue(float f) {
            this.h = f;
        }

        public final void setSaturation(float f) {
            this.s = f;
        }
    }

    class SaturationBrightnessImage
    extends AbstractHSBImage {
        public SaturationBrightnessImage(int n, int n2, float f) {
            super(n, n2, f, 1.0f, 1.0f);
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            float f = (float)n / (float)this.width;
            float f2 = (float)n2 / (float)this.height;
            fArray[0] = this.h;
            fArray[1] = this.s - f;
            fArray[2] = this.b - f2;
        }
    }

    class HueBrightnessImage
    extends AbstractHSBImage {
        public HueBrightnessImage(int n, int n2, float f, float f2) {
            super(n, n2, f, f2, 1.0f);
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            float f = (float)n2 / (float)this.height;
            float f2 = 1.0f / (float)this.width;
            fArray[0] = (float)n * f2;
            fArray[1] = this.s;
            fArray[2] = 1.0f - f;
        }
    }

    class HueSaturationImage
    extends AbstractHSBImage {
        public HueSaturationImage(int n, int n2, float f, float f2) {
            super(n, n2, f, 1.0f, f2);
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            float f = (float)n2 / (float)this.height;
            float f2 = 1.0f / (float)this.width;
            fArray[0] = (float)n * f2;
            fArray[1] = 1.0f - f;
            fArray[2] = this.b;
        }
    }

    class BrightnessImage
    extends AbstractHSBImage {
        protected int cachedY = -1;
        protected int cachedColor = 0;

        public BrightnessImage(int n, int n2, float f) {
            super(n, n2, f, 1.0f, 1.0f);
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            float f = (float)n2 / (float)this.height;
            fArray[0] = this.h;
            fArray[1] = this.s;
            fArray[2] = this.b - f;
        }

        public int getRGBForLocation(int n, int n2) {
            if (n2 != this.cachedY) {
                this.cachedY = n2;
                this.cachedColor = super.getRGBForLocation(n, n2);
            }
            return this.cachedColor;
        }
    }

    class SaturationImage
    extends AbstractHSBImage {
        protected int cachedY = -1;
        protected int cachedColor = 0;

        public SaturationImage(int n, int n2, float f) {
            super(n, n2, f, 1.0f, 1.0f);
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            float f = (float)n2 / (float)this.height;
            fArray[0] = this.h;
            fArray[1] = this.s - f;
            fArray[2] = this.b;
        }

        public int getRGBForLocation(int n, int n2) {
            if (n2 != this.cachedY) {
                this.cachedY = n2;
                this.cachedColor = super.getRGBForLocation(n, n2);
            }
            return this.cachedColor;
        }
    }

    class HueImage
    extends AbstractHSBImage {
        public HueImage(int n, int n2) {
            super(n, n2, 0.0f, 1.0f, 1.0f);
        }

        public void getHSBForLocation(int n, int n2, float[] fArray) {
            float f = 1.0f / (float)this.height;
            fArray[0] = (float)n2 * f;
            fArray[1] = this.s;
            fArray[2] = this.b;
        }

        protected boolean isStatic() {
            return true;
        }
    }
}

