/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsTextUI;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class WindowsTextFieldUI
extends BasicTextFieldUI {
    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTextFieldUI();
    }

    static class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        transient boolean temporaryLoss;
        transient int tempDot;
        transient int tempMark;

        protected void adjustVisibility(Rectangle rectangle) {
            JTextField jTextField = (JTextField)this.getComponent();
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = rectangle.x + boundedRangeModel.getValue();
            int n2 = boundedRangeModel.getExtent() / 4;
            if (n < boundedRangeModel.getValue()) {
                boundedRangeModel.setValue(n - n2);
            } else if (n > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
                boundedRangeModel.setValue(n - 3 * n2);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            JTextComponent jTextComponent = this.getComponent();
            Document document = jTextComponent.getDocument();
            int n = document.getLength();
            if (!this.temporaryLoss) {
                this.setDot(0);
                this.moveDot(n);
            } else {
                this.setDot(Math.min(this.tempMark, n));
                this.moveDot(Math.min(this.tempDot, n));
                this.temporaryLoss = false;
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent != null) {
                this.temporaryLoss = focusEvent.isTemporary();
                if (this.temporaryLoss) {
                    this.tempDot = this.getDot();
                    this.tempMark = this.getMark();
                }
            } else {
                this.temporaryLoss = false;
            }
            this.setDot(this.getDot());
            this.setVisible(false);
        }

        protected Highlighter.HighlightPainter getSelectionPainter() {
            return WindowsTextUI.WindowsPainter;
        }
    }
}

