/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;

class MotifInternalFrameTitlePane
extends JComponent
implements LayoutManager,
ActionListener,
PropertyChangeListener {
    SystemButton systemButton;
    MinimizeButton minimizeButton;
    MaximizeButton maximizeButton;
    JPopupMenu systemMenu;
    Title title;
    JInternalFrame iFrame;
    Color color;
    Color highlight;
    Color shadow;
    static final Font defaultTitleFont = new Font("SansSerif", 0, 12);
    public static final int BUTTON_SIZE = 19;
    final int RESTORE_MENU_ITEM = 0;
    final int MOVE_MENU_ITEM = 1;
    final int SIZE_MENU_ITEM = 2;
    final int MINIMIZE_MENU_ITEM = 3;
    final int MAXIMIZE_MENU_ITEM = 4;
    final int SEPARATOR_MENU_ITEM = 5;
    final int CLOSE_MENU_ITEM = 6;
    static Dimension buttonDimension = new Dimension(19, 19);

    public MotifInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.iFrame = jInternalFrame;
        this.setPreferredSize(new Dimension(100, 19));
        this.systemMenu = new JPopupMenu(){

            public void show(Component component, int n, int n2) {
                if (!MotifInternalFrameTitlePane.this.iFrame.isIconifiable()) {
                    MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(3).setEnabled(false);
                }
                if (!MotifInternalFrameTitlePane.this.iFrame.isMaximizable()) {
                    MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(4).setEnabled(false);
                }
                if (!MotifInternalFrameTitlePane.this.iFrame.isMaximizable() && !MotifInternalFrameTitlePane.this.iFrame.isIconifiable()) {
                    MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(0).setEnabled(false);
                }
                if (!MotifInternalFrameTitlePane.this.iFrame.isClosable()) {
                    MotifInternalFrameTitlePane.this.systemMenu.getComponentAtIndex(6).setEnabled(false);
                }
                super.show(component, n, n2);
            }
        };
        JMenuItem jMenuItem = this.systemMenu.add(new JMenuItem("Restore"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Move"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Size"));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Minimize"));
        jMenuItem.addActionListener(this);
        jMenuItem = this.systemMenu.add(new JMenuItem("Maximize"));
        jMenuItem.addActionListener(this);
        this.systemMenu.add(new JSeparator());
        jMenuItem = this.systemMenu.add(new JMenuItem("Close"));
        jMenuItem.addActionListener(this);
        this.systemButton = new SystemButton();
        this.systemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MotifInternalFrameTitlePane.this.systemMenu.show(MotifInternalFrameTitlePane.this.systemButton, 0, 19);
            }
        });
        this.systemButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (MotifInternalFrameTitlePane.this.iFrame.isClosable()) {
                        try {
                            MotifInternalFrameTitlePane.this.iFrame.setClosed(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                    MotifInternalFrameTitlePane.this.systemMenu.setVisible(false);
                }
            }
        });
        this.minimizeButton = new MinimizeButton();
        this.minimizeButton.addActionListener(this);
        this.minimizeButton.setActionCommand("Iconify");
        this.maximizeButton = new MaximizeButton();
        this.maximizeButton.addActionListener(this);
        this.maximizeButton.setActionCommand("Maximize");
        this.title = new Title(this.iFrame.getTitle());
        this.title.setFont(defaultTitleFont);
        this.setLayout(this);
        this.add(this.systemButton);
        this.add(this.title);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
        this.iFrame.addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if ("Close".equals(actionEvent.getActionCommand()) && this.iFrame.isClosable()) {
                this.iFrame.setClosed(true);
            } else if (("Iconify".equals(actionEvent.getActionCommand()) || "Minimize".equals(actionEvent.getActionCommand())) && this.iFrame.isIconifiable()) {
                if (!this.iFrame.isIcon()) {
                    this.iFrame.setIcon(true);
                } else {
                    this.iFrame.setIcon(false);
                }
            } else if ("Maximize".equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable()) {
                if (!this.iFrame.isMaximum()) {
                    this.iFrame.setMaximum(true);
                } else {
                    this.iFrame.setMaximum(false);
                }
            } else if ("Restore".equals(actionEvent.getActionCommand()) && this.iFrame.isMaximizable() && this.iFrame.isMaximum()) {
                this.iFrame.setMaximum(false);
            } else if ("Restore".equals(actionEvent.getActionCommand()) && this.iFrame.isIconifiable() && this.iFrame.isIcon()) {
                this.iFrame.setIcon(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
        if (this.systemMenu.isVisible()) {
            this.systemMenu.setVisible(false);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    JPopupMenu getSystemMenu() {
        return this.systemMenu;
    }

    protected void hideSystemMenu() {
        this.systemMenu.setVisible(false);
    }

    public void layoutContainer(Container container) {
        int n = this.getWidth();
        this.systemButton.setBounds(0, 0, 19, 19);
        int n2 = n - 19;
        if (this.iFrame.isMaximizable()) {
            this.maximizeButton.setBounds(n2, 0, 19, 19);
            n2 -= 19;
        } else if (this.maximizeButton.getParent() != null) {
            this.maximizeButton.getParent().remove(this.maximizeButton);
        }
        if (this.iFrame.isIconifiable()) {
            this.minimizeButton.setBounds(n2, 0, 19, 19);
            n2 -= 19;
        } else if (this.minimizeButton.getParent() != null) {
            this.minimizeButton.getParent().remove(this.minimizeButton);
        }
        this.title.setBounds(19, 0, n2, 19);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 19);
    }

    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(container.getSize().width, 19);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
        boolean bl = false;
        if ("selected".equals(string)) {
            this.repaint();
        } else if ("maximum".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            this.systemMenu.getComponentAtIndex(0).setEnabled(bl);
            this.systemMenu.getComponentAtIndex(4).setEnabled(bl ^ true);
        } else if ("icon".equals(string)) {
            bl = (Boolean)propertyChangeEvent.getNewValue();
            this.systemMenu.getComponentAtIndex(0).setEnabled(bl);
            this.systemMenu.getComponentAtIndex(4).setEnabled(bl ^ true);
            this.systemMenu.getComponentAtIndex(3).setEnabled(bl ^ true);
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    void setColors(Color color, Color color2, Color color3) {
        this.color = color;
        this.highlight = color2;
        this.shadow = color3;
    }

    protected void showSystemMenu() {
        this.systemMenu.show(this.systemButton, 0, 19);
    }

    private abstract class FrameButton
    extends JButton {
        FrameButton() {
            this.setFocusPainted(false);
            this.setBorderPainted(false);
        }

        public Dimension getMinimumSize() {
            return buttonDimension;
        }

        public Dimension getPreferredSize() {
            return buttonDimension;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width - 1;
            int n2 = dimension.height - 1;
            graphics.setColor(MotifInternalFrameTitlePane.this.color);
            graphics.fillRect(1, 1, dimension.width, dimension.height);
            boolean bl = this.getModel().isPressed();
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(1, n2, n, n2);
            graphics.drawLine(n, 1, n, n2);
        }

        public void requestFocus() {
        }
    }

    private class MinimizeButton
    extends FrameButton {
        MinimizeButton() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(7, 8, 7, 11);
            graphics.drawLine(7, 8, 10, 8);
            graphics.setColor(MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(8, 11, 10, 11);
            graphics.drawLine(11, 9, 11, 11);
        }
    }

    private class MaximizeButton
    extends FrameButton {
        MaximizeButton() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = 14;
            boolean bl = MotifInternalFrameTitlePane.this.iFrame.isMaximum();
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.shadow : MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(4, 4, 4, n);
            graphics.drawLine(4, 4, n, 4);
            graphics.setColor(bl ? MotifInternalFrameTitlePane.this.highlight : MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(5, n, n, n);
            graphics.drawLine(n, 5, n, n);
        }
    }

    private class SystemButton
    extends FrameButton {
        SystemButton() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(MotifInternalFrameTitlePane.this.highlight);
            graphics.drawLine(4, 8, 4, 11);
            graphics.drawLine(4, 8, 14, 8);
            graphics.setColor(MotifInternalFrameTitlePane.this.shadow);
            graphics.drawLine(5, 11, 14, 11);
            graphics.drawLine(14, 9, 14, 11);
        }

        public void requestFocus() {
        }
    }

    private class Title
    extends FrameButton {
        Title(String string) {
            this.setText(string);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder(0, UIManager.getColor("activeCaptionBorder"), UIManager.getColor("inactiveCaptionBorder")));
            this.addMouseMotionListener(new MouseMotionListener(this){
                private final /* synthetic */ Title this$1;
                {
                    this.this$1 = title;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
            this.addMouseListener(new MouseListener(this){
                private final /* synthetic */ Title this$1;
                {
                    this.this$1 = title;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (MotifInternalFrameTitlePane.this.iFrame.isSelected()) {
                graphics.setColor(UIManager.getColor("activeCaptionText"));
            } else {
                graphics.setColor(UIManager.getColor("inactiveCaptionText"));
            }
            Dimension dimension = this.getSize();
            MotifGraphicsUtils.drawStringInRect(graphics, MotifInternalFrameTitlePane.this.iFrame.getTitle(), 0, 0, dimension.width, dimension.height, 0);
        }
    }
}

