/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AP_EightBitAudioDeviceFactory.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



/**
 * This class is responsible for creating instances of the
 * EightBitAP_AudioDevice. The audio device implementation is loaded
 * and tested dynamically as not all systems will have support
 * for JavaSound, or they may have the incorrect version.
 */

public class AP_EightBitAudioDeviceFactory extends AP_AudioDeviceFactory
{
	private boolean tested = false;

	static private final String DEVICE_CLASS_NAME = "AP_EightBitAudioDevice";

	public synchronized AP_AudioDevice createAudioDevice()
		throws AD_JavaLayerException
	{
		if (!tested)
		{
			testAudioDevice();
			tested = true;
		}

		try
		{
			return createAudioDeviceImpl();
		}
		catch (Exception ex)
		{
			throw new AD_JavaLayerException("unable to create JavaSound device: "+ex);
		}
		catch (LinkageError ex)
		{
			throw new AD_JavaLayerException("unable to create JavaSound device: "+ex);
		}
	}

	protected AP_EightBitAudioDevice createAudioDeviceImpl()
		throws AD_JavaLayerException
	{
		ClassLoader loader = getClass().getClassLoader();
		try
		{
			AP_EightBitAudioDevice dev = (AP_EightBitAudioDevice)instantiate(loader, DEVICE_CLASS_NAME);
			return dev;
		}
		catch (Exception ex)
		{
			throw new AD_JavaLayerException("Cannot create JavaSound device", ex);
		}
		catch (LinkageError ex)
		{
			throw new AD_JavaLayerException("Cannot create JavaSound device", ex);
		}

	}

	public void testAudioDevice() throws AD_JavaLayerException
	{
		AP_EightBitAudioDevice dev = createAudioDeviceImpl();
		dev.test();
	}
}
