/*
 *   @(#) MP3 Player 1.0 Demicron (demicron@demicron.com)
 *
 *   Play_Player.java   2002-09-17
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;


/**
 * The <code>Player</code> class implements a simple player for playback
 * of an MPEG audio stream.
 *
 * @author	Mat McGowan
 * @since	0.0.8
 */

// REVIEW: the audio device should not be opened until the
// first MPEG audio frame has been decoded.
public class Play_Player
{
	/**
	 * The current frame number.
	 */
	private int frame = 0;

	/**
	 * The MPEG audio bitstream.
	 */
	// javac blank final bug.
	/*final*/ private Bit_stream		bitstream;

	/**
	 * The MPEG audio decoder.
	 */
	/*final*/ private DDecoder		decoder;

	/**
	 * The AudioDevice the audio samples are written to.
	 */
	private Play_JavaSoundAudioDevice	audio;

	/**
	 * Has the player been closed?
	 */
	private boolean		closed = false;

	/**
	 * Has the player played back all frames from the stream?
	 */
	private boolean		complete = false;

	private int			lastPosition = 0;
        //private bob64 b64;

	/**
	 * Creates a new <code>Player</code> instance.
	 */
	/*public Play_Player(InputStream stream) throws JavaLayerException
	{
		this(stream, null);
	}*/

	public Play_Player(InputStream stream) throws JavaLayerException
	{
               // this.b64 = b64;
		bitstream = new Bit_stream(stream);
		decoder = new DDecoder();

		/*if (device!=null)
		{
			audio = device;
		}
		else
		{*/
			//Play_FactoryRegistry r = Play_FactoryRegistry.systemRegistry();
			audio = new Play_JavaSoundAudioDevice();//r.createAudioDevice();
		//}
		audio.open(decoder);

	}

	public void play() throws JavaLayerException
	{
		play(Integer.MAX_VALUE);
	}

       /* private void waitForBufferFillup() {
          if (b64!=null) {
            b64.createEv(null, 2); // Buffering started
            while (audio.getFillRatio()<0.95) {
              try {
                Thread.currentThread().sleep(50);
              } catch (Exception e) {e.printStackTrace();}
            }
            b64.createEv(null, 3); // Buffering finished
          }
        }*/

	/**
	 * Plays a number of MPEG audio frames.
	 *
	 * @param frames	The number of frames to play.
	 * @return	true if the last frame was played, or false if there are
	 *			more frames.
	 */
	public boolean play(int frames) throws JavaLayerException
	{
		boolean ret = true;

		while (frames-- > 0 && ret)
		{
                        //if (audio.getFillRatio()<0.05)
                         // waitForBufferFillup();
			ret = decodeFrame();
		}
		if (!ret)
		{
			// last frame, ensure all data flushed to the audio device.
			Play_AudioDeviceBase out = audio;
			if (out!=null)
			{
				out.flush();
				synchronized (this)
				{
					complete = (!closed);
					close();
				}
			}
		}
		return ret;
	}

	/**
	 * Cloases this player. Any audio currently playing is stopped
	 * immediately.
	 */
	public synchronized void close()
	{
		Play_JavaSoundAudioDevice out = audio;
		if (out!=null)
		{
			closed = true;
			audio = null;
			// this may fail, so ensure object state is set up before
			// calling this method.
			out.close();
			lastPosition = out.getPosition();
			try
			{
				bitstream.close();
			}
			catch (BitstreamException ex)
			{
			}
		}
	}

	/**
	 * Returns the completed status of this player.
	 *
	 * @return	true if all available MPEG audio frames have been
	 *			decoded, or false otherwise.
	 */
	public synchronized boolean isComplete()
	{
		return complete;
	}

	/**
	 * Retrieves the position in milliseconds of the current audio
	 * sample being played. This method delegates to the <code>
	 * AudioDevice</code> that is used by this player to sound
	 * the decoded audio samples.
	 */
	public int getPosition()
	{
		int position = lastPosition;

		Play_JavaSoundAudioDevice out = audio;
		if (out!=null)
		{
			position = out.getPosition();
		}
		return position;
	}

	/**
	 * Decodes a single frame.
	 *
	 * @return true if there are no more frames to decode, false otherwise.
	 */
	protected boolean decodeFrame() throws JavaLayerException
	{
		try
		{
			Play_AudioDeviceBase out = audio;
			if (out==null)
				return false;

			HHeader h = bitstream.readFrame();

			if (h==null)
				return false;

			// sample buffer set when decoder constructed
			SampleBuffer output = (SampleBuffer)decoder.decodeFrame(h, bitstream);

			synchronized (this)
			{
				out = audio;
				if (out!=null)
				{
					out.write(output.getBuffer(), 0, output.getBufferLength());
				}
			}
			bitstream.closeFrame();
		}
		catch (RuntimeException ex)
		{
			throw new JavaLayerException("Exception decoding audio frame", ex);
		}
/*
		catch (IOException ex)
		{
			System.out.println("exception decoding audio frame: "+ex);
			return false;
		}
		catch (BitstreamException bitex)
		{
			System.out.println("exception decoding audio frame: "+bitex);
			return false;
		}
		catch (DecoderException decex)
		{
			System.out.println("exception decoding audio frame: "+decex);
			return false;
		}
*/
		return true;
	}


}
