/*
 *   @(#) MP3 Player 1.0 Demicron (demicron@demicron.com)
 *
 *   BitstreamException.java   2002-09-17
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


public class BitstreamException extends JavaLayerException
	implements BitstreamErrors
{
	private int errorcode = UNKNOWN_ERROR;

	public BitstreamException(String msg, Throwable t)
	{
		super(msg, t);
	}

	public BitstreamException(int errorcode, Throwable t)
	{
		this(getErrorString(errorcode), t);
		this.errorcode = errorcode;
	}

	public int getErrorCode()
	{
		return errorcode;
	}


	static public String getErrorString(int errorcode)
	{
		// REVIEW: use resource bundle to map error codes
		// to locale-sensitive strings.

		return "Bitstream errorcode "+Integer.toHexString(errorcode);
	}


}
