/*
 *   @(#) MP3 Player 1.0 Demicron (demicron@demicron.com)
 *
 *   Play_jlp.java   2002-09-17
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


import java.io.*;
import java.net.*;



/**
 * The <code>jlp</code> class implements a simple command-line
 * player for MPEG audio files.
 *
 * @author Mat McGowan (mdm@techie.com)
 */
public class Play_jlp implements Runnable
{
//	private String fFilename = null;
//	private boolean remote = false;
        private Play_Player player;
        private File mp3File;
        private Thread playerThread;


        public Play_jlp(File file) {
          mp3File = file;
        }
	/*public static void main(String[] args)
	{
		int retval = 0;
		try
		{
			Play_jlp player = createInstance(args);
			if (player!=null)
				player.play();
		}
		catch (Exception ex)
		{
			System.err.println(ex);
			ex.printStackTrace(System.err);
			retval = 1;
		}
		System.exit(retval);
	}

	static public Play_jlp createInstance(String[] args)
	{
		Play_jlp player = new Play_jlp();
		if (!player.parseArgs(args))
			player = null;
		return player;
	}

	private Play_jlp()
	{
	}

	public Play_jlp(String filename)
	{
		init(filename);
	}

	protected void init(String filename)
	{
		fFilename = filename;
	}

	protected boolean parseArgs(String[] args)
	{
		boolean parsed = false;
		if (args.length == 1)
		{
			init(args[0]);
			parsed = true;
			remote = false;
		}
		else if (args.length == 2)
		{
			if (!(args[0].equals("-url")))
			{
				showUsage();
			}
			else
			{
				init(args[1]);
				parsed = true;
				remote = true;
			}
		}
		else
		{
			showUsage();
		}
		return parsed;
	}

	public void showUsage()
	{
		System.out.println("Usage: jlp [-url] <filename>");
		System.out.println("");
		System.out.println(" e.g. : Play_jlp localfile.mp3");
		System.out.println("        Play_jlp -url http://www.server.com/remotefile.mp3");
		System.out.println("        Play_jlp -url http://www.shoutcastserver.com:8000");
	}*/

        public void stop() {
          if (player!=null)
          {
                  player.close();
                  player = null;
                  playerThread = null;
          }
        }



	public void play()
		throws JavaLayerException
	{
          stop();
          playerThread = new Thread(this);
          playerThread.start();
	}

        public void run() {
          try
          {
                  //System.out.println("playing "+fFilename+"...");
                  //InputStream in = null;
                  //if (remote == true) in = getURLInputStream();
                  //else in = getInputStream();
                  InputStream inputStream = new BufferedInputStream(new FileInputStream(mp3File));
                  //Play_AudioDevice dev = getAudioDevice();
                  player = new Play_Player(inputStream); // Automatically creates javasoundaudiodevice if null
                  player.play();
          } catch (Exception e) {e.printStackTrace();}
        }

	/**
	 * Playing file from URL (Streaming).
	 */
	/*protected InputStream getURLInputStream()
		throws Exception
	{

		URL url = new URL(fFilename);
		InputStream fin = url.openStream();
		BufferedInputStream bin = new BufferedInputStream(fin);
		return bin;
	}*/

	/**
	 * Playing file from FileInputStream.
	 */
	/*protected InputStream getInputStream()
		throws IOException
	{
		FileInputStream fin = new FileInputStream(fFilename);
		BufferedInputStream bin = new BufferedInputStream(fin);
		return bin;
	}*/

	protected Play_JavaSoundAudioDevice getAudioDevice()
		throws JavaLayerException
	{
		return new Play_JavaSoundAudioDevice();//Play_FactoryRegistry.systemRegistry().createAudioDevice();
	}

}
