/* PhotoOrganizer $RCSfile: RenameOptionsTab.java,v $ 
 * Copyright (C) 1999-2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  $Id: RenameOptionsTab.java,v 1.7 2001/07/19 07:58:31 rogatkin Exp $
 */
package photoorganizer.renderer;
import java.awt.FlowLayout;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.formats.*;
import photoorganizer.directory.JDirectoryChooser;

public final class RenameOptionsTab extends JPanel implements ActionListener,
    FocusListener, Persistable, Helpable {
    public final static String SECNAME = "RenameOptions";
    public final static String MASK = "Mask";
    public final static String ASKEDIT = "AskEdit";
    public final static String REMOVEAFTER = "RemoveAfterRename";
    public final static String COUNTER = "Counter";
    final static String DESTFOLDER = "DestinationFolder";

	public RenameOptionsTab(final Controller controller) {
		this.controller = controller;
		setLayout(new GranulatedLayout(5, 5, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP,
									   Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
		add(new JLabel(Resources.LABEL_NAMEGENMASK), "0,0,4,1");
		add(cb_masks = new JComboBox(maskItems = new DefaultComboBoxModel()), "0,1,2");
		cb_masks.setEditable(true);
		add(new PopupCombo(Resources.MASKS[1], Resources.LABEL_INS_R, this, "2,1", cb_masks), "2,1,2");
		cb_masks.addItemListener( new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				Object item = cb_masks.getEditor().getItem();
				if (item != null && item.toString().trim().length() > 0) {
					if (maskItems.getIndexOf(item) < 0)
						cb_masks.addItem(item);
					cb_masks.setToolTipText(FileNameFormat.makeValidPathName(new FileNameFormat(item.toString()).format(controller.sampleJpeg)));
				}
			}
			});
		
		add(cb_editnewname = new JCheckBox(Resources.LABEL_EDIT_NEW_NAME), "0,2,2,1,12");
		add(cb_remafter = new JCheckBox(Resources.LABEL_REMOVE_AFTER_REN), "0,3,2,1,12");
		add(new JLabel(Resources.LABEL_START_COUNTER, SwingConstants.LEFT), "2,2,2,1");
		add(tf_counter = new JTextField(), "2,3,1,1");
		tf_counter.setHorizontalAlignment(JTextField.RIGHT);
		add(new JLabel(Resources.LABEL_DESTINATIONDIR), "0,4,4,1");
		add(tf_destdir = new JTextField(), "0,5,4,1");
		add(bt_brws_dstdir = new JButton(Resources.CMD_BROWSE), "4,5,1,1");
		bt_brws_dstdir.addActionListener(this);
		tf_counter.addFocusListener(this);
	}
    
	public String getHelp() {
		return FileNameFormat.formatHelp;
	}
	
	public void actionPerformed(ActionEvent a) {
		if (a.getSource() == bt_brws_dstdir) {
			JDirectoryChooser dc = new JDirectoryChooser(new JFrame(), tf_destdir.getText(), null);
			if (dc.getDirectory() != null)
				tf_destdir.setText(dc.getDirectory());
		}
	}
    
	public void focusGained(FocusEvent e) {
		tf_counter.setText(""+FileNameFormat.counter);
	}
    
    public void focusLost(FocusEvent e) {
    }
    
	public void load() {
		Serializer s = controller.getSerializer();
		
		Object m = s.getProperty(SECNAME, MASK);
		if (m != null) {
			if (m instanceof Object[]) {
				Object []ma = (Object[])m;
				for (int i=0; i<ma.length; i++)
					maskItems.addElement(ma[i]);
			} else
				maskItems.addElement(m);
		}
		cb_editnewname.setSelected(Serializer.getInt(s.getProperty(SECNAME, ASKEDIT), 0) == 1);
		cb_remafter.setSelected(Serializer.getInt(s.getProperty(SECNAME, REMOVEAFTER), 0) == 1);
		tf_counter.setText(""+FileNameFormat.counter);
		String f = (String)s.getProperty(SECNAME, DESTFOLDER);
		if (f != null)
			tf_destdir.setText(f);    }
	
	public void save() {
		Serializer s = controller.getSerializer();
		cb_masks. setSelectedIndex(-1);
		if (maskItems.getSize() == 1)
			s.setProperty(SECNAME, MASK, maskItems.getElementAt(0).toString());
		else if (maskItems.getSize() > 1) {
			String []allMasks = new String[maskItems.getSize()];
			for (int i=0; i<maskItems.getSize(); i++)
				allMasks[i] = maskItems.getElementAt(i).toString();
			s.setProperty(SECNAME, MASK, allMasks);
		}
		s.setProperty(SECNAME, ASKEDIT, cb_editnewname.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, REMOVEAFTER, cb_remafter.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, DESTFOLDER, tf_destdir.getText());
		Integer i = Resources.I_NO;
		try {
			i = new Integer(tf_counter.getText());
		} catch (NumberFormatException e) {
		}
		s.setProperty(SECNAME, COUNTER, i);
		FileNameFormat.counter = i.intValue();
	}

    public static String getNewName(AbstractFormat format, Controller controller) {
        return new FileNameFormat((String)controller.getSerializer().
	    getProperty(SECNAME, MASK), true).format(format);
    }

    Controller controller;
    private JTextField tf_counter, tf_destdir;
    private JButton bt_brws_dstdir;
    private JCheckBox cb_editnewname, cb_remafter;
	private JComboBox cb_masks;
	private DefaultComboBoxModel maskItems;
}
