/* MediaChest - PhotoCollectionPanel
 * Copyright (C) 1999-2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  $Id: PhotoCollectionPanel.java,v 1.23 2001/09/16 02:04:34 rogatkin Exp $
 */
package photoorganizer.renderer;

import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import java.util.*;
import java.io.*;

import javax.swing.*;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.*;
import javax.swing.tree.*;

import javax.mail.MessagingException;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.formats.*;
import photoorganizer.courier.*;
import photoorganizer.media.*;
// TODO: remane to MediaCollectionPanel
public class PhotoCollectionPanel extends JTable implements ActionListener, Persistable, IrdControllable {
    final static String SECNAME = "PhotoCollectionPanel";
    final static String COLWIDTH = "ColumnWidthes";

    final static int TOO_MANY_WINDOWS = 20;
    
    private Controller controller;
    private Point lastmouse;
    private CollectionThumbnailsPanel thumbnailspanel;
    private AlbumPane albumpane;
    private StatusBar statusbar;
    private Class fclass;
    private boolean keeporigmarkers, transformmove, transformaddsel;
    public final static String DEFTNMASK = "tumbnail%00c.jpg";
    public static String LastHtmlName = "??";
	
	public PhotoCollectionPanel(Controller controller) {
		setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		this.controller = controller;
		statusbar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
		thumbnailspanel = (CollectionThumbnailsPanel)controller.component(Controller.COMP_THUMBCOLLCTPANEL);
		if (thumbnailspanel !=  null)
			thumbnailspanel.setCollection(this);
		albumpane = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
		albumpane.setCollectionPanel(this);
		addMouseListener(new MouseInputAdapter() {
			public void mouseClicked(MouseEvent e) {
				int m = e.getModifiers();
				lastmouse = new Point(e.getX(), e.getY());
				if ((m & InputEvent.BUTTON3_MASK) > 0)
					getRMouseMenu().show(PhotoCollectionPanel.this, e.getX(), e.getY());
				else if (e.getClickCount() == 2) {
                    actionPerformed(new ActionEvent(this, 0, Resources.MENU_SHOW));
                }
			}
		});
		setModel(new CollectionModel(controller));
		setMinimumSize(Resources.MIN_PANEL_DIMENSION);
		getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				int f = e.getFirstIndex();
				int l = e.getLastIndex();
				if (f > l) {
					l = e.getFirstIndex();
					f = e.getLastIndex();
				}
				CollectionModel model = (CollectionModel) getModel();
				Thumbnail tn;
				boolean selected, were_sel = false;
				for (int i = f; i <= l; i++) {
					if ((tn = (Thumbnail)model.getElementAt(i)) != null) {
						tn.select(selected = isRowSelected(i));
						were_sel |= selected;
					}
				}
				if (!were_sel)  // we can still have some selections
					were_sel = getSelectedRowCount() > 0;
				PhotoCollectionPanel.this.controller.getUiUpdater().notify(were_sel, UiUpdater.SELECTION_SELECTED);
				PhotoCollectionPanel.this.controller.getUiUpdater().notify(were_sel, UiUpdater.IS_SELECTION);
			}
        });
		addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent e) {
				if (e.getKeyCode() == e.VK_DELETE) {
					delete(getSelectedRows());
				}
			}
		}); 
		setTransferHandler(new TransferHandler() {
			public boolean importData(JComponent comp,
									  Transferable t) {
				try { // 
					java.util.List fileList = (java.util.List)t.getTransferData(DataFlavor.javaFileListFlavor);
					add((File[])fileList.toArray(new File[fileList.size()]));
					return true;
				}catch(Exception e) {
					e.printStackTrace();
				}
				return false;
			}
			public boolean canImport(JComponent comp,
									 DataFlavor[] transferFlavors) {
				// TODO: extend to accept URLs also
				for (int i=0; i<transferFlavors.length; i++)
					if (transferFlavors[i].isFlavorJavaFileListType())
						return true;
				return false;
			}

			});
		
		setDragEnabled(true);	
    }
    
	public void actionPerformed(ActionEvent a) {
		String cmd = a.getActionCommand();
		CollectionModel model = (CollectionModel) getModel();
		int [] selections = getSelectedRows();
		//TODO: create own copy of selection array
		selections = (int[])selections.clone();

		if (cmd.equals(Resources.MENU_REVERSE_SELECT)) {
			int sel = rowAtPoint(lastmouse);
			if (sel >= 0) {
				if (isRowSelected(sel))
					removeRowSelectionInterval(sel, sel);
				else
					addRowSelectionInterval(sel, sel);
				controller.getUiUpdater().notify(getSelectedRowCount()>0, UiUpdater.SELECTION_SELECTED);
			}
		} else if (cmd.equals(Resources.MENU_SELECTALL)) {
			selectAll();
		} else if (cmd.equals(Resources.MENU_CF_TOCOLLECT) || // from tool bar
			(a.getSource() instanceof JButton && ((JButton)a.getSource()).getToolTipText().equals(Resources.MENU_CF_TOCOLLECT))) {
			String path = (String)controller.getSerializer().getProperty(MiscellaneousOptionsTab.SECNAME, MiscellaneousOptionsTab.FC_FOLDER);
			if (path != null && path.length() > 0)
				add(new File[] {new File(path)});
		} else if (cmd.equals(Resources.MENU_EXTRACTMARKERS)) {
			extractMarkers(selections);
		} else if (cmd.equals(Resources.MENU_ADDTOALBUM)) {
			AlbumSelectionDialog asd = albumpane.getSelectionDialog();
			asd.setTitle(Resources.TITLE_SELECT_ALBUM+":"+selections.length);
			asd.setVisible(true);
			TreePath[] tps = asd.getSelectedAlbums();
			if (tps != null) {
				Serializer s = controller.getSerializer();
				final boolean removeafter = Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.MOVETOFOLDER), 0) == 1 &&
					Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.USEALBUMFOLDER), 0) == 1;
				AbstractFormat[] medias = new AbstractFormat[selections.length];
				int minr=0, maxr=0;
				for (int i = 0; i < selections.length; i++) {
					medias[i] = ((Thumbnail)model.getElementAt(selections[i])).getFormat();
					if (removeafter) {
						((Thumbnail)model.getElementAt(selections[i])).select(false);
						model.markDelete(selections[i]);
						if (selections[i] > maxr)
							maxr = selections[i];
						if (selections[i] < minr)
							minr = selections[i];
					}
				}
				albumpane.addToAlbum(medias, tps);
				if (removeafter) {
					model.removeAllMarked();
					model.fireTableRowsDeleted(minr, maxr);
					controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
				} else
					model.fireTableRowsUpdated(minr, maxr);
			}
		} else if (cmd.equals(Resources.MENU_RENAME)) {
			rename(selections);
		} else if (cmd.equals(Resources.MENU_TORIPPER)) {
			copyToRipper(selections);
		} else if (cmd.equals(Resources.MENU_DELETE)) {
			delete(selections);
		} else if (cmd.equals(Resources.MENU_SHOW)) {
			int sel = rowAtPoint(lastmouse);
			if (sel >= 0) {
				AbstractFormat format = ((Thumbnail)model.getElementAt(sel)).getFormat();
				if (format != null && format instanceof BasicJpeg) {
					((PhotoImagePanel)controller.component(Controller.COMP_IMAGECOLLCTPANEL)).updateView(format);
					return;
				}
				show(selections);
			}			
		} else if (cmd.equals(Resources.MENU_PROPERTIES)) {
			for(int i=0; i<selections.length && i<TOO_MANY_WINDOWS; i++) {
				Thumbnail tn = (Thumbnail)model.getElementAt(selections[i]);
				if (tn != null) // TODO: investigate why it can happen
					PropertiesPanel.showProperties(tn.getFormat(), controller);
			}
		} else if (cmd.equals(Resources.MENU_EXTRACTTUMBNAILS)) {
			BasicJpeg format;
			Serializer s = controller.getSerializer();
			String destpath = (String)s.getProperty(RenameOptionsTab.SECNAME, RenameOptionsTab.DESTFOLDER);
			if (destpath == null || destpath.length() == 0)
				destpath = controller.getSerializer().getHomeDirectory();
			String m = (String)s.getProperty(ThumbnailsOptionsTab.SECNAME, ThumbnailsOptionsTab.FILEMASK);
			if (m == null || m.length() == 0)
				m = DEFTNMASK;
			FileNameFormat fnf = new FileNameFormat(m, true);
			for(int i=0; i<selections.length; i++) {
				// TODO: casting
				format = (BasicJpeg)((Thumbnail)model.getElementAt(selections[i])).getFormat();
				AbstractImageInfo ii = format.getImageInfo();
				try {
					if (ii != null)
						ii.saveThumbnailImage(format,
											  new FileOutputStream(new File(destpath, FileNameFormat.makeValidPathName(fnf.format(format), ii.getThumbnailExtension()))));
				} catch(IOException ioe) {
					System.err.println(""+ioe);
				}
			}
		} else if (cmd.equals(Resources.MENU_GENERATEHTML)) {
			if (selections.length == 0)
				return;
			final Serializer s = controller.getSerializer();
			final boolean copyImagesOnly = Serializer.getInt(s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.CPYPICSONLY), 1) == 0;
			String htmlname = "";
			if (!copyImagesOnly) {
				htmlname = (String)JOptionPane.showInputDialog(this,
					Resources.LABEL_HTML_NAME, Resources.TITLE_CREATEHTML,
					JOptionPane.QUESTION_MESSAGE, null, null, "");
				if (htmlname != null)
					LastHtmlName = htmlname;
			}
			if (htmlname != null) {
				if (htmlname.indexOf('.') < 0)
					htmlname += Resources.EXT_HTML;
				
				final String fhtmlname = htmlname;
				// prepare array of files
				final File [] files = selectionsToFiles(selections);
				new Thread(new Runnable() {
					public void run() {
						try {
							Courier courier=null;
							switch(Serializer.getInt(s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.PUBMODE), WebPublishOptionsTab.LOCAL)) {
								case WebPublishOptionsTab.FTP:
									courier = new FTPCourier(controller);
									break;
								case WebPublishOptionsTab.HTTP: // http
									courier = new HTTPCourier(controller);
									break;
								case WebPublishOptionsTab.EMAIL:
									// TODO: add send mail like feature
									//courier = new MailCourier(controller);
									new SendEmailFrame(controller, files);
									return;
								case WebPublishOptionsTab.XML_SVG: // SVG
									break;
								default:
									courier = new FileCourier(controller);
							}
							if (copyImagesOnly) {
								try {
									statusbar.displayInfo(Resources.INFO_CONNECTING);
									courier.init();
									String imagePath = (String)s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.IMAGEPATH);
									if (imagePath == null)
										imagePath = "";
									else
										courier.checkForDestPath(imagePath);
									statusbar.clearProgress();
									statusbar.displayInfo(Resources.INFO_COPYING);
									statusbar.setProgress(files.length);				   
									for (int i = 0; i < files.length; i++) {
										courier.deliver(files[i].getPath(), imagePath);
										statusbar.tickProgress();
									}
								} finally {
									statusbar.clearInfo();
									statusbar.clearProgress();
									courier.done();				
								}
							} else { // TODO: add request for text to publish
								new HtmlProducer(controller).produce(fhtmlname, files, courier, null);
							}
						} catch (IOException e) {
							statusbar.flashInfo(Resources.INFO_ERR_WEBPUBLISHING);
							System.err.println("Exception in Web publishing "+e);
							e.printStackTrace();
						}
					}
					}, "WebPublishing").start();
			}
		} else if (cmd.equals(Resources.MENU_UPLOADIMAGE)) {
			if (selections.length == 0)
				return;
			final Serializer s = controller.getSerializer();
			// TODO: add request for album name with check box to create the album
			final String albumName = (String)JOptionPane.showInputDialog(this,
				Resources.LABEL_ALBUM_NAME, Resources.TITLE_WEBALBUM,
				JOptionPane.QUESTION_MESSAGE, null, null, "");
			if (albumName != null) {
				final File [] files = selectionsToFiles(selections);
				new Thread(new Runnable() {
					public void run() {
						Courier courier = null;
						try {
							courier = new HTTPCourier(controller, albumName);
							statusbar.displayInfo(Resources.INFO_CONNECTING);
							courier.init();
							String imagePath = (String)s.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.IMAGEPATH);
							if (imagePath == null)
								imagePath = "";
							else
								courier.checkForDestPath(imagePath);
							statusbar.clearProgress();
							statusbar.displayInfo(Resources.INFO_COPYING);
							statusbar.setProgress(files.length);				   
							for (int i = 0; i < files.length; i++) {
								courier.deliver(files[i].getPath(), imagePath);
								statusbar.tickProgress();
							}
							statusbar.clearInfo();
						} catch (IOException e) {
							statusbar.flashInfo(Resources.INFO_ERR_WEBPUBLISHING);
							System.err.println("Exception in Web publishing "+e);
							e.printStackTrace();
						} finally {
							statusbar.clearProgress();
							if (courier != null)
								courier.done();				
						}
					}
					}, "HTTPUpload").start();
			}			
		} else if (cmd.equals(Resources.MENU_PRINT)) {
			controller.print(selectionsToFiles(selections));
		} else if (cmd.equals(Resources.MENU_SENDTO)) {
			new SendEmailFrame(controller, selectionsToFiles(selections));
		} else if (cmd.equals(Resources.MENU_PLAY_LIST)) {
			showList(getSelectedRow());			
		} else {
			int op;
			if ((op = Controller.convertCmdToTrnasformOp(cmd)) != -1) {
				transform(selections, op);
			}
		}
	}
	
	public int add(PlaybackRequest request) {
		return add((File[])request.playbackList, request, null);		
	}
	
	public int add(File[] fs) {
		return add(fs, null, null);
	}
	
	public int add(File[] fs, PlaybackRequest request, PlaybackProperties playBackProperties) {
		controller.setWaitCursor(this, true);
		CollectionModel model = (CollectionModel) getModel();
		int end, start = model.getRowCount();
		end = start;
		for (int i=0; i<fs.length; i++) {
			if (fs[i].isFile()) {
				AbstractFormat format = MediaFormatFactory. createMediaFormat(fs[i]);
				if (format != null && format.isValid()) {
					if (format.getType() != MP3.TYPE) {
						thumbnailspanel.addImage(format);
						end++;
					} else {
						if (request == null || !request.requestOnCopy) {
							// recalculate available space
							thumbnailspanel.addImage(format);
						} else {
							if(playBackProperties == null)
								playBackProperties = PlaybackProperties.doPropertiesDialog(controller, null);
							ContentMatcher matcher = playBackProperties.getMatcher();
							if (matcher != null && matcher.match(format)) {
								// recalculate available space
								thumbnailspanel.addImage(format);
							}
						}
					}
				}
			} else if (fs[i].isDirectory() && (fs.length == 1 || (request != null && request.recursive))) {
				end += add(fs[i].listFiles(), request, playBackProperties);
			}
		}
		model.fireTableRowsInserted(start, end);
		controller.setWaitCursor(this, false);
		updateStatusBar();
		return end;
	}
	
	public void add(AbstractFormat format) {
		CollectionModel model = (CollectionModel) getModel();
		int start = model.getRowCount();
		thumbnailspanel.addImage(format);
		model.fireTableRowsInserted(start, start+1);
		updateStatusBar();
	}
	
	protected void updateStatusBar() {
		Serializer s = controller.getSerializer();
		if (s.getInt(s.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.PLAYLIST_TYPE), MediaOptionsTab.AUDIO_MEDIA) == MediaOptionsTab.AUDIO_MEDIA) {
			statusbar.displayMetric(MP3.convertTime(thumbnailspanel.getTime()));
		} else {
			statusbar.displayMetric(BasicIo.convertLength(thumbnailspanel.getLength()));			
		}
	}
	
	String transformName(File file, int op) {
		Serializer s = controller.getSerializer();
		String destpath = (String)s.getProperty(RenameOptionsTab.SECNAME, RenameOptionsTab.DESTFOLDER);
		if (destpath == null || destpath.length() == 0)
			destpath = controller.getSerializer().getHomeDirectory();
		String m = (String)s.getProperty(TransformOptionsTab.SECNAME, TransformOptionsTab.MASK);
		if (m != null) {
			AbstractFormat format = MediaFormatFactory. createMediaFormat(file);
			if (format != null && format.isValid())
				return destpath+File.separatorChar+
					FileNameFormat.makeValidPathName(new FileNameFormat(m, op, true).format(format));
		}
		return destpath+File.separatorChar+file.getName();
	}
    
    int findIndexOf(Thumbnail im) {
        CollectionModel model = (CollectionModel) getModel();
        for (int i=0; i<model.getRowCount(); i++) {
            if (model.getElementAt(i) == im)
                return i;
        }
        return -1;
    }

	File[] selectionsToFiles(int [] selections) {
		File []files = new File[selections.length];
		CollectionModel model = (CollectionModel) getModel();
		for (int i=0; i<selections.length; i++) {
			Thumbnail tn = (Thumbnail)model.getElementAt(selections[i]);
			if (tn != null)
				files[i] = tn.getFormat().getFile();
		}
		return files;
	}

    void extractMarkers(int [] selections) {
        Serializer s = controller.getSerializer();
        CollectionModel model = (CollectionModel) getModel();
        String  name;
        BasicJpeg im;
        AbstractImageInfo ii;
        int dp;
		for(int i=0; i<selections.length; i++) {
			// TODO: use abstract format and info
			im = (BasicJpeg)((Thumbnail)model.getElementAt(selections[i])).getFormat();
			ii = im.getImageInfo();
			if (ii != null) {
				name = ii.getName();
				dp = name.lastIndexOf('.');
				if (dp > 0)
					name = name.substring(0, dp);
				name = FileNameFormat.makeValidPathName(name, ii.getFormat());
				try {
					im.saveMarkers(new FileOutputStream(new File(im.getParentPath(), name)));
				} catch(IOException e) {
					System.err.println("Exception in markers extraction "+e);
				}
			}
		}
    }

    void rename(final int [] selections) {
        Serializer s = controller.getSerializer();
        String destpath = (String)s.getProperty(RenameOptionsTab.SECNAME, RenameOptionsTab.DESTFOLDER);
        if (destpath == null || destpath.length() == 0)
            destpath = controller.getSerializer().getHomeDirectory();
        final String value = getRenameMask(this, s, " "+destpath);
		if (value == null)
			return;
		final String dp = destpath;
		statusbar.displayInfo(Resources.INFO_RENAMING);
		statusbar.setProgress(selections.length);
		final boolean removeafter = s.getInt(s.getProperty(RenameOptionsTab.SECNAME, RenameOptionsTab.REMOVEAFTER), 0) == 1;
        
        new Thread(new Runnable () {
			public void run() {
				AbstractFormat format;
				int minr=0, maxr=0;
				CollectionModel model = (CollectionModel) getModel();
				FileNameFormat fnf = new FileNameFormat(value, true);
				for(int i=0; i<selections.length; i++) {
					// TODO: avoid the casting
					format = ((Thumbnail)model.getElementAt(selections[i])).getFormat();
					File dest = new File(dp,
										 FileNameFormat.makeValidPathName(fnf.format(format)));
					if (format.renameTo(dest)) {
						if (selections[i] > maxr)
							maxr = selections[i];
						if (selections[i] < minr)
							minr = selections[i];
					}
					if (removeafter) {
						((Thumbnail)model.getElementAt(selections[i])).select(false);
						model.markDelete(selections[i]);
					}
					statusbar.tickProgress();
				}
				if (removeafter) {
					model.removeAllMarked();
					model.fireTableRowsDeleted(minr, maxr);
					controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
				} else
					model.fireTableRowsUpdated(minr, maxr);
				statusbar.clearInfo();
				statusbar.clearProgress();
			}
        }, Resources.INFO_RENAMING).start();
    }
	
	void copyToRipper(final int [] selections) {
		Serializer s = controller.getSerializer();
		String destpath = (String)s.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.RIPPER_FOLDER);
		if (destpath == null)
			return; // TODO: warning box
		final File destDir = new File(destpath);
		if (!destDir.exists()) {
			if(!destDir.mkdirs())
				return; // TODO: warning box
		}
		new Thread(new Runnable() {
			public void run() {
				AbstractFormat format;
				CollectionModel model = (CollectionModel) getModel();
				for(int i=0; i<selections.length; i++) {
					// TODO: avoid the casting
					format = ((Thumbnail)model.getElementAt(selections[i])).getFormat();
					String name = format.getName();
					int ep = name.lastIndexOf('.');
					if (ep > 0)
						name = name.substring(0, ep)+".wav";
					File dest = new File(destDir, name);
					try {
						Controller.convertToWav(format, dest.getPath(), statusbar);
					} catch(Exception e) {
						System.err.println("Exception at convertion of "+format+" to "+dest+':'+e);
					}
				}
			}
			}, "Convert to wav").start();
	}
	
	static String getRenameMask(Component c, Serializer s, String to) {
		Object o = s.getProperty(RenameOptionsTab.SECNAME, RenameOptionsTab.MASK);
		Object []masks = null;
		if(o == null)
			masks = new String[0];
		else if (o instanceof Object[])
			masks = (Object[])o;
		else
			masks = new String[]{ o.toString() };
		if (masks.length == 0
			|| (masks.length == 1 && masks[0]. toString().length() == 0)
			|| masks.length > 1
			|| Serializer.getInt(s.getProperty(RenameOptionsTab.SECNAME, RenameOptionsTab.ASKEDIT), 0) == 1) {
			JComboBox values = new JComboBox(masks);
			values.setEditable(true);
			JPanel p = new JPanel();
			p.setLayout(new BorderLayout());
			p.add(new JLabel(Resources.LABEL_NEW_NAME), "Center");
			p.add(values, "South");
			if(JOptionPane.showOptionDialog(c, p,
											Resources.TITLE_RENAME+to,
											JOptionPane.OK_CANCEL_OPTION,
											JOptionPane.QUESTION_MESSAGE,
											null, null, null) == JOptionPane.OK_OPTION) 
				return values.getEditor().getItem().toString();
		} else
			return masks[0].toString();
		return null;
	}

    void delete(int [] selections) {
        CollectionModel model = (CollectionModel) getModel();
        statusbar.displayInfo(Resources.INFO_REMOVING);
        int minr=0, maxr=0;
		for(int i=0; i<selections.length; i++) {
			((Thumbnail)model.getElementAt(selections[i])).select(false);
			model.markDelete(selections[i]);
			if (selections[i] > maxr)
				maxr = selections[i];
			if (selections[i] < minr)
				minr = selections[i];
		}
		model.removeAllMarked();
		model.fireTableRowsDeleted(minr, maxr);
		tableChanged(new TableModelEvent(model, minr, maxr, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));
		controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
		statusbar.clearInfo();
		updateStatusBar();
    }

	void show(int[] selections) {
		CollectionModel model = (CollectionModel) getModel();
		ArrayList medias = new ArrayList();
		for(int i=0; i<selections.length; i++)
			medias.add(((Thumbnail)model.getElementAt(selections[i])).getFormat().getFile());
		new PlaybackRequest(medias.toArray(new File[medias.size()]), 
							controller.getSerializer(),
							false).playList(controller);																										
		//new PlaybackRequest(medias, controller.getSerializer(),	false).playList(controller);																										
	}
	
	// prepare list from [] use Arrays.asList([])
	void showList(int start) {
		if (start < 0)
			start = 0;
		new PlaybackRequest((ListModel)getModel(), controller.getSerializer()).playList(start, controller);
	}
	
	void transform(final int [] selections, final int op) {
		statusbar.displayInfo(Resources.INFO_TRANSFORMING);
		statusbar.setProgress(selections.length);
		loadTransformOptions();
        
        new Thread(new Runnable () {
			public void run() {
				CollectionModel model = (CollectionModel) getModel();
				int minr=0, maxr=0, bound = model.getRowCount();
				String transformname;
				File file;
				for(int i=0; i<selections.length; i++) {
					AbstractFormat format = ((Thumbnail)model.getElementAt(selections[i])).getFormat();
					transformname = transformName(format.getFile(), op);
					if (op == BasicJpeg.COMMENT) {
						if (format instanceof BasicJpeg) {
							String value = ((BasicJpeg)format).getComment();
							value = (String)JOptionPane.showInputDialog(PhotoCollectionPanel.this,
								Resources.LABEL_COMMENT, Resources.TITLE_COMMENT,
								JOptionPane.QUESTION_MESSAGE, null, null, value);
							if (value != null)
								((BasicJpeg)format).setComment(value);
							else
								continue;
						} else {
							// TODO: add/modify ID3(v2) tag
							Id3TagEditor.editTag(controller, format);
							continue;
						}
					}
					if (format instanceof BasicJpeg) {
						if (!((BasicJpeg)format).transform(transformname, op, keeporigmarkers, fclass))
							continue;
						if (transformmove) {
							if (format.getFile().delete()) {
								model.removeElementAt(selections[i]);
								if (selections[i] > maxr)
									maxr = selections[i];
								if (selections[i] < minr)
									minr = selections[i];
							}
						}
						if (transformaddsel) {
							add(new File[]{new File(transformname)});
						}
						statusbar.tickProgress();
					}
				}
				if (transformaddsel) {
					model.fireTableRowsInserted(bound-1, bound+selections.length-1);
					tableChanged(new TableModelEvent(model, bound-1, bound+selections.length-1, TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT));
				} 
				if (transformmove) {
					model.fireTableRowsDeleted(minr, maxr);
					tableChanged(new TableModelEvent(model, minr, maxr, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));
					controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
				}
				statusbar.clearInfo();
				statusbar.clearProgress();
			}
		}, Resources.INFO_TRANSFORMING).start();
    }

	void loadTransformOptions() {
		Serializer s = controller.getSerializer(); 
		keeporigmarkers = Serializer.getInt(s.getProperty(TransformOptionsTab.SECNAME, TransformOptionsTab.KEEP), 0) == 1;
		transformmove = Serializer.getInt(s.getProperty(TransformOptionsTab.SECNAME, TransformOptionsTab.MOVE), 0) == 0;
		transformaddsel = Serializer.getInt(s.getProperty(TransformOptionsTab.SECNAME, TransformOptionsTab.TRANSFTOSEL), 1) == 1;
		String format = (String)s.getProperty(TransformOptionsTab.SECNAME, TransformOptionsTab.FORMAT);
		fclass = null;
		if (format != null && !keeporigmarkers) {
			if (Resources.LIST_EXIF.equals(format))
				fclass = Exif.class;
			else if (Resources.LIST_CIFF.equals(format))
				fclass = CIFF.class;
			else if (Resources.LIST_JFIF.equals(format))
				fclass = JFXX.class;
			else if (Resources.LIST_EXTRN.equals(format))
				fclass = AbstractImageInfo.class;
		}
	}

	public void save() {
		Serializer s = controller.getSerializer();
		Integer[] w = new Integer[getColumnCount()];
		for (int i = 0; i < w.length; i++) {
			try {
				w[i] = new Integer(getColumn(getColumnName(i)).getWidth());
			} catch(IllegalArgumentException iae) {
				w[i] = Resources.I_NO;
			}
		}
		s.setProperty(SECNAME, COLWIDTH, w);
	}
    
	public void load() {
		Serializer s = controller.getSerializer();
		Object[] w = (Object[])s.getProperty(SECNAME, COLWIDTH);
		if (w == null)
			return;
		for (int i = 0; i < w.length; i++) {
			getColumn(getColumnName(i)).setWidth(((Integer)w[i]).intValue());
			getColumn(getColumnName(i)).setPreferredWidth(((Integer)w[i]).intValue());
		}
	}

	JPopupMenu getRMouseMenu() {
		return new RButtonMenu();
    }

	//
	// remote controllable
	//
	public String getName() {
		return Resources.COMP_SELECTION;
	}
	
	public String toString() {
		return getName();
	}


	public Iterator	getKeyMnemonics() {
		return Arrays.asList(new Object[0]).iterator();
	}
	
	public boolean doAction(String keyCode) {
		return false;
	}
	
	public void bringOnTop() {
		controller.selectTab(Resources.TAB_COLLECTION);
	}

	class RButtonMenu extends JPopupMenu {
		RButtonMenu() {
			JMenuItem item;
			this.add(item = new JMenuItem(Resources.MENU_REVERSE_SELECT));
			item.addActionListener(PhotoCollectionPanel.this);
			this.add(item = new JMenuItem(Resources.MENU_SELECTALL));
			item.addActionListener(PhotoCollectionPanel.this);
			addSeparator();
			this.add(item = new JMenuItem(Resources.MENU_SHOW));
			addSeparator();
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			this.add(item = new JMenuItem(Resources.MENU_ADDTOALBUM));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			this.add(item = new JMenuItem(Resources.MENU_TORIPPER));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			this.add(item = new JMenuItem(Resources.MENU_EXTRACTMARKERS));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			addSeparator();
			this.add(item = new JMenuItem(Resources.MENU_RENAME));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			this.add(item = new JMenuItem(Resources.MENU_DELETE));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			addSeparator();
			this.add(item = new JMenuItem(Resources.MENU_PRINT));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			addSeparator();
			JMenu menu;
			this.add(menu = Controller.createTransformMenu(PhotoCollectionPanel.this));
			menu.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
			addSeparator();
			this.add(item = new JMenuItem(Resources.MENU_PROPERTIES));
			item.addActionListener(PhotoCollectionPanel.this);
			item.setEnabled(controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
		}
	}

	class CollectionModel extends BaseConfigurableTableModel implements ListModel {
		Vector collection;
		
		CollectionModel(Controller controller) {
			updateView(controller.getSerializer());
		}
		
		protected int getDescriptionIndex() {
			return AppearanceOptionsTab.COLLECT_VIEW;
		}


		public int getRowCount() {
			return thumbnailspanel.getComponentCount();
		}		
		
		public Object getValueAt(int row, int column) {
			AbstractFormat format = ((Thumbnail)thumbnailspanel.getComponent(row)).getFormat();
			if (format == null)
				return null;
			return getValueAt(format.getFile(), format.getInfo(), column);
		}
		
		public Object /*Thumbnail*/ getElementAt(int index) {
			try {
				return /*(Thumbnail)*/thumbnailspanel.getComponent(index);
			} catch (ArrayIndexOutOfBoundsException e) {
				return null;
			}
		}
	
		void removeElementAt(int row) {
			thumbnailspanel.remove(row);
		}

		void markDelete(int row) {
			marked.addElement(thumbnailspanel.getComponent(row));
		}

		void removeAllMarked() {
			for (int i=0; i<marked.size(); i++)
				thumbnailspanel.remove((Component)marked.elementAt(i));
			marked.removeAllElements();
			thumbnailspanel.adjustDimension();
		}
		
		public void fireTableRowsUpdated(int firstRow, int lastRow) {
			super.fireTableRowsUpdated(firstRow, lastRow);
			for (int i=firstRow; i<=lastRow; i++) {
				((Thumbnail)thumbnailspanel.getComponent(i)).update();
			}
		}
		
		// list model
		public int getSize() {
			return getRowCount();
		}

		public void addListDataListener(ListDataListener l) {
		}

		public void removeListDataListener(ListDataListener l) {
		}

		Vector marked = new Vector(10);
	}
}