/* PhotoOrganizer - $RCSfile: PlaybackRequest.java,v $                           
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.                    
 * Redistribution and use in source and binary forms, with or without            
 * modification, are permitted provided that the following conditions            
 * are met:                                                                      
 * 1. Redistributions of source code must retain the above copyright             
 *    notice, this list of conditions and the following disclaimer.              
 * 2. Redistributions in binary form must reproduce the above copyright          
 *    notice, this list of conditions and the following disclaimer in the        
 *    documentation and/or other materials provided with the distribution.       
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND       
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE        
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR   
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR   
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER   
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT           
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF       
 *  SUCH DAMAGE.                                                                 
 *                                                                               
 *  Visit http://drogatkin.openestate.net to get the latest infromation          
 *  about Rogatkin's products.                                                   
 *  $Id: PlaybackRequest.java,v 1.8 2001/08/03 08:05:20 rogatkin Exp $            
 */                                                                              

package photoorganizer.media;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ListModel;
import photoorganizer.*;
import photoorganizer.renderer.*;
import photoorganizer.formats.*;
import rogatkin.*;
// MediaController.java
public class PlaybackRequest { 
	 public Object []playbackList;
	 public boolean recursive;
	 public boolean requestProperties;
	 public boolean requestOnCopy;
	 public boolean shuffled;
	 
	 public MediaPlayerPanel player;
	 public int pauseBetween;
	 public int introFrames;
	 public ContentMatcher matcher;
	 
	 // used to keep position on playing list which can expand or shrink
	 public List playList;
	 public ListModel playListModel;
	 public int payedIndex;
	 
	 public PlaybackRequest() {
	 }
	 
	 public PlaybackRequest(Object []list, boolean recursive) {
		 this(list, null, recursive);
	 }

	 public PlaybackRequest(Object []list) {
		 this(list, null);
	 }

	 public PlaybackRequest(Object []list, Serializer serializer, boolean recursive) {
		 this(list, serializer);
		 this.recursive = recursive;
	 }

	 public PlaybackRequest(Object []list, Serializer serializer) {
		 this(serializer);
		 playbackList = list;		 
	 }
	 
	 public PlaybackRequest(ListModel list, Serializer serializer) {
		 this(serializer);
		 playListModel = list;	 	 
	 }
	 
	 public PlaybackRequest(List list, Serializer serializer) {
		 this(serializer);
		 playList = list;	 	 
	 }

	 public PlaybackRequest(Serializer serializer) {
		 if (serializer != null)
			 initAttributes(serializer);
	 }
	 
	 protected void initAttributes(Serializer serializer) {
		 setRecursive(serializer);
		 setIntoFrames(serializer);
		 setAskProperties(serializer);
		 setAskOnCopy(serializer);
		 setPauseBetween(serializer);
	 }
	 
	 protected void setRecursive(Serializer ser) {
		 recursive = Serializer.getInt(ser.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.RECURSIVE_PLAYBACK), 0) == 1;
	 }

	 protected void setIntoFrames(Serializer ser) {
		 introFrames = Serializer.getInt(ser.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.INTRO_FRAMES), 0);
	 }
	 
	 protected void setAskProperties(Serializer ser) {
		 requestProperties = ser.getInt(ser.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.REQUEST_PLAYMODE), 0) == 1;
	 }

	 protected void setAskOnCopy(Serializer ser) {
		 requestOnCopy = ser.getInt(ser.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.REQUEST_COPYFILTER), 0) == 1;
	 }
	 
	 protected void setPauseBetween(Serializer ser) {
		 pauseBetween = ser.getInt(ser.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.SONGS_PAUSE), 0)*1000;
	 }
	 
	 public void playList(final Controller controller) {
		 initAttributes(controller.getSerializer());
		 if(requestProperties
			 && (playbackList.length > 1 || (playbackList.length == 1 
			 && playbackList[0] instanceof File && ((File)playbackList[0]).isDirectory()))) {
			 new Thread(new Runnable() {
				 public void run() {
					 PlaybackProperties.doModal(controller, PlaybackRequest.this);
					 if (matcher != null)
						 controller.playMediaList(PlaybackRequest.this);
				 }}, "PlayList").start();
		 } else {
			 introFrames = 0;
			 controller.playMediaList(this);
		 }
	 }
	 
	 public Object[] buildList(Controller controller) {
		 initAttributes(controller.getSerializer());
		 if(requestProperties
			 && (playbackList.length > 1 || (playbackList.length == 1 
			 && playbackList[0] instanceof File && ((File)playbackList[0]).isDirectory()))) {
			 PlaybackProperties pbProps = PlaybackProperties.doPropertiesDialog(controller, null);
		 }
		 return playbackList;
	 }
	 
	 // TODO: add call back for update selection to currently played
	 public void playList(final int pos, final Controller controller) {
		 if (playListModel == null)
			 return;
		 new Thread(new Runnable () {
			 public void run() {
				 for (int k=pos; k<playListModel.getSize(); k++) {
					 AbstractFormat media = ((Thumbnail)playListModel.getElementAt(k)).getFormat();
					 if(media instanceof MP3) 
						 try {
							 player = controller.playMedia(media, introFrames);
							 player.waitForCompletion();
							 if (player.isClosed())
								 break;
							 if (pauseBetween > 999)
								 try {
									 Thread.sleep(pauseBetween);
								 } catch(InterruptedException ie) {
								 }
						 } catch(IOException ioe) {
							 System.err.println("Problem "+ioe+" for "+media);
						 }
				 }
			 }
			 }, "Model Play List").start();
	 }
}
