/* PhotoOrganizer - $RCSfile: Converter.java,v $ 
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  
 *  Visit http://drogatkin.openestate.net to get the latest infromation
 *  about Rogatkin's products.
 *  $Id: Converter.java,v 1.2 2001/04/17 09:01:01 dmitriy Exp $
 */

package photoorganizer.formats.mp3;
import java.io.*;
import java.awt.image.renderable.*;
import javax.media.jai.*;
import com.sun.media.jai.codec.*;

public class Converter {
    static final float AV715_IMG_WIDTH = 704F;
		static final float AV715_IMG_HEIGHT = 480F;
			
	void convert(String _inFile, String _outFile) {
		try {
			RenderedOp im = JAI.create("fileload", _inFile);
			float w = im.getWidth();
			float h = im.getHeight();
			ParameterBlockJAI pb = new ParameterBlockJAI("Scale");
			pb.addSource(im);
			// find scale factor for nearest
			float mScale = AV715_IMG_WIDTH/w;
			float yScale = AV715_IMG_HEIGHT/h;
			if (mScale < yScale)
				mScale = yScale;
			System.out.println("Source image size "+w+'x'+h+" scale factor "+mScale);
			pb.set(mScale, "xScale");
			pb.set(mScale, "yScale"); // Interpolation.INTERP_NEAREST
			im = JAI.create("Scale", pb);
			pb = new ParameterBlockJAI("Crop");
			pb.addSource(im);
			pb.set(0F, "x");
			pb.set(0F, "y");
			pb.set(AV715_IMG_WIDTH, "width");
			pb.set(AV715_IMG_HEIGHT, "height");
			im = JAI.create("Crop", pb);

			BMPEncodeParam ep = new BMPEncodeParam();
			ImageCodec.createImageEncoder("BMP", new FileOutputStream(_outFile), ep).encode(im);
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	static public void main(String args[]) {
                System.out.println("Image converter to BMP for Raite MP3 player V1.0 Copyright Dmitriy Rogatkin");
		if (args.length < 2) {
			System.out.println("Usage: <input file name> <output file name>");
			System.exit(255);
		}
		
		new Converter().convert(args[0], args[1]);
	}
}