/* MediaChest - MP3 
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  
 *  Visit http://drogatkin.openestate.net to get the latest infromation
 *  about Rogatkin's products.
 *  $Id: MP3.java,v 1.16 2001/07/31 08:34:49 rogatkin Exp $
 */
package photoorganizer.formats;
import java.lang.reflect.*;
import java.io.*;
import java.awt.Dimension;
import javax.swing.Icon;
import photoorganizer.Resources;
import photoorganizer.Controller;
import de.vdheide.mp3.MP3File;
import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.NoMP3FrameException;
import de.vdheide.mp3.ID3v2WrongCRCException;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.TagContent;

public class MP3 implements AbstractFormat { 
	public static final String LAYER_NAMES[] = { "I", "II", "III" };
	public static final String S_FREQ[] = {"44.1", "48", "32", "0"};
	public static final String MODE_NAMES[] = { "stereo", "j-stereo", "dual-ch", "mono" };

	public final static String GENRES [] = {
		"Blues", // 0
		"Classic Rock", // 1
		"Country", // 2
		"Dance", // 3
		"Disco", // 4
		"Funk", // 5
		"Grunge", // 6
		"Hip-Hop", // 7
		"Jazz", // 8
		"Metal", // 9
		"New Age", // 10
		"Oldies", // 11
		"Other", // 12
		"Pop", // 13
		"R&B", // 14
		"Rap", // 15
		"Reggae", // 16
		"Rock", // 17
		"Techno", // 18
		"Industrial", // 19
		"Alternative", // 20
		"Ska", // 21
		"Death Meta", // 22
		"Pranks", // 23
		"Soundtrack", // 24
		"Euro-Techno", // 25
		"Ambient", // 26
		"Trip-Hop", // 27
		"Vocal", // 28
		"Jazz+Funk", // 29
		"Fusion", // 30
		"Trance", // 31
		"Classical", // 32
		"Instrumental", // 33
		"Acid", // 34
		"House", // 35
		"Game" , // 36
		"Sound Clip", // 37
		"Gospel", // 38
		"Noise", // 39
		"AlternRock", // 40
		"Bass", // 41
		"Soul", // 42
		"Punk", // 43
		"Space", // 44
		"Meditative", // 45
		"Instrumental Pop", // 46
		"Instrumental Rock", // 47
		"Ethnic", // 48
		"Gothic", // 49
		"Darkwave", // 50
		"Techno-Industrial", // 51
		"Electronic", // 52
		"Pop-Folk", // 53
		"Eurodance", // 54
		"Dream", // 55
		"Southern Rock", // 56
		"Comedy", // 57
		"Cult", // 58
		"Gangsta", // 59
		"Top 40", // 60
		"Christian Rap", // 61
		"Pop/Funk", // 62
		"Jungle", // 63
		"Native American", // 64
		"Cabaret", // 65
		"New Wave", // 66
		"Psychadelic", // 67
		"Rave", // 68
		"Showtunes", // 69
		"Trailer", // 70
		"Lo-Fi", // 71
		"Tribal", // 72
		"Acid Punk", // 73
		"Acid Jazz", // 74
		"Polka", // 75
		"Retro", // 76
		"Musical", // 77
		"Rock & Roll", // 78
		"Hard Rock", // 79
		// WinAmp expanded this table with next codes:
		"Folk", // 80
		"Folk-Rock", // 81
		"National Folk", // 82
		"Swing", // 83
		"Fast Fusion", // 84
		"Bebob", // 85
		"Latin", // 86
		"Revival", // 87
		"Celtic", // 88
		"Bluegrass", // 89
		"Avantgarde", // 90
		"Gothic Rock", // 91
		"Progressive Rock", // 92
		"Psychedelic Rock", // 93
		"Symphonic Rock", // 94
		"Slow Rock", // 95
		"Big Band", // 96
		"Chorus", // 97
		"Easy Listening", // 98
		"Acoustic", // 99
		"Humour", // 100
		"Speech", // 101
		"Chanson", // 102
		"Opera", // 103
		"Chamber Music", // 104
		"Sonata", // 105
		"Symphony", // 106
		"Booty Brass", // 107
		"Primus", // 108
		"Porn Groove", // 109
		"Satire", // 110
		"Slow Jam", // 111
		"Club", // 112
		"Tango", // 113
		"Samba", // 114
		"Folklore", // 115
		"Ballad", // 116
		"Poweer Ballad", // 117
		"Rhytmic Soul", // 118
		"Freestyle", // 119
		"Duet", // 120
		"Punk Rock", // 121
		"Drum Solo", // 122
		"A Capela", // 123
		"Euro-House", // 124
		"Dance Hall" // 125 
		};

	
	
	public static final String MP3 = "MP3";
	public static final String TYPE = MP3;
	protected static final Class [] EMPTY_PARAMS = {};
	protected static Icon icon = Controller.getResourceIcon(Resources.IMG_MP3ICON);
	protected static byte[] defaultIconData;

	Mp3Info info;
	
	public MP3(File file) {
		try {
			if (!file.getName().regionMatches(true, file.getName().length()-MP3.length(), MP3, 0, MP3.length()))
				throw new Exception("Wrong extension for MP3 for file "+file);
			info = new Mp3Info(file);
			info.getLength();
		} catch(Exception e) {
			info = null;
//			System.err.println(e.toString()+' '+file);
		}
	}
	
	public AbstractInfo getInfo() {
		return info;
	}
	
	public boolean isValid() {
		return info != null;
	}
	
	public String getType() {
		return MP3;
	}
	
	public String getThumbnailType() {
		// info.getPicture().getBinaryContent();
		return Resources.EXT_JPEG;
	}
	
	public Icon getThumbnail(Dimension size) {
		// TODO: get image from id tag
		try {
			byte[] image = info.getPicture().getBinaryContent();
		} catch(de.vdheide.mp3.FrameDamagedException fe) {
		} catch(Exception e) {
		}
		return icon;
	}

	public InputStream getAsStream() throws IOException {
		if (info != null)
			if (!Controller.isJdk1_4())
				return getUrl().openStream(); //a caller can use new BufferedInputStream()
			else	
				return new FileInputStream(info);
		return null;
	}
	
	public byte[] getThumbnailData(Dimension size) {
		try {
			byte[] res = info.getPicture().getBinaryContent();
			if (res != null)
				return res;
		} catch(de.vdheide.mp3.FrameDamagedException fe) {
		} catch(Exception e) {
		}
		synchronized(MP3) {
			if (defaultIconData == null) {
				try {
					BufferedInputStream bis = new BufferedInputStream(ClassLoader.getSystemResourceAsStream(Resources.IMG_MP3ICON));
					ByteArrayOutputStream bos = new ByteArrayOutputStream(8*1024);
					Controller.copyStream(bis, bos);
					defaultIconData = bos.toByteArray();
					bos.close();
					bis.close();
				} catch(Exception e) { // io or null ptr
					e.printStackTrace();
					defaultIconData = new byte[0];
				}
			}
		}
		return defaultIconData;
	}
		
	public long getFileSize() {
		return getLength();
	}

	public long getLength() {
		if (isValid())
			return info.length();
		return -1;
	}

	public String getName() {
		if (isValid())
			return info.getName();
		return null;
	}

	public File getFile() {
        return info;
    }
	
	public boolean renameTo(File dest) {
		if( info.renameTo(dest) ) 
		try {
			info = new Mp3Info(dest);
			return true;
		} catch(Exception e) {
		}
		return false;
	}
	
	public java.net.URL getUrl() {
		try {
			return info.toURL();
		} catch(java.net.MalformedURLException me) {
			return null;
		} 
    }
	
	public String toString() {
		if (isValid())
			return info.toString();
		return super.toString();
	}
	
	public static String convertTime(long time) {
		return (time/(60*60) > 0?String.valueOf(time/60/60):"")+':'+(time%(60*60)/60<10?"0":"")+(time%(60*60)/60)+
						':'+(time%60<10?"0":"")+(time%60);
	}
		
	class Mp3Info extends MP3File implements AbstractInfo {
		Mp3Info(File file) throws IOException, NoMP3FrameException,
								  ID3v2WrongCRCException, ID3v2DecompressionException,
							  ID3v2IllegalVersionException {
			// TODO: more clear about encoding
			super(file, "", BasicJpeg.getEncoding());
		}
		

		public void setAttribute(String name, Object value) {
			try {
				getClass().getMethod("set"+name, new Class[] {value.getClass()}).invoke(this, new Object[] {value});
			} catch(Throwable t) {
				if (value instanceof String)
					try {
						TagContent content = new TagContent();
						content.setContent((String)value);
						getClass().getMethod("set"+name, new Class[] {TagContent.class}).invoke(this, new Object[] {content});
					} catch(Throwable t2) {
						throw new IllegalArgumentException("Not supported attribute name "+name+" to set TagContent ("+value+") <<"+t2);
					}
				else
					throw new IllegalArgumentException("Not supported set attribute name "+name+" to value "+value+" <<"+t);
			}
		}
		
		public Object getAttribute(String name) {
			try {
				if (ESS_CHARACHTER.equals(name)) 			
					return new Integer(getBitrate());
				else if (ESS_TIMESTAMP.equals(name) || LENGTH.equals(name)) {
					long l = getLength();
					return (l/(60*60) > 0?String.valueOf(l/60/60):"")+':'+(l%(60*60)/60)+
						':'+(l%60<10?"0":"")+(l%60);
				} else if (ESS_QUALITY.equals(name) || MODE.equals(name))
					return MODE_NAMES[getMode()];
				else if (ESS_MAKE.equals(name))
					return getArtist().getTextContent();
				else {
					Object result = getGenericAttribute(name);
					if (result instanceof TagContent)
						return ((TagContent)result).getTextContent();
					return result;
				}				
			} catch(FrameDamagedException fde) {
				fde.printStackTrace();
			}
			return null;
		}
		
		public int getIntAttribute(String name) {
			if (ESS_CHARACHTER.equals(name))
				try {
					return Integer.parseInt(getYear().getTextContent());
				} catch(Exception e) {
					return 0;
				}
			else {
				Object result = getGenericAttribute(name);
				if (result != null) {
					if (result instanceof Integer)
					   return ((Integer)result).intValue();
					else if (result instanceof String)
						try {
							return Integer.parseInt((String)result);
						} catch(NumberFormatException nfe) {
						}
					else if (result instanceof TagContent)
						try {
							return Integer.parseInt(((TagContent)result).getTextContent());
						} catch(NumberFormatException nfe) {
						}
				} else
					return 0;
			}
			throw new IllegalArgumentException("Not supported attribute name for int "+name);
		}
		
		public float getFloatAttribute(String name) {
			if (ESS_CHARACHTER.equals(name))
				return ((float)getSamplerate())/1000f;
			else {
				Object result = getGenericAttribute(name);
				if (result != null) {
					if (result instanceof Float)
					   return ((Float)result).floatValue();
				} else
					return 0;
			}
			throw new IllegalArgumentException("Not supported attribute name for float "+name);
		}

		public long getLongAttribute(String name) {
			Object result = getGenericAttribute(name);
			if (result != null) {
				if (result instanceof Long)
					return ((Long)result).longValue();
			} else
				return 0;
			throw new IllegalArgumentException("Not supported attribute name for long "+name);
		}
		
		public double getDoubleAttribute(String name) {
			Object result = getGenericAttribute(name);
			if (result != null) {
				if (result instanceof Double)
					return ((Double)result).doubleValue();
			} else
				return 0;
			throw new IllegalArgumentException("Not supported attribute name for double "+name);
		}
		
		public boolean getBoolAttribute(String name) {
			if (ESS_CHARACHTER.equals(name))
				return getProtection(); // TODO: replace by VBR
			else {
				Object result = getGenericAttribute(name);
				if (result != null) {
					if (result instanceof Boolean)
					   return ((Boolean)result).booleanValue();
				} else
					return false;
			}				
			throw new IllegalArgumentException("Not supported attribute name for boolean "+name);
		}
		
		public String toString() {
			try {
				return ""+(getAttribute(ESS_MAKE)!=null?getAttribute(ESS_MAKE):super.toString())
					+' '+getAttribute(ESS_CHARACHTER)+' '+getAttribute(ESS_TIMESTAMP)
					+' '+getFloatAttribute(ESS_CHARACHTER);
			} catch (IllegalArgumentException iae) {
			}
			return super.toString();
		}

		/** returns for format such attributes as: title, artist, album, year, file
		 */                                                                        

		public Object[] getFiveMajorAttributes() {
			try {
				fiveObjects[0] = getAttribute(TITLE)/*.getTextContent()*/;
			}catch(Exception e) {
				fiveObjects[0] = Resources.LABEL_UNKNOWN;
			}
			try {
				fiveObjects[1] = getAttribute(ARTIST);
			}catch(Exception e) {
				fiveObjects[1] = Resources.LABEL_UNKNOWN;
			}
			try {
				fiveObjects[2] = getAttribute(ALBUM);
			}catch(Exception e) {
				fiveObjects[2] = Resources.LABEL_UNKNOWN;
			}
			try {
				fiveObjects[3] = new Integer(getIntAttribute(YEAR));
			}catch(Exception e) {
				fiveObjects[3] = "";
			}
			fiveObjects[4] = this.getName();
			return fiveObjects;
		}		
		
		protected Object getGenericAttribute(String name) {
			try {
				return getClass().getMethod("get"+name, EMPTY_PARAMS).invoke(this, EMPTY_PARAMS);
			} catch(Throwable t) {
				if (t instanceof InvocationTargetException)
					throw new IllegalArgumentException("Not supported attribute name for "+name+" <<"+((InvocationTargetException)t).getTargetException());
				else
					throw new IllegalArgumentException("Not supported attribute name for "+name+" <<"+t);
			}
		}
		
		
		
		protected Object [] fiveObjects = new Object[5];
	}
}

