/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;
import photoorganizer.Controller;

public class TwoPanesView
extends JPanel
implements ActionListener {
    JTextArea lowerView;
    JEditorPane upperView;
    JScrollPane upperScroll;
    Window window;
    Object modal;
    String returnCode;

    protected TwoPanesView(boolean bl, Window window, int n, ActionListener actionListener) {
        this.setLayout(new BorderLayout());
        this.upperView = new JEditorPane();
        this.upperScroll = new JScrollPane(this.upperView);
        this.add((Component)this.upperScroll, "North");
        this.upperView.setEditable(false);
        this.add((Component)Controller.createButtonPanel(actionListener != null ? actionListener : this, n, 1), "Center");
        if (!bl) {
            this.lowerView = new JTextArea();
            this.add((Component)new JScrollPane(this.lowerView), "South");
        }
        this.window = window;
        if (window != null && window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            jFrame.setContentPane(this);
            jFrame.pack();
            jFrame.setDefaultCloseOperation(0);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TwoPanesView.this.setReturnCode("Cancel");
                    TwoPanesView.this.window.dispose();
                }
            });
        }
    }

    public static TwoPanesView createFramed(boolean bl, Window window, int n, ActionListener actionListener) {
        return new TwoPanesView(bl, window, n, actionListener);
    }

    public void setSize(int n, int n2) {
        if (this.window != null) {
            this.window.setSize(n, n2);
        } else {
            super.setSize(n, n2);
        }
        this.upperScroll.setPreferredSize(new Dimension(n - 20, n2 * 80 / 100));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setReturnCode(actionEvent.getActionCommand());
        if (this.window != null) {
            this.window.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReturnCode(String string) {
        this.returnCode = string;
        if (this.modal != null) {
            Object object = this.modal;
            synchronized (object) {
                this.modal.notify();
            }
        }
    }

    public void show() {
        if (this.window != null) {
            this.window.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showModal() {
        this.modal = new Object();
        this.show();
        Object object = this.modal;
        synchronized (object) {
            try {
                this.modal.wait();
            }
            catch (InterruptedException interruptedException) {
                this.returnCode = null;
            }
        }
        return this.returnCode;
    }

    public void setUpperText(String string) {
        this.setUpperText(string, "text/html");
    }

    public void setUpperText(String string, String string2) {
        System.err.println("Editor: " + JEditorPane.getEditorKitClassNameForContentType(string2));
        this.upperView.setContentType(string2);
        this.upperView.setText(string);
        this.upperView.setDocument(this.upperView.getDocument());
    }

    public void readToUpper(InputStream inputStream) throws IOException {
        this.upperView.setContentType("text/html");
        this.upperView.read(inputStream, (Object)new HTMLEditorKit());
    }

    public void setUpperURL(URL uRL) throws IOException {
        this.upperView.setPage(uRL);
    }

    public void setLowerText(String string) {
        if (this.lowerView != null) {
            this.lowerView.setText(string);
        }
    }

    public void appendLowerText(String string) {
        if (this.lowerView != null) {
            this.lowerView.setText(this.lowerView.getText() + string);
        }
    }
}

