/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.renderer.ColumnDescriptor;
import photoorganizer.renderer.RadioButtonsGroup;
import rogatkin.GranulatedLayout;
import rogatkin.Persistable;
import rogatkin.Serializer;

public final class AppearanceOptionsTab
extends JPanel
implements Persistable {
    public static final String SECNAME = "AppearanceOptions";
    public static final String PANES_VIEW = "PanesConfig";
    public static final String FIT_TO_SIZE = "FitToSize";
    public static final String INSTANT_UPDATE = "InstantUpdate";
    public static final String LABEL_ = "Label";
    public static final String METHOD_ = "Method";
    public static final String BROWSE_ = "Browse";
    public static final String COLLECT_ = "Collect";
    public static final String ALIGN_ = "Align";
    public static final String TYPE_ = "Type";
    public static final String[] COLUMN_CHOICES = new String[]{"", "Album", "Artist", "Bitrate", "Genre", "Length", "Mode", "Title", "Comments", "Samplerate", "Track", "Year", "Make", "Model", "DateTimeOriginal", "FNumber", "Shutter", "Flash", "Quality", "FocalLength", "Metering", "ExpoProgram", "ResolutionX"};
    public static final ColumnDescriptor[][] DEF_TBL_DESCR = new ColumnDescriptor[][]{{new ColumnDescriptor("Name", new String[]{null, null, "Name"}, 0, 0), new ColumnDescriptor("Size", new String[]{null, null, "Length"}, 2, 2), new ColumnDescriptor("Type", new String[]{"Make", "Title", "Type"}, 0, 0), new ColumnDescriptor("Modified", new String[]{"DateTimeOriginal", "Length", "Date"}, 0, 0), new ColumnDescriptor("Shutter", new String[]{"Shutter", "Bitrate", null}, 2, 2), new ColumnDescriptor("Aperture", new String[]{"FNumber", "Samplerate", null}, 2, 2), new ColumnDescriptor("Flash", new String[]{"Flash", null, null}, 1, 1), new ColumnDescriptor("Quality", new String[]{"Quality", "Mode", null}, 0, 0), new ColumnDescriptor("Zoom", new String[]{"FocalLength", "Year", null}, 2, 2)}, {new ColumnDescriptor("Name", new String[]{null, null, "Name"}, 0, 0), new ColumnDescriptor("Taken", new String[]{"DateTimeOriginal", "Length", "Date"}, 0, 0), new ColumnDescriptor("Shutter", new String[]{"Shutter", "Bitrate", null}, 2, 2), new ColumnDescriptor("Aperture", new String[]{"FNumber", "Samplerate", null}, 2, 2), new ColumnDescriptor("Flash", new String[]{"Flash", null, null}, 1, 1)}};
    public static final int THREE_PANES = 0;
    public static final int TWO_PANES = 1;
    public static final int BROWSE_VIEW = 0;
    public static final int COLLECT_VIEW = 1;
    public static final String LIST_STRING = "String";
    public static final String LIST_BOOL = "Bool";
    public static final String LIST_NUMBER = "Number";
    public static final String LIST_DATE = "Date";
    public static final String[] COLUMN_TYPES = new String[]{"String", "Bool", "Number", "Date"};
    public static final int TYP_DATE = 3;
    public static final int MAX_COLUMNS = 10;
    public static final int IN_ROW = 2;
    public static final String[] VIEW_TABLES = new String[]{"Browse", "Collect"};
    public static final String[] ATTR_SEQS = new String[]{"Prime", "Second", "Third"};
    protected Controller controller;
    protected RadioButtonsGroup groupPanes;
    protected RadioButtonsGroup bg_tableView;
    protected JCheckBox cb_fitToSize;
    protected JCheckBox cb_instantUpdate;
    protected JComboBox cb_primeColType;
    protected JComboBox cb_secColType;
    protected JComboBox cb_thirdColType;
    protected JComboBox cb_dataType;
    protected JComboBox cb_align;
    protected JTextField tf_seq;
    protected JTextField tf_label;
    protected ColumnHeaderGrid headers;
    protected ColumnDescriptor[][] tables;
    protected int oldTableSelected;
    protected int oldCellSelected;

    public AppearanceOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(6, 7, 20, 4, 8, 8));
        this.headers = new ColumnHeaderGrid();
        this.add((Component)this.headers, "0,0,2,5");
        this.tf_label = new JTextField();
        this.add((Component)this.tf_label, "2,0,2");
        this.cb_primeColType = new JComboBox<String>(COLUMN_CHOICES);
        this.add(this.cb_primeColType, "2,1,2");
        this.cb_secColType = new JComboBox<String>(COLUMN_CHOICES);
        this.add(this.cb_secColType, "2,2,2");
        this.cb_thirdColType = new JComboBox<String>(Resources.FILE_ATTRIBUTES);
        this.add(this.cb_thirdColType, "2,3,2");
        this.cb_align = new JComboBox<String>(Resources.HORIZ_ALIGN);
        this.add(this.cb_align, "2,4");
        this.cb_dataType = new JComboBox<String>(COLUMN_TYPES);
        this.add(this.cb_dataType, "3,4");
        this.tf_seq = new JTextField();
        this.add((Component)this.tf_seq, "2,5");
        this.tf_seq.setHorizontalAlignment(4);
        JButton jButton = new JButton("Reset");
        this.add((Component)jButton, "3,5");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppearanceOptionsTab.this.reset();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Panes"));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "4,0,2,7,16,8");
        this.groupPanes = new RadioButtonsGroup();
        JRadioButton jRadioButton = new JRadioButton("2 panes switchable");
        this.add((Component)jRadioButton, "4,1,2,1,28");
        this.groupPanes.add(jRadioButton, 1);
        jRadioButton = new JRadioButton("3 panes");
        this.add((Component)jRadioButton, "4,2,1,1,28");
        this.groupPanes.add(jRadioButton, 0);
        this.cb_fitToSize = new JCheckBox("Fit to size");
        this.add((Component)this.cb_fitToSize, "4,4,2,1,28");
        this.cb_instantUpdate = new JCheckBox("Instant update");
        this.add((Component)this.cb_instantUpdate, "4,5,2,1,28");
        this.bg_tableView = new RadioButtonsGroup(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (AppearanceOptionsTab.this.oldTableSelected != AppearanceOptionsTab.this.bg_tableView.getSelectedIndex()) {
                    AppearanceOptionsTab.this.oldTableSelected = AppearanceOptionsTab.this.bg_tableView.getSelectedIndex();
                    AppearanceOptionsTab.this.fillCellHeaders(AppearanceOptionsTab.this.oldTableSelected);
                }
            }
        });
        jRadioButton = new JRadioButton("Browser view");
        this.add((Component)jRadioButton, "0,5,2");
        this.bg_tableView.add(jRadioButton, 0);
        jRadioButton = new JRadioButton("Collection view");
        this.add((Component)jRadioButton, "0,6,2");
        this.bg_tableView.add(jRadioButton, 1);
        this.oldTableSelected = 0;
        this.oldCellSelected = -1;
        this.bg_tableView.setSelectedIndex(0);
        jButton = new JButton("Default");
        this.add((Component)jButton, "2,6,2");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppearanceOptionsTab.this.tables = new ColumnDescriptor[VIEW_TABLES.length][];
                AppearanceOptionsTab.this.oldCellSelected = -1;
                AppearanceOptionsTab.this.save();
                AppearanceOptionsTab.this.load();
            }
        });
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        this.groupPanes.setSelectedIndex(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)PANES_VIEW), (int)1));
        this.cb_fitToSize.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)FIT_TO_SIZE), (int)0) == 1);
        this.cb_instantUpdate.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)INSTANT_UPDATE), (int)0) == 1);
        this.tables = AppearanceOptionsTab.readDescriptions(serializer);
        this.fillCellHeaders(this.bg_tableView.getSelectedIndex());
    }

    public static ColumnDescriptor[][] readDescriptions(Serializer serializer) {
        ColumnDescriptor[][] columnDescriptorArray = new ColumnDescriptor[VIEW_TABLES.length][];
        int n = 0;
        while (n < VIEW_TABLES.length) {
            ColumnDescriptor[] columnDescriptorArray2 = new ColumnDescriptor[10];
            int n2 = 0;
            boolean bl = true;
            int n3 = 0;
            while (n3 < 10) {
                String string = (String)serializer.getProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + LABEL_ + n3));
                if (string == null || string.trim().length() == 0) {
                    if (bl && DEF_TBL_DESCR[n].length > n3 && DEF_TBL_DESCR[n][n3] != null && AppearanceOptionsTab.DEF_TBL_DESCR[n][n3].label.length() > 0) {
                        columnDescriptorArray2[n2++] = (ColumnDescriptor)DEF_TBL_DESCR[n][n3].clone();
                    }
                } else {
                    bl = false;
                    String[] stringArray = new String[ATTR_SEQS.length];
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < ATTR_SEQS.length) {
                        stringArray[n4] = (String)serializer.getProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + METHOD_ + ATTR_SEQS[n4] + n3));
                        bl2 |= stringArray[n4] != null && stringArray[n4].trim().length() > 0;
                        ++n4;
                    }
                    if (bl2) {
                        int n5 = Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + ALIGN_ + n3)), (int)0);
                        int n6 = Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + TYPE_ + n3)), (int)0);
                        columnDescriptorArray2[n2++] = new ColumnDescriptor(string, stringArray, n6, n5);
                    }
                }
                ++n3;
            }
            columnDescriptorArray[n] = columnDescriptorArray2;
            ++n;
        }
        return columnDescriptorArray;
    }

    public void save() {
        this.storeAttributes(this.oldTableSelected, this.oldCellSelected);
        Serializer serializer = this.controller.getSerializer();
        serializer.setProperty((Object)SECNAME, (Object)PANES_VIEW, (Object)new Integer(this.groupPanes.getSelectedIndex()));
        serializer.setProperty((Object)SECNAME, (Object)FIT_TO_SIZE, (Object)(this.cb_fitToSize.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)INSTANT_UPDATE, (Object)(this.cb_instantUpdate.isSelected() ? Resources.I_YES : Resources.I_NO));
        int n = 0;
        while (this.tables != null && n < this.tables.length) {
            ColumnDescriptor[] columnDescriptorArray = this.tables[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < 10) {
                if (columnDescriptorArray != null && n3 < columnDescriptorArray.length && columnDescriptorArray[n3] != null && columnDescriptorArray[n3].label != null && columnDescriptorArray[n3].label.trim().length() > 0) {
                    serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + LABEL_ + n2), (Object)columnDescriptorArray[n3].label);
                    String[] stringArray = columnDescriptorArray[n3].attributes;
                    int n4 = 0;
                    while (n4 < ATTR_SEQS.length) {
                        if (stringArray != null && n4 < stringArray.length && stringArray[n4] != null) {
                            serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + METHOD_ + ATTR_SEQS[n4] + n2), (Object)stringArray[n4]);
                        } else {
                            serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + METHOD_ + ATTR_SEQS[n4] + n2), (Object)"");
                        }
                        ++n4;
                    }
                    serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + ALIGN_ + n2), (Object)new Integer(columnDescriptorArray[n3].align));
                    serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + TYPE_ + n2), (Object)new Integer(columnDescriptorArray[n3].type));
                    if (n2 < n3) {
                        this.eraseEntry(serializer, n, n3);
                    }
                    ++n2;
                } else {
                    this.eraseEntry(serializer, n, n3);
                }
                ++n3;
            }
            ++n;
        }
    }

    protected void eraseEntry(Serializer serializer, int n, int n2) {
        serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + LABEL_ + n2), null);
        int n3 = 0;
        while (n3 < ATTR_SEQS.length) {
            serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + METHOD_ + ATTR_SEQS[n3] + n2), null);
            ++n3;
        }
        serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + ALIGN_ + n2), null);
        serializer.setProperty((Object)SECNAME, (Object)(VIEW_TABLES[n] + TYPE_ + n2), null);
    }

    protected void fillCellHeaders(int n) {
        if (this.tables == null) {
            return;
        }
        ColumnDescriptor[] columnDescriptorArray = this.tables[n];
        int n2 = 0;
        while (n2 < 10) {
            ColumnDescriptor columnDescriptor;
            if (n2 < columnDescriptorArray.length && (columnDescriptor = columnDescriptorArray[n2]) != null && columnDescriptor.label != null) {
                ((JToggleButton)this.headers.getComponent(n2)).setText(columnDescriptor.label);
            } else {
                ((JToggleButton)this.headers.getComponent(n2)).setText("");
            }
            ++n2;
        }
        this.fillCellDescr(n, this.oldCellSelected >= 0 ? this.oldCellSelected : 0);
        this.headers.setSelectedIndex(this.oldCellSelected >= 0 ? this.oldCellSelected : 0);
    }

    protected void fillCellDescr(int n, int n2) {
        if (this.tables == null || n < 0 || n2 < 0) {
            return;
        }
        Object[] objectArray = this.tables[n];
        if (objectArray.length > n2) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)objectArray[n2];
            this.tf_seq.setText(String.valueOf(n2));
            if (columnDescriptor != null) {
                if (columnDescriptor.label != null) {
                    this.tf_label.setText(columnDescriptor.label);
                } else {
                    this.tf_label.setText("");
                }
                String[] stringArray = columnDescriptor.attributes;
                if (stringArray != null) {
                    if (stringArray[0] != null) {
                        this.cb_primeColType.setSelectedItem(stringArray[0]);
                    } else {
                        this.cb_primeColType.setSelectedIndex(0);
                    }
                    if (stringArray[1] != null) {
                        this.cb_secColType.setSelectedItem(stringArray[1]);
                    } else {
                        this.cb_secColType.setSelectedIndex(0);
                    }
                    if (stringArray[2] != null) {
                        this.cb_thirdColType.setSelectedItem(stringArray[2]);
                    } else {
                        this.cb_thirdColType.setSelectedIndex(0);
                    }
                    this.cb_dataType.setSelectedIndex(columnDescriptor.type);
                    this.cb_align.setSelectedIndex(columnDescriptor.align);
                    return;
                }
            }
        }
        this.cb_primeColType.setSelectedIndex(0);
        this.cb_secColType.setSelectedIndex(0);
        this.cb_thirdColType.setSelectedIndex(0);
        this.cb_dataType.setSelectedIndex(0);
        this.cb_align.setSelectedIndex(0);
        this.tf_label.setText("");
    }

    protected void reset() {
        this.fillCellDescr(this.oldTableSelected, this.oldCellSelected);
    }

    protected void storeAttributes(int n, int n2) {
        Object object;
        if (this.tables == null || n < 0 || n2 < 0 || n >= this.tables.length || this.tables[n] == null) {
            return;
        }
        int n3 = n2;
        try {
            n3 = Integer.parseInt(this.tf_seq.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 != n2) {
            if (this.tables[n].length > n3) {
                object = this.tables[n][n3];
                this.tables[n][n3] = this.tables[n][n2];
                this.tables[n][n2] = object;
                ((JToggleButton)this.headers.getComponent(n2)).setText(object == null || object.label == null ? "" : object.label);
            }
            n2 = n3;
        }
        if (this.tables[n].length <= n2) {
            object = new ColumnDescriptor[n2 + 1];
            System.arraycopy(this.tables[n], 0, object, 0, this.tables[n].length);
            this.tables[n] = object;
        }
        if ((object = this.tables[n][n2]) == null) {
            this.tables[n][n2] = object = new ColumnDescriptor();
        }
        object.label = this.tf_label.getText();
        if (object.attributes == null || object.attributes.length < ATTR_SEQS.length) {
            object.attributes = new String[ATTR_SEQS.length];
        }
        object.attributes[0] = (String)this.cb_primeColType.getSelectedItem();
        object.attributes[1] = (String)this.cb_secColType.getSelectedItem();
        object.attributes[2] = (String)this.cb_thirdColType.getSelectedItem();
        object.type = this.cb_dataType.getSelectedIndex();
        object.align = this.cb_align.getSelectedIndex();
        ((JToggleButton)this.headers.getComponent(n2)).setText(object.label);
    }

    class ColumnHeaderGrid
    extends JPanel
    implements ChangeListener {
        RadioButtonsGroup groupHeaders;

        ColumnHeaderGrid() {
            this.setLayout(new GridLayout(5, 2));
            this.groupHeaders = new RadioButtonsGroup(this);
            int n = 0;
            while (n < 10) {
                JToggleButton jToggleButton = new JToggleButton();
                this.add(jToggleButton);
                this.groupHeaders.add(jToggleButton, n);
                ++n;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (AppearanceOptionsTab.this.oldCellSelected != this.groupHeaders.getSelectedIndex() || AppearanceOptionsTab.this.oldTableSelected != AppearanceOptionsTab.this.bg_tableView.getSelectedIndex()) {
                AppearanceOptionsTab.this.storeAttributes(AppearanceOptionsTab.this.oldTableSelected, AppearanceOptionsTab.this.oldCellSelected);
                AppearanceOptionsTab.this.oldCellSelected = this.groupHeaders.getSelectedIndex();
                AppearanceOptionsTab.this.oldTableSelected = AppearanceOptionsTab.this.bg_tableView.getSelectedIndex();
                AppearanceOptionsTab.this.fillCellDescr(AppearanceOptionsTab.this.oldTableSelected, AppearanceOptionsTab.this.oldCellSelected);
            }
        }

        void setSelectedIndex(int n) {
            this.groupHeaders.setSelectedIndex(n);
        }
    }
}

