/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.Thumbnail;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.ThumbnailsPanel;

public class AlbumThumbnailsPanel
extends ThumbnailsPanel {
    public AlbumThumbnailsPanel(Controller controller) {
        super(controller);
        this.albumpanel.setTumbnailsPanel(this);
    }

    void setImageView() {
        this.imagepanel = (PhotoImagePanel)this.controller.component(Controller.COMP_IMAGEALBUMPANEL);
    }

    JPopupMenu getRightButtonMenu(ActionListener actionListener, boolean bl) {
        return new AlbumThumbsRightBtnMenu(actionListener);
    }

    void doSpecificAction(AbstractFormat abstractFormat, ActionEvent actionEvent, Thumbnail thumbnail) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Show/Play")) {
            this.showFullImage(abstractFormat, thumbnail);
        } else if (string.equals("Delete") || string.equals("Move to...")) {
            if (string.equals("Move to...")) {
                this.addToAlbum(abstractFormat);
            }
            this.albumpanel.deletePicture(abstractFormat.getFile().getPath());
            this.remove((Component)((Object)thumbnail));
            this.adjustDimension();
        } else if (string.equals("Annotation")) {
            String string2 = this.albumpanel.getCommentOf(abstractFormat.getFile().getPath());
            if ((string2 = (String)JOptionPane.showInputDialog(this, "Type a commentary", "Commentary", 3, null, null, string2)) != null) {
                this.albumpanel.setCommentTo(abstractFormat.getFile().getPath(), string2);
                thumbnail.update();
            }
        } else if (string.equals("To selection")) {
            this.collectionpanel.add(abstractFormat);
        } else if (string.equals("To album")) {
            this.addToAlbum(abstractFormat);
        } else if (string.equals("Print")) {
            this.controller.print(new File[]{new File(abstractFormat.getFile().getPath())});
        }
    }

    public String getImageTitle(AbstractFormat abstractFormat, boolean bl) {
        String string = this.albumpanel.getCommentOf(abstractFormat.getFile().getPath());
        if (string == null || string.length() == 0) {
            string = super.getImageTitle(abstractFormat, bl);
        }
        return string;
    }

    void addToAlbum(AbstractFormat abstractFormat) {
        AlbumSelectionDialog albumSelectionDialog = this.albumpanel.getSelectionDialog();
        albumSelectionDialog.setTitle("Albums selection for - " + abstractFormat.getFile());
        albumSelectionDialog.setVisible(true);
        TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
        if (treePathArray != null) {
            this.albumpanel.addToAlbum(new AbstractFormat[]{abstractFormat}, treePathArray);
        }
    }

    class AlbumThumbsRightBtnMenu
    extends JPopupMenu {
        AlbumThumbsRightBtnMenu(ActionListener actionListener) {
            JMenuItem jMenuItem = new JMenuItem("Show/Play");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("To selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("To album");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("Move to...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Annotation");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            this.addSeparator();
            jMenuItem = new JMenuItem("Print");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
        }
    }
}

