/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.album.MediaAccess;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.renderer.AlbumPane;
import rogatkin.GranulatedLayout;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class AlbumOptionsTab
extends JPanel
implements ActionListener,
Persistable {
    public static final String SECNAME = "AlbumOptions";
    public static final String DRIVER = "JDBCDriver";
    public static final String DBURL = "DatabaseURL";
    public static final String USER = "User";
    public static final String PSWD = "Password";
    public static final String USEALBUMFOLDER = "AlbumFolders";
    public static final String MOVETOFOLDER = "MoveToAlbum";
    public static final String IGNORE_DB_ERR = "IgnoreDatabaseErrors";
    public static final String ALBUMROOT = "AlbumRoot";
    public static final String USEENCODING = "UseEncoding";
    public static final String DEFAULT_JDBC_DRIVER = "com.ms.jdbc.odbc.JdbcOdbcDriver";
    public static final String DEFAULT_DB_URL = "jdbc:odbc:MediaChest";
    Controller controller;
    AlbumPane albumpane;
    JTextField tf_driver_class;
    JTextField tf_db_url;
    JTextField tf_db_user;
    JTextField tf_album_root;
    JPasswordField tf_db_pswd;
    JCheckBox cb_nowarn;
    JCheckBox cb_maintaindir;
    JCheckBox cb_moveto;
    JCheckBox cb_useEnc;
    JButton bt_browse;

    public AlbumOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(7, 7, 20, 4, 8, 8));
        this.add((Component)new JLabel("JDBC driver class name"), "0,0,3");
        this.tf_driver_class = new JTextField();
        this.add((Component)this.tf_driver_class, "0,1,5");
        this.add((Component)new JLabel("Database URL"), "0,2,2");
        this.tf_db_url = new JTextField();
        this.add((Component)this.tf_db_url, "0,3,5");
        this.add((Component)new JLabel(USER), "5,0,1");
        this.tf_db_user = new JTextField();
        this.add((Component)this.tf_db_user, "5,1,2");
        this.add((Component)new JLabel(PSWD), "5,2,2");
        this.tf_db_pswd = new JPasswordField();
        this.add((Component)this.tf_db_pswd, "5,3,2");
        this.cb_nowarn = new JCheckBox("No warn if JDBC failed");
        this.add((Component)this.cb_nowarn, "0,4,3");
        JButton jButton = new JButton("Drop tables");
        this.add((Component)jButton, "3,4,2");
        jButton.addActionListener(this);
        jButton = new JButton("Check driver");
        this.add((Component)jButton, "5,4,2");
        jButton.addActionListener(this);
        this.cb_maintaindir = new JCheckBox("Maintain album folders");
        this.add((Component)this.cb_maintaindir, "0,5,2");
        this.tf_album_root = new JTextField();
        this.add((Component)this.tf_album_root, "2,5,4");
        this.bt_browse = new JButton("Browse");
        this.add((Component)this.bt_browse, "6,5,1");
        this.bt_browse.addActionListener(this);
        this.cb_moveto = new JCheckBox("Move picture to album folder");
        this.add((Component)this.cb_moveto, "0,6,3");
        this.cb_useEnc = new JCheckBox("Use encoding for comments");
        this.add((Component)this.cb_useEnc, "3,6,3");
        this.cb_maintaindir.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ((AbstractButton)changeEvent.getSource()).isSelected();
                AlbumOptionsTab.this.tf_album_root.setEnabled(bl);
                AlbumOptionsTab.this.bt_browse.setEnabled(bl);
                AlbumOptionsTab.this.cb_moveto.setEnabled(bl);
            }
        });
        this.albumpane = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JDirectoryChooser jDirectoryChooser;
        String string = actionEvent.getActionCommand();
        MediaAccess mediaAccess = this.albumpane.access;
        if ("Drop tables".equals(string)) {
            if (JOptionPane.showConfirmDialog(this, "All albums will be destroyed, please confirm.", "Confirmation...", 2) == 0) {
                mediaAccess.forgetTables();
                mediaAccess.createTables();
                this.albumpane.invalidateTree();
            }
        } else if ("Check driver".equals(string)) {
            this.reloadDriver();
        } else if ("Browse".equals(string) && (jDirectoryChooser = new JDirectoryChooser(new JFrame(), this.tf_album_root.getText(), null)).getDirectory() != null) {
            this.tf_album_root.setText(jDirectoryChooser.getDirectory());
        }
    }

    private void reloadDriver() {
        int n = Serializer.getInt((Object)this.controller.getSerializer().getProperty((Object)SECNAME, (Object)IGNORE_DB_ERR), (int)0);
        this.controller.getSerializer().setProperty((Object)SECNAME, (Object)IGNORE_DB_ERR, (Object)Resources.I_NO);
        this.albumpane.access.init();
        this.controller.getSerializer().setProperty((Object)SECNAME, (Object)IGNORE_DB_ERR, (Object)new Integer(n));
        this.albumpane.invalidateTree();
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty((Object)SECNAME, (Object)DRIVER);
        if (string != null && string.length() > 0) {
            this.tf_driver_class.setText(string);
        } else {
            this.tf_driver_class.setText(DEFAULT_JDBC_DRIVER);
        }
        string = (String)serializer.getProperty((Object)SECNAME, (Object)DBURL);
        if (string != null && string.length() > 0) {
            this.tf_db_url.setText(string);
        } else {
            this.tf_db_url.setText(DEFAULT_DB_URL);
        }
        string = (String)serializer.getProperty((Object)SECNAME, (Object)USER);
        if (string != null && string.length() > 0) {
            this.tf_db_user.setText(string);
        }
        if ((string = (String)serializer.getProperty((Object)SECNAME, (Object)PSWD)) != null) {
            this.tf_db_pswd.setText(string);
        }
        this.cb_nowarn.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)IGNORE_DB_ERR), (int)0) == 1);
        this.cb_maintaindir.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)USEALBUMFOLDER), (int)0) == 1);
        this.cb_moveto.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)MOVETOFOLDER), (int)0) == 1);
        this.cb_useEnc.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)USEENCODING), (int)0) == 1);
        string = (String)serializer.getProperty((Object)SECNAME, (Object)ALBUMROOT);
        if (string != null) {
            this.tf_album_root.setText(string);
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        boolean bl = false;
        String string = (String)serializer.getProperty((Object)SECNAME, (Object)DRIVER);
        boolean bl2 = string != null && !string.equalsIgnoreCase(this.tf_driver_class.getText());
        serializer.setProperty((Object)SECNAME, (Object)DRIVER, (Object)this.tf_driver_class.getText());
        if (!(bl |= bl2)) {
            string = (String)serializer.getProperty((Object)SECNAME, (Object)DBURL);
            bl |= string != null && !string.equalsIgnoreCase(this.tf_db_url.getText());
        }
        serializer.setProperty((Object)SECNAME, (Object)DBURL, (Object)this.tf_db_url.getText());
        if (!bl) {
            string = (String)serializer.getProperty((Object)SECNAME, (Object)USER);
            bl |= string != null && !string.equalsIgnoreCase(this.tf_db_user.getText());
        }
        serializer.setProperty((Object)SECNAME, (Object)USER, (Object)this.tf_db_user.getText());
        if (!bl) {
            string = (String)serializer.getProperty((Object)SECNAME, (Object)PSWD);
            bl |= string != null && !string.equalsIgnoreCase(this.tf_db_pswd.getText());
        }
        serializer.setProperty((Object)SECNAME, (Object)PSWD, (Object)new String(this.tf_db_pswd.getPassword()));
        serializer.setProperty((Object)SECNAME, (Object)IGNORE_DB_ERR, (Object)(this.cb_nowarn.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)USEALBUMFOLDER, (Object)(this.cb_maintaindir.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)MOVETOFOLDER, (Object)(this.cb_moveto.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)USEENCODING, (Object)(this.cb_useEnc.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)ALBUMROOT, (Object)this.tf_album_root.getText());
        if (bl) {
            this.reloadDriver();
        }
    }
}

