/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.media;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ListModel;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.MP3;
import photoorganizer.formats.Thumbnail;
import photoorganizer.media.ContentMatcher;
import photoorganizer.renderer.MediaPlayerPanel;
import photoorganizer.renderer.PlaybackProperties;
import rogatkin.Serializer;

public class PlaybackRequest {
    public Object[] playbackList;
    public boolean recursive;
    public boolean requestProperties;
    public boolean requestOnCopy;
    public boolean shuffled;
    public MediaPlayerPanel player;
    public int pauseBetween;
    public int introFrames;
    public ContentMatcher matcher;
    public List playList;
    public ListModel playListModel;
    public int payedIndex;

    public PlaybackRequest() {
    }

    public PlaybackRequest(Object[] objectArray, boolean bl) {
        this(objectArray, null, bl);
    }

    public PlaybackRequest(Object[] objectArray) {
        this(objectArray, null);
    }

    public PlaybackRequest(Object[] objectArray, Serializer serializer, boolean bl) {
        this(objectArray, serializer);
        this.recursive = bl;
    }

    public PlaybackRequest(Object[] objectArray, Serializer serializer) {
        this(serializer);
        this.playbackList = objectArray;
    }

    public PlaybackRequest(ListModel listModel, Serializer serializer) {
        this(serializer);
        this.playListModel = listModel;
    }

    public PlaybackRequest(List list, Serializer serializer) {
        this(serializer);
        this.playList = list;
    }

    public PlaybackRequest(Serializer serializer) {
        if (serializer != null) {
            this.initAttributes(serializer);
        }
    }

    protected void initAttributes(Serializer serializer) {
        this.setRecursive(serializer);
        this.setIntoFrames(serializer);
        this.setAskProperties(serializer);
        this.setAskOnCopy(serializer);
        this.setPauseBetween(serializer);
    }

    protected void setRecursive(Serializer serializer) {
        this.recursive = Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"RecursivePlayback"), (int)0) == 1;
    }

    protected void setIntoFrames(Serializer serializer) {
        this.introFrames = Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"IntorductoryFramesNumber"), (int)0);
    }

    protected void setAskProperties(Serializer serializer) {
        this.requestProperties = Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"RequestPlayMode"), (int)0) == 1;
    }

    protected void setAskOnCopy(Serializer serializer) {
        this.requestOnCopy = Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"RequestCopyFilter"), (int)0) == 1;
    }

    protected void setPauseBetween(Serializer serializer) {
        this.pauseBetween = Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"PauseDuration"), (int)0) * 1000;
    }

    public void playList(final Controller controller) {
        this.initAttributes(controller.getSerializer());
        if (this.requestProperties && (this.playbackList.length > 1 || this.playbackList.length == 1 && this.playbackList[0] instanceof File && ((File)this.playbackList[0]).isDirectory())) {
            new Thread(new Runnable(){

                public void run() {
                    PlaybackProperties.doModal(controller, PlaybackRequest.this);
                    if (PlaybackRequest.this.matcher != null) {
                        controller.playMediaList(PlaybackRequest.this);
                    }
                }
            }, "PlayList").start();
        } else {
            this.introFrames = 0;
            controller.playMediaList(this);
        }
    }

    public Object[] buildList(Controller controller) {
        this.initAttributes(controller.getSerializer());
        if (this.requestProperties && (this.playbackList.length > 1 || this.playbackList.length == 1 && this.playbackList[0] instanceof File && ((File)this.playbackList[0]).isDirectory())) {
            PlaybackProperties playbackProperties = PlaybackProperties.doPropertiesDialog(controller, null);
        }
        return this.playbackList;
    }

    public void playList(final int n, final Controller controller) {
        if (this.playListModel == null) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                int n2 = n;
                while (n2 < PlaybackRequest.this.playListModel.getSize()) {
                    AbstractFormat abstractFormat = ((Thumbnail)PlaybackRequest.this.playListModel.getElementAt(n2)).getFormat();
                    if (abstractFormat instanceof MP3) {
                        try {
                            PlaybackRequest.this.player = controller.playMedia(abstractFormat, PlaybackRequest.this.introFrames);
                            PlaybackRequest.this.player.waitForCompletion();
                            if (PlaybackRequest.this.player.isClosed()) break;
                            if (PlaybackRequest.this.pauseBetween > 999) {
                                try {
                                    Thread.sleep(PlaybackRequest.this.pauseBetween);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        catch (IOException iOException) {
                            System.err.println("Problem " + iOException + " for " + abstractFormat);
                        }
                    }
                    ++n2;
                }
            }
        }, "Model Play List").start();
    }
}

