/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.directory;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import photoorganizer.directory.FileSystem;

public class TreeDesktopModel
extends DefaultTreeModel {
    FileSystem fileSystem;
    FileFilter fileFilter;

    public TreeDesktopModel() {
        this((FileFilter)null);
    }

    public TreeDesktopModel(FileFilter fileFilter) {
        super(null);
        this.reset(fileFilter);
    }

    public void reset(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.fileSystem = new FileSystem();
    }

    public TreeCellRenderer adoptCellRenderer(TreeCellRenderer treeCellRenderer) {
        return new FileSystemCellRenderer(treeCellRenderer);
    }

    public Object getChild(Object object, int n) {
        File[] fileArray;
        if (object == this) {
            fileArray = this.fileSystem.getRoots();
        } else {
            fileArray = this.fileSystem.getFiles((File)object, false);
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].isDirectory()) {
                    --n;
                }
                if (n == -1) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n2 > fileArray.length) {
                return null;
            }
        }
        if (n < fileArray.length) {
            return fileArray[n];
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object == this) {
            return this.fileSystem.getRoots().length;
        }
        File[] fileArray = this.fileSystem.getFiles((File)object, false);
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2].isDirectory()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getIndexOfChild(Object object, Object object2) {
        File[] fileArray = object == this ? this.fileSystem.getRoots() : this.fileSystem.getFiles((File)object, false);
        int n = -1;
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2].isDirectory()) {
                ++n;
            }
            if (fileArray[n2].equals(object2)) {
                return n;
            }
            ++n2;
        }
        return -1;
    }

    public Object getRoot() {
        return this;
    }

    public boolean isLeaf(Object object) {
        if (object == this) {
            return false;
        }
        return !((File)object).isDirectory();
    }

    class FileSystemCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        TreeCellRenderer superRenderer;

        FileSystemCellRenderer(TreeCellRenderer treeCellRenderer) {
            this.superRenderer = treeCellRenderer;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof File) {
                return this.ownDraw((File)object, TreeDesktopModel.this.fileSystem.getSystemIcon((File)object));
            }
            return this.superRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        protected Component ownDraw(File file, Icon icon) {
            if (this.superRenderer instanceof JLabel) {
                ((JLabel)((Object)this.superRenderer)).setText(file.getName().length() > 0 && file.toString().endsWith(file.getName()) ? file.getName() : file.toString());
                ((JLabel)((Object)this.superRenderer)).setIcon(icon);
                return (JLabel)((Object)this.superRenderer);
            }
            this.setText(file.getName().length() > 0 && file.toString().endsWith(file.getName()) ? file.getName() : file.toString());
            this.setIcon(icon);
            return this;
        }
    }
}

