/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.directory;

import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import photoorganizer.ftp.FtpFileSystemView;

public class JDirectoryChooser
extends JFileChooser {
    String directory;
    boolean aprove_requested;

    public JDirectoryChooser(Frame frame, String string, FileSystemView fileSystemView) {
        this(frame, string, fileSystemView, null, null, null);
    }

    public JDirectoryChooser(Frame frame, String string, FileSystemView fileSystemView, String string2, String string3, String string4) {
        super(fileSystemView);
        this.setFileSelectionMode(1);
        this.setMultiSelectionEnabled(false);
        if (fileSystemView != null && fileSystemView instanceof FtpFileSystemView) {
            File file = fileSystemView.createFileObject(string);
            if (!file.exists()) {
                file = fileSystemView.createFileObject("/");
                file.exists();
            }
            this.setCurrentDirectory(file);
            this.setDialogTitle("Ftp:Select folder");
        } else {
            File file = new File(string);
            if (file != null && file.exists()) {
                this.setCurrentDirectory(file);
            }
            if (string2 == null) {
                this.setDialogTitle("Select folder");
            } else {
                this.setDialogTitle(string2);
            }
        }
        if (string4 != null) {
            this.setApproveButtonToolTipText(string4);
        }
        if (0 == this.showDialog(frame, string3 == null ? "OK" : string3)) {
            this.directory = this.getSelectedFile().getAbsolutePath();
        }
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.aprove_requested = true;
            super.setSelectedFile(this.getCurrentDirectory());
        } else {
            super.setSelectedFile(file);
        }
    }

    public void cancelSelection() {
        if (this.aprove_requested) {
            this.approveSelection();
        } else {
            super.cancelSelection();
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean accept(File file) {
        return file.isDirectory();
    }
}

