/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.courier;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.courier.ImageDataSource;
import photoorganizer.courier.TextDataSource;
import photoorganizer.courier.ThumbnailImageDataSource;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;

public class MailCourier
implements Courier {
    Multipart multipart;
    Multipart alternative;
    Controller controller;
    int counter;

    public MailCourier(Controller controller, Multipart multipart, Multipart multipart2) {
        this.controller = controller;
        this.multipart = multipart;
        this.alternative = multipart2;
    }

    public void deliver(StringBuffer stringBuffer, String string, String string2, String string3) throws IOException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)new TextDataSource(stringBuffer, string2, string3)));
            this.alternative.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (MessagingException messagingException) {
            throw new IOException("" + (Object)((Object)messagingException));
        }
    }

    public void deliver(String string, String string2) throws IOException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)new ImageDataSource(string)));
            mimeBodyPart.addHeader("Content-ID", "<" + string + '>');
            this.multipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (MessagingException messagingException) {
            throw new IOException("" + (Object)((Object)messagingException));
        }
    }

    public String deliver(AbstractFormat abstractFormat, String string) throws IOException {
        try {
            AbstractInfo abstractInfo = abstractFormat.getInfo();
            if (abstractInfo == null) {
                return "";
            }
            ThumbnailImageDataSource thumbnailImageDataSource = new ThumbnailImageDataSource("media" + this.counter++, abstractFormat.getThumbnailType());
            if (abstractInfo instanceof AbstractImageInfo) {
                ((AbstractImageInfo)abstractInfo).saveThumbnailImage((BasicJpeg)abstractFormat, thumbnailImageDataSource.getOutputStream());
            } else {
                thumbnailImageDataSource.getOutputStream().write(abstractFormat.getThumbnailData(null));
            }
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)thumbnailImageDataSource));
            mimeBodyPart.addHeader("Content-ID", "<" + thumbnailImageDataSource.getName() + '>');
            this.multipart.addBodyPart((BodyPart)mimeBodyPart);
            return "cid:" + thumbnailImageDataSource.getName();
        }
        catch (MessagingException messagingException) {
            throw new IOException("" + (Object)((Object)messagingException));
        }
    }

    public void checkForDestPath(String string) throws IOException {
    }

    public void init() throws IOException {
    }

    public void done() {
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isContentIncluded() {
        return true;
    }
}

