/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.album;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.renderer.MiscellaneousOptionsTab;
import rogatkin.Serializer;

public class Access {
    static final String PICTURES_DATABASE = "Pictures";
    static final String[][] PICTURES_DATABASE_STRUCTURE = new String[][]{{"PicId", " INTEGER NOT NULL,"}, {"Name", " CHAR(255) NOT NULL,"}, {"LocId", " INTEGER,"}, {"ChkSum", " FLOAT,"}, {"Size", "   INTEGER,"}, {"Created", " TIMESTAMP,"}, {"Shutter", " FLOAT,"}, {"Aperture", " FLOAT,"}, {"Flash", " CHAR,"}, {"Zoom", " FLOAT,"}, {"Quality", " CHAR(10),"}, {"Make", " CHAR(30),"}, {"Model", " CHAR(30),"}, {"Resolution", " CHAR(10),"}, {"Commentary", " CHAR(255)"}};
    static final int PICTURES_PICID = 0;
    static final int PICTURES_NAME = 1;
    static final int PICTURES_LOCID = 2;
    static final int PICTURES_CHKSUM = 3;
    static final int PICTURES_SIZE = 4;
    static final int PICTURES_CREATED = 5;
    static final int PICTURES_SHUTTER = 6;
    static final int PICTURES_APERTURE = 7;
    static final int PICTURES_FLASH = 8;
    static final int PICTURES_ZOOM = 9;
    static final int PICTURES_QUALITY = 10;
    static final int PICTURES_MAKE = 11;
    static final int PICTURES_MODEL = 12;
    static final int PICTURES_RESOLUTION = 13;
    static final int PICTURES_COMMENTARY = 14;
    static final String DIR_ENC = "ISO-8859-1";
    public static final String CONNECTION_DATABASE = "Connection";
    public static final String[][] CONNECTION_DATABASE_STRUCTURE = new String[][]{{"PicId", " INTEGER NOT NULL,"}, {"AlbumId", " INTEGER,"}, {"SeqNumber", " INTEGER,"}, {"Target", " CHAR(10)"}};
    public static final int CONNECTION_PICID = 0;
    public static final int CONNECTION_ALBUMID = 1;
    public static final int CONNECTION_SEQNUMBER = 2;
    public static final int CONNECTION_TARGET = 3;
    static final String ALBUM_DATABASE = "Album";
    static final String[][] ALBUM_DATABASE_STRUCTURE = new String[][]{{"AlbumId", " INTEGER NOT NULL,"}, {"Name", "    CHAR(255)"}};
    static final int ALBUM_ALBUMID = 0;
    static final int ALBUM_NAME = 1;
    static final String GROUPS_DATABASE = "Groups";
    static final String[][] GROUPS_DATABASE_STRUCTURE = new String[][]{{"GroupId", " INTEGER NOT NULL,"}, {"AlbumId", " INTEGER NOT NULL"}};
    static final int GROUPS_GROUPID = 0;
    static final int GROUPS_ALBUMID = 1;
    static final String LOCATIONS_DATABASE = "Locations";
    static final String[][] LOCATIONS_DATABASE_STRUCTURE = new String[][]{{"LocId", " INTEGER NOT NULL,"}, {"Disk", " CHAR(255)"}};
    static final int LOCATIONS_LOCID = 0;
    static final int LOCATIONS_DISK = 1;
    static final String[] TABLES = new String[]{"Pictures", "Connection", "Album", "Groups", "Locations"};
    static final String[][][] DESCRIPTIONS = new String[][][]{PICTURES_DATABASE_STRUCTURE, CONNECTION_DATABASE_STRUCTURE, ALBUM_DATABASE_STRUCTURE, GROUPS_DATABASE_STRUCTURE, LOCATIONS_DATABASE_STRUCTURE};
    public static final String SQL_INSERT = "INSERT INTO ";
    public static final String SQL_SELECT = "SELECT ";
    public static final String SQL_FROM = " FROM ";
    public static final String SQL_WHERE = " WHERE ";
    public static final String SQL_DELETE = "DELETE ";
    public static final String SQL_UPDATE = "UPDATE ";
    public static final String SQL_SET = " SET ";
    public static final String SQL_AND = " AND ";
    public static final String SQL_ORDERBY = " ORDER BY ";
    public static final String SQL_ASC = " ASC";
    public static final String SQL_DESC = " DESC";
    static DecimalFormat APERTURE_FMT = new DecimalFormat("#0.#");
    static DecimalFormat SHUTTER_FMT = new DecimalFormat("#0.####");
    static DecimalFormat FOCAL_FMT = new DecimalFormat("##0.#");
    boolean[] table_present;
    private Controller controller;
    private Driver jdbc_driver;
    private Connection connection;

    public Access(Controller controller) {
        this.controller = controller;
        this.table_present = new boolean[this.getTables().length];
        this.init();
    }

    protected String[] getTables() {
        return TABLES;
    }

    protected String[][][] getDescriptions() {
        return DESCRIPTIONS;
    }

    public void init() {
        Object object;
        this.forgetTables();
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty((Object)"AlbumOptions", (Object)"DatabaseURL");
        Driver driver = null;
        String string2 = "";
        try {
            driver = DriverManager.getDriver(string);
        }
        catch (SQLException sQLException) {
            string2 = sQLException.toString();
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        if (driver == null) {
            try {
                object = (String)serializer.getProperty((Object)"AlbumOptions", (Object)"JDBCDriver");
                driver = (Driver)Class.forName((String)object).newInstance();
            }
            catch (Exception exception) {
                string2 = exception.toString();
            }
        }
        if (driver == null) {
            if (Serializer.getInt((Object)this.controller.getSerializer().getProperty((Object)"AlbumOptions", (Object)"IgnoreDatabaseErrors"), (int)0) == 0) {
                JOptionPane.showMessageDialog(this.controller.getMainFrame(), "JDBC driver can't be instantiated, 'cause\n" + string2, "Error", 0);
            }
            return;
        }
        this.closeAllConnections();
        try {
            this.connection = DriverManager.getConnection(string, (String)serializer.getProperty((Object)"AlbumOptions", (Object)"User"), (String)serializer.getProperty((Object)"AlbumOptions", (Object)"Password"));
            Access.checkForWarning(this.connection.getWarnings());
            object = this.connection.getMetaData();
            System.err.println("Connected to " + object.getURL());
            System.err.println("Driver       " + object.getDriverName());
            System.err.println("Version      " + object.getDriverVersion());
            System.err.println("===DRIVER CAPABILITIES===");
            System.err.println("-" + (object.supportsPositionedUpdate() ? " " : " doesn't ") + "support positioned update");
            System.err.println("-" + (object.supportsPositionedDelete() ? " " : " doesn't ") + "support positioned delete");
            System.err.println("-" + (object.supportsANSI92EntryLevelSQL() ? " " : " doesn't ") + "support ANSI92 entry level");
            System.err.println("-" + (object.supportsANSI92FullSQL() ? " " : " doesn't ") + "support full ANSI92");
        }
        catch (SQLException sQLException) {
            if (Serializer.getInt((Object)this.controller.getSerializer().getProperty((Object)"AlbumOptions", (Object)"IgnoreDatabaseErrors"), (int)0) == 0) {
                JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Couldn't establish database connection, check URL\n" + sQLException, "Error", 0);
            }
            Access.printChainedSqlException(sQLException);
            return;
        }
        this.getMetaInfo();
        this.createTables();
    }

    public void forgetTables() {
        int n = 0;
        while (n < this.table_present.length) {
            this.table_present[n] = false;
            ++n;
        }
    }

    void getMetaInfo() {
        try {
            DatabaseMetaData databaseMetaData = this.getAvailableConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, stringArray);
            String[] stringArray2 = this.getTables();
            while (resultSet.next()) {
                String string = resultSet.getString(3);
                int n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals(string)) {
                        this.table_present[n] = true;
                    }
                    ++n;
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    public void createTables() {
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            String[] stringArray = this.getTables();
            String[][][] stringArray2 = this.getDescriptions();
            int n = 0;
            while (n < stringArray.length) {
                if (!this.table_present[n]) {
                    StringBuffer stringBuffer = null;
                    System.err.println("Creation of " + stringArray[n]);
                    try {
                        try {
                            statement.executeUpdate("DROP TABLE " + stringArray[n]);
                        }
                        catch (Exception exception) {
                            System.err.println("DROP Sql: DROP TABLE " + stringArray[n] + ";" + exception);
                        }
                        stringBuffer = new StringBuffer("CREATE TABLE ");
                        stringBuffer.append(stringArray[n]);
                        stringBuffer.append(" (");
                        int n2 = 0;
                        while (n2 < stringArray2[n].length) {
                            stringBuffer.append(stringArray2[n][n2][0]);
                            stringBuffer.append(stringArray2[n][n2][1]);
                            ++n2;
                        }
                        stringBuffer.append(")");
                        statement.executeUpdate(stringBuffer.toString());
                    }
                    catch (SQLException sQLException) {
                        Access.printChainedSqlException(sQLException);
                        System.err.println("Sql: " + stringBuffer.toString());
                    }
                }
                ++n;
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    int generateUniqueId(String string, String string2) {
        int n = 1;
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            statement.setMaxRows(1);
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT " + string2 + SQL_FROM + string + SQL_WHERE + string2 + " < 2147483647 ORDER BY 1 DESC");
            if (resultSet.next()) {
                n = resultSet.getInt(string2) + 1;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
        return n;
    }

    public synchronized int createAlbum(String string) {
        int n;
        String string2 = "INSERT INTO Album (" + ALBUM_DATABASE_STRUCTURE[0][0] + "," + ALBUM_DATABASE_STRUCTURE[1][0] + ") VALUES (?,?)";
        try {
            n = this.generateUniqueId(ALBUM_DATABASE, ALBUM_DATABASE_STRUCTURE[0][0]);
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            n = -1;
        }
        return n;
    }

    public int getAlbumId(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n = this.findAlbumIn(n, string2);
        }
        return n;
    }

    public int getAlbumId(TreePath treePath) {
        if (treePath == null || treePath.getPathCount() == 0) {
            return -1;
        }
        int n = 0;
        Object[] objectArray = treePath.getPath();
        int n2 = 1;
        while (n2 < objectArray.length) {
            n = this.findAlbumIn(n, objectArray[n2].toString());
            ++n2;
        }
        return n;
    }

    public int findAlbumIn(int n, String string) {
        String string2 = "SELECT Album." + ALBUM_DATABASE_STRUCTURE[0][0] + SQL_FROM + ALBUM_DATABASE + ',' + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE + '.' + GROUPS_DATABASE_STRUCTURE[1][0] + '=' + ALBUM_DATABASE + '.' + ALBUM_DATABASE_STRUCTURE[0][0] + SQL_AND + GROUPS_DATABASE + '.' + GROUPS_DATABASE_STRUCTURE[0][0] + "=? AND " + ALBUM_DATABASE + '.' + ALBUM_DATABASE_STRUCTURE[1][0] + "=?";
        int n2 = -1;
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int[] getAlbumPath(int n) {
        String string = SQL_SELECT + GROUPS_DATABASE_STRUCTURE[0][0] + SQL_FROM + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE_STRUCTURE[1][0] + '=';
        int[] nArray = new int[]{};
        int n2 = n;
        do {
            SQLException sQLException2222;
            Object var9_9;
            ResultSet resultSet;
            Statement statement;
            block19: {
                statement = null;
                resultSet = null;
                statement = this.getAvailableConnection().createStatement();
                resultSet = statement.executeQuery(string + n2);
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    if (n2 > 0) {
                        int[] nArray2 = new int[nArray.length + 1];
                        nArray2[0] = n2;
                        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
                        nArray = nArray2;
                    }
                } else {
                    n2 = -1;
                }
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                var9_9 = null;
                if (resultSet == null) break block19;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    // empty catch block
                }
            }
            if (statement == null) continue;
            try {
                statement.close();
            }
            catch (SQLException sQLException2222) {}
            continue;
            {
                catch (SQLException sQLException3) {
                    Access.printChainedSqlException(sQLException3);
                    n2 = -1;
                    var9_9 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2222) {
                            // empty catch block
                        }
                    }
                    if (statement == null) continue;
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException2222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException2222) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        } while (n2 > 0);
        return nArray;
    }

    boolean isInheritedFrom(int n, int[] nArray) {
        int[] nArray2 = this.getAlbumsId(n);
        if (nArray2.length == 0) {
            return false;
        }
        if (this.createIntersection(nArray2, nArray).length > 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (this.isInheritedFrom(nArray2[n2], nArray)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int[] createIntersection(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[]{};
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray2.length) {
                if (nArray[n] == nArray2[n2]) {
                    int[] nArray4 = new int[nArray3.length + 1];
                    System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
                    nArray4[nArray3.length] = nArray[n];
                    nArray3 = nArray4;
                }
                ++n2;
            }
            ++n;
        }
        return nArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int insertAlbumToAlbum(int[] var1_1, int var2_2) {
        block28: {
            block23: {
                block24: {
                    var3_3 = "SELECT " + Access.ALBUM_DATABASE_STRUCTURE[0][0] + " FROM " + "Album" + " WHERE " + Access.ALBUM_DATABASE_STRUCTURE[0][0] + '=';
                    var4_4 = "INSERT INTO Groups (" + Access.GROUPS_DATABASE_STRUCTURE[0][0] + ',' + Access.GROUPS_DATABASE_STRUCTURE[1][0] + ") VALUES (";
                    if (this.isInheritedFrom(var2_2, var1_1)) {
                        return -1;
                    }
                    var5_5 = null;
                    var6_6 = null;
                    try {
                        try {
                            var5_5 = this.getAvailableConnection().createStatement();
                            var6_6 = var5_5.executeQuery(var3_3 + var2_2);
                            var7_7 = var6_6.next();
                            var6_6.close();
                            var6_6 = null;
                            var5_5.close();
                            var5_5 = null;
                            if (var7_7 != 0) break block23;
                            var8_9 = -1;
                            var10_12 = null;
                            if (var6_6 == null) break block24;
                        }
                        catch (SQLException var7_8) {
                            Access.printChainedSqlException(var7_8);
                            var8_10 = -1;
                            var10_14 = null;
                            if (var6_6 != null) {
                                try {
                                    var6_6.close();
                                }
                                catch (SQLException var11_18) {
                                    // empty catch block
                                }
                            }
                            if (var5_5 == null) return var8_10;
                            try {
                                var5_5.close();
                                return var8_10;
                            }
                            catch (SQLException var11_18) {
                                // empty catch block
                            }
                            return var8_10;
                        }
                    }
                    catch (Throwable var9_20) {
                        block27: {
                            var10_15 = null;
                            if (var6_6 != null) {
                                ** try [egrp 2[TRYBLOCK] [5 : 238->248)] { 
lbl46:
                                // 1 sources

                                var6_6.close();
                                break block27;
lbl48:
                                // 1 sources

                                catch (SQLException var11_19) {
                                    // empty catch block
                                }
                            }
                        }
                        if (var5_5 == null) throw var9_20;
                        ** try [egrp 3[TRYBLOCK] [6 : 255->265)] { 
lbl53:
                        // 1 sources

                        var5_5.close();
                        throw var9_20;
lbl55:
                        // 1 sources

                        catch (SQLException var11_19) {
                            // empty catch block
                        }
                        throw var9_20;
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 238->248)] { 
lbl60:
                    // 1 sources

                    var6_6.close();
                    break block24;
lbl62:
                    // 1 sources

                    catch (SQLException var11_16) {
                        // empty catch block
                    }
                }
                if (var5_5 == null) return var8_9;
                ** try [egrp 3[TRYBLOCK] [6 : 255->265)] { 
lbl67:
                // 1 sources

                var5_5.close();
                return var8_9;
lbl69:
                // 1 sources

                catch (SQLException var11_16) {
                    // empty catch block
                }
                return var8_9;
            }
            var10_13 = null;
            if (var6_6 != null) {
                ** try [egrp 2[TRYBLOCK] [5 : 238->248)] { 
lbl76:
                // 1 sources

                var6_6.close();
                break block28;
lbl78:
                // 1 sources

                catch (SQLException var11_17) {
                    // empty catch block
                }
            }
        }
        if (var5_5 != null) {
            try {}
            catch (SQLException var11_17) {}
            var5_5.close();
        }
        var7_7 = 0;
        while (true) {
            if (var7_7 >= var1_1.length) {
                return var2_2;
            }
            try {
                var5_5 = this.getAvailableConnection().createStatement();
                var5_5.executeUpdate(var4_4 + String.valueOf(var1_1[var7_7]) + "," + String.valueOf(var2_2) + ')');
                var5_5.close();
            }
            catch (SQLException var8_11) {
                Access.printChainedSqlException(var8_11);
            }
            ++var7_7;
        }
    }

    public boolean belongsToAlbum(AbstractFormat abstractFormat) {
        String string = SQL_SELECT + PICTURES_DATABASE_STRUCTURE[1][0] + SQL_FROM + PICTURES_DATABASE + SQL_WHERE + PICTURES_DATABASE_STRUCTURE[1][0] + '=';
        if (abstractFormat == null) {
            return false;
        }
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + Access.SQLQuote(abstractFormat.getFile().getPath()));
            boolean bl = resultSet.next();
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return false;
        }
    }

    public synchronized void insertPicturesToAlbum(int n, AbstractFormat[] abstractFormatArray) {
        Statement statement;
        PreparedStatement preparedStatement;
        String string = "INSERT INTO Locations (" + LOCATIONS_DATABASE_STRUCTURE[0][0] + ',' + LOCATIONS_DATABASE_STRUCTURE[1][0] + ") VALUES (";
        String string2 = "INSERT INTO Connection (" + CONNECTION_DATABASE_STRUCTURE[0][0] + ',' + CONNECTION_DATABASE_STRUCTURE[1][0] + ") VALUES (";
        StringBuffer stringBuffer = new StringBuffer(PICTURES_DATABASE_STRUCTURE[0][0]);
        StringBuffer stringBuffer2 = new StringBuffer(" VALUES (?");
        int n2 = 1;
        while (n2 < PICTURES_DATABASE_STRUCTURE.length) {
            stringBuffer.append(',').append(PICTURES_DATABASE_STRUCTURE[n2][0]);
            stringBuffer2.append(",?");
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer2.append(')');
        try {
            preparedStatement = this.getAvailableConnection().prepareStatement("INSERT INTO Pictures (" + stringBuffer.toString() + stringBuffer2.toString());
            statement = this.getAvailableConnection().createStatement();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            return;
        }
        int n3 = 0;
        while (n3 < abstractFormatArray.length) {
            try {
                AbstractImageInfo abstractImageInfo;
                int n4 = this.generateUniqueId(PICTURES_DATABASE, PICTURES_DATABASE_STRUCTURE[0][0]);
                if (n4 != -1 && (abstractImageInfo = ((BasicJpeg)abstractFormatArray[n3]).getImageInfo()) != null) {
                    preparedStatement.setInt(1, n4);
                    int n5 = 2;
                    while (n5 <= PICTURES_DATABASE_STRUCTURE.length) {
                        switch (n5 - 1) {
                            case 1: {
                                preparedStatement.setString(n5, abstractFormatArray[n3].getFile().getPath());
                                break;
                            }
                            case 2: {
                                preparedStatement.setInt(n5, 0);
                                break;
                            }
                            case 3: {
                                preparedStatement.setInt(n5, 0);
                                break;
                            }
                            case 4: {
                                preparedStatement.setInt(n5, (int)abstractFormatArray[n3].getFile().length());
                                break;
                            }
                            case 5: {
                                preparedStatement.setTimestamp(n5, new Timestamp(abstractImageInfo.getDateTimeOriginal().getTime()));
                                break;
                            }
                            case 6: {
                                preparedStatement.setString(n5, SHUTTER_FMT.format(abstractImageInfo.getShutter().floatValue()));
                                break;
                            }
                            case 7: {
                                preparedStatement.setString(n5, APERTURE_FMT.format(abstractImageInfo.getFNumber()));
                                break;
                            }
                            case 8: {
                                preparedStatement.setString(n5, abstractImageInfo.isFlash() ? "Y" : "N");
                                break;
                            }
                            case 9: {
                                preparedStatement.setString(n5, FOCAL_FMT.format(abstractImageInfo.getFocalLength()));
                                break;
                            }
                            case 10: {
                                preparedStatement.setString(n5, abstractImageInfo.getQuality());
                                break;
                            }
                            case 11: {
                                preparedStatement.setString(n5, abstractImageInfo.getMake());
                                break;
                            }
                            case 12: {
                                preparedStatement.setString(n5, abstractImageInfo.getModel());
                                break;
                            }
                            case 13: {
                                preparedStatement.setString(n5, abstractImageInfo.getResolutionX() + "x" + abstractImageInfo.getResolutionY());
                                break;
                            }
                            case 14: {
                                preparedStatement.setString(n5, "");
                                break;
                            }
                            default: {
                                preparedStatement.setObject(n5, null);
                            }
                        }
                        ++n5;
                    }
                    preparedStatement.executeUpdate();
                    statement.executeUpdate(string2 + n4 + ',' + n + ')');
                }
            }
            catch (SQLException sQLException) {
                Access.printChainedSqlException(sQLException);
            }
            ++n3;
        }
        try {
            preparedStatement.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    public File[] getAlbumContents(int n) {
        String string = SQL_SELECT + CONNECTION_DATABASE_STRUCTURE[0][0] + SQL_FROM + CONNECTION_DATABASE + SQL_WHERE + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string2 = SQL_SELECT + PICTURES_DATABASE_STRUCTURE[1][0] + SQL_FROM + PICTURES_DATABASE + SQL_WHERE + PICTURES_DATABASE_STRUCTURE[0][0] + '=';
        File[] fileArray = new File[]{};
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            Statement statement2 = this.getAvailableConnection().createStatement();
            while (resultSet.next()) {
                try {
                    ResultSet resultSet2 = statement2.executeQuery(string2 + resultSet.getInt(1));
                    if (resultSet2.next()) {
                        File[] fileArray2 = new File[fileArray.length + 1];
                        System.arraycopy(fileArray, 0, fileArray2, 0, fileArray.length);
                        fileArray2[fileArray.length] = new File(resultSet2.getString(1).trim());
                        fileArray = fileArray2;
                    }
                    resultSet2.close();
                }
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                }
            }
            statement2.close();
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getNameOfAlbum(int n) {
        String string;
        block15: {
            ResultSet resultSet;
            Statement statement;
            String string2;
            block12: {
                string2 = SQL_SELECT + ALBUM_DATABASE_STRUCTURE[1][0] + SQL_FROM + ALBUM_DATABASE + SQL_WHERE + ALBUM_DATABASE_STRUCTURE[0][0] + "=";
                string = "Not found";
                statement = null;
                resultSet = null;
                statement = this.getAvailableConnection().createStatement();
                resultSet = statement.executeQuery(string2 + n);
                if (!resultSet.next()) break block12;
                string = resultSet.getString(1).trim();
            }
            Object var8_6 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For query " + string2 + n);
                    Object var8_7 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string;
    }

    public int getAlbumsCount(int n) {
        String string = "SELECT COUNT(*) FROM Groups WHERE " + GROUPS_DATABASE_STRUCTURE[0][0] + '=';
        int n2 = 0;
        try {
            Statement statement = this.getAvailableConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string + n);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int[] getAlbumsId(int n) {
        int[] nArray;
        block15: {
            String string = SQL_SELECT + GROUPS_DATABASE_STRUCTURE[1][0] + SQL_FROM + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE_STRUCTURE[0][0] + "=";
            nArray = new int[]{};
            Statement statement = null;
            ResultSet resultSet = null;
            statement = this.getAvailableConnection().createStatement();
            resultSet = statement.executeQuery(string + n);
            while (resultSet.next()) {
                int[] nArray2 = nArray;
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray2.length] = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            Object var8_8 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    Object var8_9 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean renameAlbumTo(int n, String string) {
        block9: {
            String string2 = "UPDATE Album SET " + ALBUM_DATABASE_STRUCTURE[1][0] + "=?" + SQL_WHERE + ALBUM_DATABASE_STRUCTURE[0][0] + '=';
            Statement statement = null;
            statement = this.getAvailableConnection().prepareStatement(string2 + n);
            statement.setString(1, string);
            statement.executeUpdate();
            Object var8_5 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block9;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For query: " + string2 + n);
                    boolean bl = false;
                    Object var8_6 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void deleteAlbumFrom(int[] var1_1, int var2_2) {
        block36: {
            block34: {
                block32: {
                    var3_3 = "DELETE  FROM Groups WHERE " + Access.GROUPS_DATABASE_STRUCTURE[0][0] + "=?" + " AND " + Access.GROUPS_DATABASE_STRUCTURE[1][0] + "=?";
                    var4_4 = "SELECT " + Access.GROUPS_DATABASE_STRUCTURE[1][0] + " FROM " + "Groups" + " WHERE " + Access.GROUPS_DATABASE_STRUCTURE[1][0] + '=';
                    var5_5 = null;
                    try {
                        var5_5 = this.getAvailableConnection().prepareStatement(var3_3);
                        var6_6 = 0;
                        while (var6_6 < var1_1.length) {
                            try {
                                var5_5.setInt(1, var1_1[var6_6]);
                                var5_5.setInt(2, var2_2);
                                var5_5.executeUpdate();
                            }
                            catch (SQLException var7_8) {
                                Access.printChainedSqlException(var7_8);
                                System.err.println("For query " + var3_3 + " p1=" + var1_1[var6_6] + " p2=" + var2_2);
                            }
                            ++var6_6;
                        }
                        var5_5.close();
                        var9_10 = null;
                        ** if (var5_5 == null) goto lbl-1000
                    }
                    catch (Throwable var8_17) {
                        var9_12 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (SQLException var10_16) {
                                // empty catch block
                            }
                        }
                        throw var8_17;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var5_5.close();
                        }
                        catch (SQLException var10_14) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block32;
                        catch (SQLException var6_7) {
                            Access.printChainedSqlException(var6_7);
                            System.err.println("Couldn't prepare statement " + var3_3);
                            var9_11 = null;
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (SQLException var10_15) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                }
                var6_6 = 0;
                var7_9 = null;
                var8_18 = null;
                var7_9 = this.getAvailableConnection().createStatement();
                var8_18 = var7_9.executeQuery(var4_4 + var2_2);
                var6_6 = (int)var8_18.next();
                var12_19 = null;
                if (var8_18 == null) break block34;
                try {
                    var8_18.close();
                }
                catch (SQLException var13_22) {
                    // empty catch block
                }
            }
            if (var7_9 != null) {
                try {
                    var7_9.close();
                }
                catch (SQLException var13_22) {}
            }
            break block36;
            {
                catch (SQLException var9_13) {
                    Access.printChainedSqlException(var9_13);
                    System.err.println("For query " + var4_4 + var2_2);
                    var12_20 = null;
                    if (var8_18 != null) {
                        try {
                            var8_18.close();
                        }
                        catch (SQLException var13_23) {
                            // empty catch block
                        }
                    }
                    if (var7_9 != null) {
                        try {
                            var7_9.close();
                        }
                        catch (SQLException var13_23) {}
                    }
                }
            }
            catch (Throwable var11_25) {
                var12_21 = null;
                if (var8_18 != null) {
                    try {
                        var8_18.close();
                    }
                    catch (SQLException var13_24) {
                        // empty catch block
                    }
                }
                if (var7_9 != null) {
                    try {
                        var7_9.close();
                    }
                    catch (SQLException var13_24) {
                        // empty catch block
                    }
                }
                throw var11_25;
            }
        }
        if (var6_6 == 0) {
            this.deleteAlbum(var2_2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void deleteAlbum(int n) {
        Statement statement;
        String string;
        String string2;
        String string3;
        String string4;
        block47: {
            SQLException sQLException5;
            ResultSet resultSet;
            String string5;
            block44: {
                block46: {
                    SQLException sQLException22;
                    Object var12_10;
                    String string6;
                    block42: {
                        string6 = SQL_SELECT + GROUPS_DATABASE_STRUCTURE[1][0] + SQL_FROM + GROUPS_DATABASE + SQL_WHERE + GROUPS_DATABASE_STRUCTURE[0][0] + '=';
                        string5 = SQL_SELECT + CONNECTION_DATABASE_STRUCTURE[0][0] + SQL_FROM + CONNECTION_DATABASE + SQL_WHERE + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                        string4 = "DELETE  FROM Groups WHERE " + GROUPS_DATABASE_STRUCTURE[0][0] + '=';
                        string3 = " OR " + GROUPS_DATABASE_STRUCTURE[1][0] + '=';
                        string2 = "DELETE  FROM Album WHERE " + ALBUM_DATABASE_STRUCTURE[0][0] + '=';
                        string = "DELETE  FROM Connection WHERE " + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                        statement = null;
                        resultSet = null;
                        statement = this.getAvailableConnection().createStatement();
                        resultSet = statement.executeQuery(string6 + n);
                        while (resultSet.next()) {
                            this.deleteAlbum(resultSet.getInt(1));
                        }
                        var12_10 = null;
                        if (resultSet == null) break block42;
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException22) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException22) {}
                    }
                    break block46;
                    {
                        catch (SQLException sQLException3) {
                            Access.printChainedSqlException(sQLException3);
                            System.err.println("For query " + string6 + n);
                            var12_10 = null;
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (SQLException sQLException22) {
                                    // empty catch block
                                }
                            }
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (SQLException sQLException22) {}
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException sQLException42;
                        Object var12_11 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException42) {
                                // empty catch block
                            }
                        }
                        if (statement == null) throw throwable;
                        try {
                            statement.close();
                            throw throwable;
                        }
                        catch (SQLException sQLException42) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                statement = null;
                resultSet = null;
                statement = this.getAvailableConnection().createStatement();
                resultSet = statement.executeQuery(string5 + n);
                while (resultSet.next()) {
                    this.deletePicture(resultSet.getInt(1));
                }
                Object var15_19 = null;
                if (resultSet == null) break block44;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException5) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException5) {}
            }
            break block47;
            {
                catch (SQLException sQLException6) {
                    SQLException sQLException72;
                    Access.printChainedSqlException(sQLException6);
                    System.err.println("For query " + string5 + n);
                    Object var15_20 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException72) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException72) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException82;
                Object var15_21 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException82) {
                        // empty catch block
                    }
                }
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException sQLException82) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        statement = null;
        statement = this.getAvailableConnection().createStatement();
        statement.executeUpdate(string4 + n + string3 + n);
        statement.executeUpdate(string2 + n);
        statement.executeUpdate(string + n);
        statement.close();
        Object var18_26 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException sQLException) {}
        return;
        {
            catch (SQLException sQLException) {
                Access.printChainedSqlException(sQLException);
                System.err.println("For queries " + string4 + n + string3 + n + '\n' + string2 + n + '\n' + string + n);
                Object var18_27 = null;
                if (statement == null) return;
                try {
                    statement.close();
                    return;
                }
                catch (SQLException sQLException9) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void deletePicture(int n, String string) {
        block21: {
            Statement statement;
            ResultSet resultSet;
            Statement statement2;
            String string2;
            String string3;
            String string4;
            String string5;
            block16: {
                string5 = "SELECT Connection." + CONNECTION_DATABASE_STRUCTURE[0][0] + SQL_FROM + CONNECTION_DATABASE + ',' + PICTURES_DATABASE + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + SQL_AND + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                string4 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=";
                string3 = "DELETE  FROM Connection WHERE " + CONNECTION_DATABASE_STRUCTURE[0][0] + '=';
                string2 = SQL_AND + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                statement2 = null;
                resultSet = null;
                statement = null;
                statement2 = this.getAvailableConnection().createStatement();
                resultSet = statement2.executeQuery(string5 + n + string4 + Access.SQLQuote(string));
                if (!resultSet.next()) break block16;
                statement = this.getAvailableConnection().createStatement();
                statement2.executeUpdate(string3 + resultSet.getInt(1) + string2 + n);
                statement.close();
                statement = null;
            }
            Object var12_10 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement2.close();
            }
            catch (Exception exception) {}
            break block21;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For queries " + string5 + n + string4 + string + "'\n" + string3 + '?' + string2 + n);
                    sQLException.printStackTrace();
                    Object var12_11 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void deletePicture(int n) {
        block8: {
            String string = "DELETE  FROM Pictures WHERE " + PICTURES_DATABASE_STRUCTURE[0][0] + '=';
            Statement statement = null;
            statement = this.getAvailableConnection().createStatement();
            statement.executeUpdate(string + n);
            Object var6_4 = null;
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block8;
            {
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For queries " + string + n);
                    Object var6_5 = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    boolean useEncoding() {
        return Serializer.getInt((Object)this.controller.getSerializer().getProperty((Object)"AlbumOptions", (Object)"UseEncoding"), (int)0) == 1;
    }

    public synchronized void setPictureComment(int n, String string) {
        String string2 = "UPDATE Pictures SET " + PICTURES_DATABASE_STRUCTURE[14][0] + "=? " + SQL_WHERE + PICTURES_DATABASE_STRUCTURE[0][0] + '=';
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string2 + n);
            preparedStatement.setString(1, this.convertUsingEnc(string, true));
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string2 + n);
        }
    }

    public synchronized void setPictureComment(int n, String string, String string2) {
        String string3 = "UPDATE Connection,Pictures SET " + PICTURES_DATABASE_STRUCTURE[14][0] + "=? " + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + SQL_AND + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string4 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=?";
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string3 + n + string4);
            preparedStatement.setString(1, this.convertUsingEnc(string2, true));
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string3 + n + string4 + string + '\'');
        }
    }

    String convertUsingEnc(String string, boolean bl) {
        if (this.useEncoding()) {
            String string2 = MiscellaneousOptionsTab.getEncoding(this.controller);
            String string3 = null;
            if (bl) {
                try {
                    string3 = new String(string.getBytes(string2), DIR_ENC);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                try {
                    string3 = new String(string.getBytes(DIR_ENC), string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return string3 != null ? string3 : string;
        }
        return string;
    }

    public synchronized void renamePictureTo(int n, String string, String string2) {
        String string3 = "UPDATE Connection,Pictures SET " + PICTURES_DATABASE_STRUCTURE[1][0] + "=? " + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + SQL_AND + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
        String string4 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=";
        try {
            PreparedStatement preparedStatement = this.getAvailableConnection().prepareStatement(string3 + n + string4 + Access.SQLQuote(string));
            preparedStatement.setString(1, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
            System.err.println("For query: " + string3 + n + string4 + string + "'(?)" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized String getPictureComment(int n, String string) {
        String string2;
        block19: {
            ResultSet resultSet;
            Statement statement;
            String string3;
            String string4;
            block16: {
                string4 = "SELECT Pictures." + PICTURES_DATABASE_STRUCTURE[14][0] + SQL_FROM + CONNECTION_DATABASE + ',' + PICTURES_DATABASE + SQL_WHERE + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[0][0] + '=' + PICTURES_DATABASE + '.' + PICTURES_DATABASE_STRUCTURE[0][0] + SQL_AND + CONNECTION_DATABASE + '.' + CONNECTION_DATABASE_STRUCTURE[1][0] + '=';
                string3 = " AND Pictures." + PICTURES_DATABASE_STRUCTURE[1][0] + "=";
                string2 = null;
                if (n < 0) {
                    return string2;
                }
                statement = null;
                resultSet = null;
                statement = this.getAvailableConnection().createStatement();
                resultSet = statement.executeQuery(string4 + n + string3 + Access.SQLQuote(string));
                if (!resultSet.next() || (string2 = resultSet.getString(1)) == null) break block16;
                string2 = string2.trim();
            }
            Object var11_8 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
            break block19;
            {
                catch (NullPointerException nullPointerException) {
                    Object var11_9 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                    break block19;
                }
                catch (SQLException sQLException) {
                    Access.printChainedSqlException(sQLException);
                    System.err.println("For queries " + string4 + n + string3 + string + '\'');
                    sQLException.printStackTrace();
                    Object var11_10 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return this.convertUsingEnc(string2, false);
    }

    public Connection getAvailableConnection() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("No suitable JDBC driver, or JDBC settings set not properly");
        }
        return this.connection;
    }

    public void closeAllConnections() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sQLException) {
            Access.printChainedSqlException(sQLException);
        }
    }

    protected void finalize() throws Throwable {
        this.closeAllConnections();
        super.finalize();
    }

    public static String SQLQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        char[] cArray = string.toCharArray();
        stringBuffer.append('\'');
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\'') {
                stringBuffer.append(cArray, n2, n - n2 + 1).append(cArray[n]);
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < n) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static void printChainedSqlException(SQLException sQLException) {
        System.err.println("*** SQLException caught ***");
        while (sQLException != null) {
            System.err.println("state:      " + sQLException.getSQLState());
            System.err.println("message:    " + sQLException.getMessage());
            System.err.println("error code: " + sQLException.getErrorCode());
            sQLException.printStackTrace();
            sQLException = sQLException.getNextException();
            if (sQLException == null) continue;
            System.err.println("ooooo>>>");
        }
        System.err.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
    }

    private static boolean checkForWarning(SQLWarning sQLWarning) throws SQLException {
        if (sQLWarning != null) {
            System.err.println("*** SQLWarning ***");
            while (sQLWarning != null) {
                System.err.println("state:      " + sQLWarning.getSQLState());
                System.err.println("message:    " + sQLWarning.getMessage());
                System.err.println("error code: " + sQLWarning.getErrorCode());
                sQLWarning = sQLWarning.getNextWarning();
                if (sQLWarning == null) continue;
                System.err.println("ooooo>>>");
            }
            System.err.println("********===********");
            return true;
        }
        return false;
    }
}

