/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.Address;
import addressbook.Chat;
import addressbook.Contact;
import addressbook.EMail;
import addressbook.Folder;
import addressbook.Link;
import addressbook.Name;
import addressbook.PGP;
import addressbook.Telephone;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import rogatkin.HttpUtils;

public class DataBookIO {
    public static final String DATABOOK_TAG = "DATABOOK";
    public static final String FOLDER_TAG = "FOLDER";
    public static final String PERSON_TAG = "PERSON";
    public static final String COOKIE_TAG = "COOKIE";
    public static final String BOOKMARK_TAG = "BOOKMARK";
    public static final String NAME_TAG = "NAME";
    public static final String TITLE_TAG = "TITLE";
    public static final String DOB_TAG = "DOB";
    public static final String PHONE_TAG = "PHONE";
    public static final String ADDRESS_TAG = "ADDRESS";
    public static final String EMAIL_TAG = "EMAIL";
    public static final String LINK_TAG = "LINK";
    public static final String CHAT_TAG = "CHAT";
    public static final String PGP_TAG = "PGP";
    public static final String COMMENT_TAG = "COMMENT";
    public static final String LAST_TAG = "LAST";
    public static final String MAIDEN_TAG = "MAIDEN";
    public static final String FIRST_TAG = "FIRST";
    public static final String MIDDLE_TAG = "MIDDLE";
    public static final String MAJOR_TAG = "MAJOR";
    public static final String SALUT_TAG = "SALUT";
    public static final String NICK_TAG = "NICK";
    public static final String STREET_TAG = "STREET";
    public static final String CITY_TAG = "CITY";
    public static final String STATE_TAG = "STATE";
    public static final String COUNTRY_TAG = "COUNTRY";
    public static final String ZIP_TAG = "ZIP";
    public static final String TYPE_ATTR = "TYPE";
    public static final String ROOM_ATTR = "ROOM";
    public static final String YEAR_ATTR = "YEAR";
    public static final String MONTH_ATTR = "MONTH";
    public static final String DAY_ATTR = "DAY";
    public static final String SERVER_ATTR = "SERVER";
    public static final String SUB_TYPE_ATTR = "SUB_TYPE";
    public static final String FORMAT_ATTR = "FORMAT";
    public static final String COMMENT_ATTR = "COMMENT";
    public static final String ORDER_ATTR = "ORDER";
    public static final String OWNER_ATTR = "OWNER";
    public static final String CREATED_ATTR = "CREATED";
    public static final String MODIFIED_ATTR = "MODIFIED";
    public static final String ENCRYPTED_ATTR = "ENCRYPTED";
    public static final String SHARING_ATTR = "SHARING";
    public static final String PGPKEY_ATTR = "PGPKEY";
    public static final String PROTOCOL_ATTR = "PROTOCOL";
    public static final String GENDER_ATTR = "GENDER";
    public static final String NAME_ATTR = "NAME";
    public static final String DTD_HOME = "addressbook.DTD";
    public static final String DTD_NAME = "databook.dtd";
    public static final SimpleDateFormat DATE_XML_FMT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    Properties properties;

    DataBookIO(Properties properties) {
        this.properties = properties;
    }

    public Vector read(InputStream inputStream) {
        Vector vector = new Vector();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            sAXParserFactory.newSAXParser().parse(inputStream, (HandlerBase)new DataBookHandler(vector));
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            if (exception instanceof SAXParseException) {
                System.err.println("** Parsing exception, line:col " + ((SAXParseException)exception).getLineNumber() + ':' + ((SAXParseException)exception).getColumnNumber() + ", " + ((SAXParseException)exception).getSystemId());
            }
            if (exception instanceof SAXException && ((SAXException)exception).getException() != null) {
                ((SAXException)exception).getException().printStackTrace();
            }
            exception.printStackTrace();
        }
        return vector;
    }

    public void write(Vector vector, OutputStream outputStream, String string) {
        try {
            outputStream.write(("<?xml version=\"1.0\" encoding=\"" + string + "\"?>").getBytes(string));
            String string2 = this.properties.getProperty(DTD_HOME);
            if (string2 != null) {
                outputStream.write("<!DOCTYPE DATABOOK SYSTEM \"".getBytes(string));
                outputStream.write(string2.getBytes(string));
                outputStream.write("/".getBytes(string));
                outputStream.write(DTD_NAME.getBytes(string));
                outputStream.write("\">".getBytes(string));
            }
            outputStream.write("<DATABOOK MODIFIED=\"".getBytes(string));
            outputStream.write(DATE_XML_FMT.format(new Date()).getBytes(string));
            outputStream.write("\">".getBytes(string));
            int n = 0;
            while (n < vector.size()) {
                Folder folder = (Folder)vector.elementAt(n);
                outputStream.write("<FOLDER NAME=\"".getBytes(string));
                outputStream.write(HttpUtils.htmlEncode((String)folder.toString()).getBytes(string));
                outputStream.write("\">".getBytes(string));
                folder.saveXML(outputStream, string, n);
                outputStream.write("</FOLDER>".getBytes(string));
                ++n;
            }
            outputStream.write("</DATABOOK>".getBytes(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Exception: " + unsupportedEncodingException);
        }
        catch (IOException iOException) {
            System.err.println("Exception: " + iOException);
        }
    }

    static {
        DATE_XML_FMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    class DataBookHandler
    extends HandlerBase {
        Vector folders;
        Folder folder;
        Contact contact;
        String last;
        String first;
        String middle;
        String salut;
        String maiden;
        String major;
        String nick;
        String comment;
        String street;
        String title;
        String city;
        String state;
        String country;
        String zip;
        String[] attributes;
        StringBuffer buffer;

        DataBookHandler(Vector vector) {
            this.folders = vector;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.buffer = new StringBuffer(100);
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if (DataBookIO.PERSON_TAG.equals(string)) {
                this.contact = new Contact();
            } else if (DataBookIO.PHONE_TAG.equals(string)) {
                this.comment = HttpUtils.htmlDecode((String)attributeList.getValue("COMMENT"));
                this.buffer.setLength(0);
            } else if (DataBookIO.LAST_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.ADDRESS_TAG.equals(string)) {
                this.comment = HttpUtils.htmlDecode((String)attributeList.getValue("COMMENT"));
            } else if (DataBookIO.FOLDER_TAG.equals(string)) {
                this.folder = new Folder(HttpUtils.htmlDecode((String)attributeList.getValue("NAME")), 0);
            } else if (DataBookIO.FIRST_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.MIDDLE_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.MAJOR_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.SALUT_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.EMAIL_TAG.equals(string)) {
                this.comment = HttpUtils.htmlDecode((String)attributeList.getValue("COMMENT"));
                this.buffer.setLength(0);
            } else if (DataBookIO.LINK_TAG.equals(string)) {
                this.comment = HttpUtils.htmlDecode((String)attributeList.getValue("COMMENT"));
                this.buffer.setLength(0);
            } else if (DataBookIO.CHAT_TAG.equals(string)) {
                this.comment = HttpUtils.htmlDecode((String)attributeList.getValue("COMMENT"));
                this.attributes = new String[]{HttpUtils.htmlDecode((String)attributeList.getValue(DataBookIO.SERVER_ATTR)), HttpUtils.htmlDecode((String)attributeList.getValue(DataBookIO.PROTOCOL_ATTR)), HttpUtils.htmlDecode((String)attributeList.getValue(DataBookIO.ROOM_ATTR))};
                this.buffer.setLength(0);
            } else if (DataBookIO.PGP_TAG.equals(string)) {
                this.comment = HttpUtils.htmlDecode((String)attributeList.getValue("COMMENT"));
                this.buffer.setLength(0);
            } else if ("COMMENT".equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.DOB_TAG.equals(string)) {
                Calendar calendar = Calendar.getInstance();
                try {
                    calendar.set(Integer.parseInt(attributeList.getValue(DataBookIO.YEAR_ATTR)), Integer.parseInt(attributeList.getValue(DataBookIO.MONTH_ATTR)) - 1, Integer.parseInt(attributeList.getValue(DataBookIO.DAY_ATTR)));
                    this.contact.setDOB(calendar.getTime());
                }
                catch (Exception exception) {}
            } else if (DataBookIO.NICK_TAG.equals(string)) {
                try {
                    int n = Integer.parseInt(attributeList.getValue(DataBookIO.ORDER_ATTR));
                    if (n > 0) {
                        this.buffer.append(' ');
                    }
                    return;
                }
                catch (Exception exception) {
                    this.buffer.setLength(0);
                }
            } else if (DataBookIO.MAIDEN_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.TITLE_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.STREET_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.CITY_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.STATE_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.COUNTRY_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.ZIP_TAG.equals(string)) {
                this.buffer.setLength(0);
            } else if (DataBookIO.BOOKMARK_TAG.equals(string) || DataBookIO.DATABOOK_TAG.equals(string)) {
                // empty if block
            }
        }

        public void endElement(String string) throws SAXException {
            if (DataBookIO.PERSON_TAG.equals(string)) {
                this.folder.setType(1);
                if (this.folder.getType() == 1) {
                    this.folder.add(this.contact);
                }
            } else if ("NAME".equals(string)) {
                this.contact.setValue(new Name(this.last, this.first, this.middle, this.salut, this.maiden, this.major, this.nick));
            } else if (DataBookIO.FOLDER_TAG.equals(string)) {
                this.folders.addElement(this.folder);
            } else if (DataBookIO.PHONE_TAG.equals(string)) {
                this.contact.add(new Telephone(this.buffer.toString(), this.comment));
            } else if (DataBookIO.ADDRESS_TAG.equals(string)) {
                this.contact.add(new Address(this.street, this.city, this.state, this.country, this.zip, this.comment, this.title));
            } else if (DataBookIO.LAST_TAG.equals(string)) {
                this.last = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.FIRST_TAG.equals(string)) {
                this.first = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.MIDDLE_TAG.equals(string)) {
                this.middle = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.MAJOR_TAG.equals(string)) {
                this.major = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.SALUT_TAG.equals(string)) {
                this.salut = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.NICK_TAG.equals(string)) {
                this.nick = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.MAIDEN_TAG.equals(string)) {
                this.maiden = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.TITLE_TAG.equals(string)) {
                this.title = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.STREET_TAG.equals(string)) {
                this.street = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.CITY_TAG.equals(string)) {
                this.city = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.STATE_TAG.equals(string)) {
                this.state = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.COUNTRY_TAG.equals(string)) {
                this.country = HttpUtils.htmlDecode((String)this.buffer.toString());
            } else if (DataBookIO.ZIP_TAG.equals(string)) {
                this.zip = this.buffer.toString();
            } else if (DataBookIO.EMAIL_TAG.equals(string)) {
                this.contact.add(new EMail(HttpUtils.htmlDecode((String)this.buffer.toString()), this.comment));
            } else if (DataBookIO.LINK_TAG.equals(string)) {
                this.contact.add(new Link(HttpUtils.htmlDecode((String)this.buffer.toString()), this.comment));
            } else if (DataBookIO.CHAT_TAG.equals(string)) {
                int n = 0;
                if ("IRC".equals(this.attributes[1])) {
                    n = 1;
                } else if ("ICQ".equals(this.attributes[1])) {
                    n = 2;
                }
                this.contact.add(new Chat(HttpUtils.htmlDecode((String)this.buffer.toString()), this.attributes[0], n, this.comment, this.attributes[2]));
            } else if (DataBookIO.PGP_TAG.equals(string)) {
                this.contact.add(new PGP(this.buffer.toString(), this.comment));
            } else if ("COMMENT".equals(string)) {
                this.contact.add(HttpUtils.htmlDecode((String)this.buffer.toString()));
            } else if (DataBookIO.DATABOOK_TAG.equals(string)) {
                // empty if block
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }
    }
}

