/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.GenericAttribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import rogatkin.HttpUtils;

public class Chat
extends GenericAttribute {
    public static final int IRC_CHAT = 1;
    public static final int ICQ_CHAT = 2;
    public static final int MAX_CHAT_TYPE = 2;
    public static final String[] MNEMO = new String[]{"IRC", "ICQ"};
    protected String host;
    protected String room;
    protected int type;

    public Chat(String string, String string2, int n, String string3, String string4) {
        super(string, string3);
        this.host = this.assignWithDefault(string2);
        this.room = this.assignWithDefault(string4);
        this.type = n;
        if (this.type < 1 || this.type > 2) {
            this.type = 1;
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getRoom() {
        return this.room;
    }

    public int getType() {
        return this.type;
    }

    public void saveXML(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        outputStream.write(("<CHAT ORDER=\"" + n + "\" COMMENT=\"").getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.description).getBytes(string));
        outputStream.write("\" ROOM=\"".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.room).getBytes(string));
        outputStream.write("\" SERVER=\"".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.host).getBytes(string));
        outputStream.write("\" PROTOCOL=\"".getBytes(string));
        outputStream.write(MNEMO[this.type - 1].getBytes(string));
        outputStream.write("\">".getBytes(string));
        outputStream.write(HttpUtils.htmlEncode((String)this.value).getBytes(string));
        outputStream.write("</CHAT>".getBytes(string));
    }
}

