/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2ExtendedHeader;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.ID3v2Header;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.ID3v2NoSuchFrameException;
import de.vdheide.mp3.ID3v2WrongCRCException;
import de.vdheide.mp3.NoID3v2HeaderException;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;

public class ID3v2
implements Serializable {
    static final int COPY_BUFFER_SIZE = 65536;
    public static final byte VERSION = 3;
    public static final byte REVISION = 0;
    private File file = null;
    private ID3v2Header header;
    private ID3v2ExtendedHeader extended_header;
    private Vector frames;
    private boolean is_changed = false;
    private boolean use_padding = true;
    private boolean use_crc = true;
    private boolean use_unsynchronization = true;
    private String encoding;

    public ID3v2(InputStream inputStream, String string) throws IOException, ID3v2IllegalVersionException, ID3v2WrongCRCException, ID3v2DecompressionException {
        if (string != null) {
            this.encoding = string;
        }
        try {
            this.readHeader(inputStream);
        }
        catch (NoID3v2HeaderException noID3v2HeaderException) {
            inputStream.close();
            this.header = null;
            this.extended_header = null;
            this.frames = null;
            return;
        }
        if (this.header.hasExtendedHeader()) {
            this.readExtendedHeader(inputStream);
        } else {
            this.extended_header = null;
        }
        this.readFrames(inputStream);
        inputStream.close();
        this.is_changed = false;
    }

    public ID3v2(File file, String string) throws IOException, ID3v2IllegalVersionException, ID3v2WrongCRCException, ID3v2DecompressionException {
        this(new FileInputStream(file), string);
        this.file = file;
    }

    public ID3v2(File file) throws IOException, ID3v2IllegalVersionException, ID3v2WrongCRCException, ID3v2DecompressionException {
        this(file, null);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static byte[] synchronize(byte[] byArray) {
        boolean bl = false;
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == -1) {
                if (byArray[n2 + 1] == 0) {
                    bl = true;
                    byArray2[n++] = -1;
                    ++n2;
                } else {
                    byArray2[n++] = -1;
                }
            } else {
                byArray2[n++] = byArray[n2];
            }
            ++n2;
        }
        if (n != byArray.length) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            byArray2 = byArray3;
        }
        if (bl) {
            return byArray2;
        }
        return null;
    }

    public static byte[] unsynchronize(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == -1) {
                if ((byArray[n2 + 1] & 0xFF) >= 224 || byArray[n2 + 1] == 0) {
                    byte[] byArray3 = new byte[byArray2.length + 1];
                    System.arraycopy(byArray2, 0, byArray3, 0, n);
                    byArray2 = byArray3;
                    byArray3 = null;
                    byArray2[n++] = -1;
                    byArray2[n++] = 0;
                    byArray2[n++] = byArray[n2 + 1];
                    ++n2;
                    bl = true;
                } else {
                    byArray2[n++] = byArray[n2];
                }
            } else {
                byArray2[n++] = byArray[n2];
            }
            ++n2;
        }
        if (bl) {
            return byArray2;
        }
        return null;
    }

    public void setUsePadding(boolean bl) {
        if (this.use_padding != bl) {
            this.is_changed = true;
            this.use_padding = bl;
        }
    }

    public boolean getUsePadding() {
        return this.use_padding;
    }

    public void setUseCRC(boolean bl) {
        if (this.use_crc != bl) {
            this.is_changed = true;
            this.use_crc = bl;
        }
    }

    public boolean getUseCRC() {
        return this.use_crc;
    }

    public void setUseUnsynchronization(boolean bl) {
        if (this.use_unsynchronization != bl) {
            this.is_changed = true;
            this.use_unsynchronization = bl;
        }
    }

    public boolean getUseUnsynchronization() {
        return this.use_unsynchronization;
    }

    public boolean hasTag() {
        return this.header != null;
    }

    public Vector getFrames() throws NoID3v2TagException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        return this.frames;
    }

    public Vector getFrame(String string) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        Vector<ID3v2Frame> vector = new Vector<ID3v2Frame>();
        Enumeration enumeration = this.frames.elements();
        while (enumeration.hasMoreElements()) {
            ID3v2Frame iD3v2Frame = (ID3v2Frame)enumeration.nextElement();
            if (!iD3v2Frame.getID().equals(string)) continue;
            vector.addElement(iD3v2Frame);
        }
        if (vector.size() == 0) {
            throw new ID3v2NoSuchFrameException();
        }
        return vector;
    }

    public void addFrame(ID3v2Frame iD3v2Frame) {
        if (this.frames == null) {
            this.frames = new Vector();
        }
        this.frames.addElement(iD3v2Frame);
        this.is_changed = true;
    }

    public void removeFrame(ID3v2Frame iD3v2Frame) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        if (!this.frames.removeElement(iD3v2Frame)) {
            throw new ID3v2NoSuchFrameException();
        }
        this.is_changed = true;
    }

    public void removeFrame(String string) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        boolean bl = false;
        Enumeration enumeration = this.frames.elements();
        while (enumeration.hasMoreElements()) {
            ID3v2Frame iD3v2Frame = (ID3v2Frame)enumeration.nextElement();
            if (!iD3v2Frame.getID().equals(string)) continue;
            this.frames.removeElement(iD3v2Frame);
            bl = true;
        }
        if (!bl) {
            throw new ID3v2NoSuchFrameException();
        }
        this.is_changed = true;
    }

    public void removeFrame(String string, int n) throws NoID3v2TagException, ID3v2NoSuchFrameException {
        if (this.frames == null) {
            throw new NoID3v2TagException();
        }
        int n2 = 0;
        boolean bl = false;
        Enumeration enumeration = this.frames.elements();
        while (enumeration.hasMoreElements()) {
            ID3v2Frame iD3v2Frame = (ID3v2Frame)enumeration.nextElement();
            if (!iD3v2Frame.getID().equals(string)) continue;
            if (n2 == n) {
                this.frames.removeElement(iD3v2Frame);
                bl = true;
                continue;
            }
            ++n2;
        }
        if (!bl) {
            throw new ID3v2NoSuchFrameException();
        }
        this.is_changed = true;
    }

    public void removeFrames() {
        if (this.frames != null) {
            this.frames = new Vector();
        }
    }

    public void update() throws IOException {
        if (this.is_changed) {
            Object object;
            Object object2;
            boolean bl = false;
            byte[] byArray = this.convertFramesToArrayOfBytes();
            int n = 0;
            if (this.use_crc) {
                object2 = new CRC32();
                object2.update(byArray);
                n = (int)((CRC32)object2).getValue();
            }
            object2 = new ID3v2ExtendedHeader(this.use_crc, n, 0);
            byte[] byArray2 = ((ID3v2ExtendedHeader)object2).getBytes();
            if (this.use_unsynchronization) {
                byte[] byArray3 = ID3v2.unsynchronize(byArray2);
                if (byArray3 != null) {
                    bl = true;
                    byArray2 = byArray3;
                }
                if ((object = ID3v2.unsynchronize(byArray)) != null) {
                    bl = true;
                    byArray = object;
                }
            }
            int n2 = byArray2.length + byArray.length;
            object = new ID3v2Header(3, 0, bl, true, false, n2);
            byte[] byArray4 = ((ID3v2Header)object).getBytes();
            int n3 = this.header == null ? 0 : this.header.getTagSize();
            File file = this.file;
            if (this.header == null || this.header != null && n2 > n3 || !this.use_padding && n2 != n3) {
                int n4;
                file = File.createTempFile("ID3", ".TMP", this.file.getParentFile());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(byArray4);
                bufferedOutputStream.write(byArray2);
                bufferedOutputStream.write(byArray);
                if (this.use_padding) {
                    long l = this.file.length() - (long)n3;
                    long l2 = l + (long)n2;
                    long l3 = (long)(Math.ceil(l2 / 2048L) * 2048.0) - l2;
                    int n5 = 0;
                    while ((long)n5 < l3) {
                        bufferedOutputStream.write(0);
                        ++n5;
                    }
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
                if (this.header != null) {
                    bufferedInputStream.skip(n3 - 1);
                }
                byte[] byArray5 = new byte[65536];
                while ((n4 = bufferedInputStream.read(byArray5)) > 0) {
                    bufferedOutputStream.write(byArray5, 0, n4);
                }
                bufferedInputStream.close();
                bufferedOutputStream.close();
                if (!file.renameTo(this.file)) {
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file), 65536);
                    BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream(this.file), 65536);
                    while ((n4 = bufferedInputStream2.read(byArray5)) > 0) {
                        bufferedOutputStream2.write(byArray5, 0, n4);
                    }
                    bufferedInputStream2.close();
                    bufferedOutputStream2.close();
                    file.delete();
                }
            } else {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.write(byArray4);
                randomAccessFile.write(byArray2);
                randomAccessFile.write(byArray);
                if (this.use_padding) {
                    int n6 = n3 - n2;
                    int n7 = 0;
                    while (n7 < n6) {
                        randomAccessFile.write(0);
                        ++n7;
                    }
                }
                randomAccessFile.close();
            }
            this.header = object;
            this.extended_header = object2;
            this.is_changed = false;
        }
    }

    private void readHeader(InputStream inputStream) throws NoID3v2HeaderException, ID3v2IllegalVersionException, IOException {
        this.header = new ID3v2Header(inputStream);
    }

    private void readExtendedHeader(InputStream inputStream) throws IOException {
        this.extended_header = new ID3v2ExtendedHeader(inputStream);
    }

    private void readFrames(InputStream inputStream) throws IOException, ID3v2WrongCRCException, ID3v2DecompressionException {
        Object object;
        byte[] byArray;
        int n = this.extended_header != null ? this.header.getTagSize() - (this.extended_header.getSize() + 4) - this.extended_header.getPaddingSize() : this.header.getTagSize();
        byte[] byArray2 = new byte[n];
        inputStream.read(byArray2);
        if (this.header.getUnsynchronization()) {
            byArray = ID3v2.synchronize(byArray2);
            if (byArray == null) {
                byArray = byArray2;
            }
        } else {
            byArray = byArray2;
        }
        if (this.extended_header != null && this.extended_header.hasCRC()) {
            object = new CRC32();
            object.update(byArray);
            int n2 = (int)((CRC32)object).getValue();
            if (n2 != (int)this.extended_header.getCRC()) {
                // empty if block
            }
        }
        this.frames = new Vector();
        object = new ByteArrayInputStream(byArray);
        ID3v2Frame iD3v2Frame = null;
        boolean bl = true;
        while (((ByteArrayInputStream)object).available() > 0 && bl) {
            iD3v2Frame = new ID3v2Frame((InputStream)object);
            if (iD3v2Frame.getID() == ID3v2Frame.ID_INVALID) {
                bl = false;
                continue;
            }
            this.frames.addElement(iD3v2Frame);
        }
    }

    private byte[] convertFramesToArrayOfBytes() {
        ID3v2Frame iD3v2Frame = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
        Enumeration enumeration = this.frames.elements();
        while (enumeration.hasMoreElements()) {
            iD3v2Frame = (ID3v2Frame)enumeration.nextElement();
            byte[] byArray = iD3v2Frame.getBytes();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

