/*
 * Decompiled with CFR 0.152.
 */
package rogatkin.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Properties;
import rogatkin.CachedReader;
import rogatkin.HttpUtils;

public class Substitutor {
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String TEMPLATE_ROOT = "TEMPLATEROOT";
    public static final String WRAPPER_NAME = "WRAPPERNAME";
    private static final String CLASS_ID = "Substitutor";
    private static final byte[] INCLUDE_DELIM = new byte[]{35, 35, 73, 78, 67, 76, 85, 68, 69};
    private static CachedReader cachedReader = new CachedReader(5, 3);
    static final int IN_TEXT = 0;
    static final int AT_AT = 1;
    static final int IN_VAR = 2;
    static final int IN_ARG = 3;
    static final int AT_END_ARG = 4;

    public static String substitute(String string, HashMap hashMap, Properties properties) {
        return Substitutor.substitute(string, hashMap, false, properties);
    }

    public static String substitute(String string, HashMap hashMap, boolean bl, Properties properties) {
        return Substitutor.substitute(string, hashMap, bl, null, properties, null);
    }

    public static String substitute(String string, HashMap hashMap, boolean bl, Properties properties, String string2) {
        return Substitutor.substitute(string, hashMap, bl, null, properties, string2);
    }

    public static String substitute(String string, HashMap hashMap, boolean bl, String string2, Properties properties, String string3) {
        byte[] byArray;
        String string4 = properties.getProperty(TEMPLATE_ROOT, "");
        if (!string4.endsWith("/") && !string4.endsWith("\\")) {
            string4 = string4 + '/';
        }
        if ((byArray = cachedReader.getContent(string4 + (string2 != null ? string2 + '/' : "") + string)) == null) {
            return "<!-- Can't open template " + string4 + string + ". -->";
        }
        if (bl) {
            byArray = Substitutor.wrapUp(byArray, string4 + properties.getProperty(WRAPPER_NAME));
        }
        String string5 = ISO_8859_1;
        if ((byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
            string5 = "UTF-8";
        } else if ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
            string5 = "UTF-16";
        }
        if ((byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
            string5 = "UNICODE";
        }
        char[] cArray = null;
        try {
            if (hashMap == null) {
                return new String(byArray, string5);
            }
            cArray = new String(byArray, string5).toCharArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "<!-- " + string5 + " is not supported, encoding exception. -->";
        }
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 100);
        stringBuffer.append(Substitutor.substitute(cArray, 0, cArray.length, hashMap, properties, string3));
        return stringBuffer.toString();
    }

    static String substitute(char[] cArray, int n, int n2, HashMap hashMap, Properties properties, String string) {
        StringBuffer stringBuffer;
        block36: {
            int n3;
            if (n >= cArray.length) {
                return "";
            }
            stringBuffer = new StringBuffer(n2 + 50);
            int n4 = n3 = n;
            int n5 = 0;
            int n6 = -1;
            String string2 = null;
            do {
                switch (n5) {
                    case 0: {
                        if (cArray[n3] == '@') {
                            n5 = 1;
                        }
                        ++n3;
                        break;
                    }
                    case 1: {
                        n5 = cArray[n3] == '@' ? 0 : 2;
                        stringBuffer.append(cArray, n4, n3 - n4 - 1);
                        n4 = n3;
                        n3 = n4 + 1;
                        break;
                    }
                    case 2: {
                        Object object;
                        if (cArray[n3] == '@') {
                            n5 = 0;
                            string2 = new String(cArray, n4, n3 - n4);
                            object = hashMap.get(string2);
                            if (object == null) {
                                object = properties.getProperty(string2, "");
                            }
                            stringBuffer.append(string2.charAt(0) == '.' ? object.toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(object.toString(), string)) : HttpUtils.htmlEncode(object.toString())));
                            n3 = n4 = n3 + 1;
                            break;
                        }
                        if (cArray[n3] == '(') {
                            string2 = new String(cArray, n4, n3 - n4);
                            n5 = 3;
                            n3 = n4 = n3 + 1;
                            n6 = 1;
                            break;
                        }
                        ++n3;
                        break;
                    }
                    case 3: {
                        if (cArray[n3] == ')') {
                            if (--n6 == 0) {
                                n5 = 4;
                            }
                        } else if (cArray[n3] == '(') {
                            ++n6;
                        }
                        ++n3;
                        break;
                    }
                    case 4: {
                        Object object;
                        if (cArray[n3] == '@') {
                            object = hashMap.get(string2);
                            if (object != null) {
                                int n7;
                                Object object2;
                                if (object instanceof Object[]) {
                                    object2 = (Object[])object;
                                    n7 = 0;
                                    while (n7 < ((Object[])object2).length) {
                                        if (object2[n7] != null) {
                                            if (object2[n7] instanceof HashMap) {
                                                stringBuffer.append(Substitutor.substitute(cArray, n4, n3 - n4 - 1, (HashMap)object2[n7], properties, string));
                                            } else {
                                                stringBuffer.append(cArray, n4, n3 - n4 - 1).append(string2.charAt(0) == '.' ? object2[n7].toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(object2[n7].toString(), string)) : HttpUtils.htmlEncode(object2[n7].toString())));
                                            }
                                        }
                                        ++n7;
                                    }
                                } else if (object instanceof AbstractList) {
                                    object2 = (AbstractList)object;
                                    n7 = 0;
                                    while (n7 < ((AbstractCollection)object2).size()) {
                                        Object e = ((AbstractList)object2).get(n7);
                                        if (e != null) {
                                            if (e instanceof HashMap) {
                                                stringBuffer.append(Substitutor.substitute(cArray, n4, n3 - n4 - 1, (HashMap)e, properties, string));
                                            } else {
                                                stringBuffer.append(cArray, n4, n3 - n4 - 1).append(string2.charAt(0) == '.' ? e.toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(e.toString(), string)) : HttpUtils.htmlEncode(e.toString())));
                                            }
                                        }
                                        ++n7;
                                    }
                                } else if (object instanceof HashMap) {
                                    stringBuffer.append(Substitutor.substitute(cArray, n4, n3 - n4 - 1, (HashMap)object, properties, string));
                                } else if (object instanceof char[]) {
                                    object2 = (char[])object;
                                    n7 = 0;
                                    while (n7 < ((Object)object2).length) {
                                        stringBuffer.append(cArray, n4, n3 - n4 - 1).append(string2.charAt(0) == '.' ? String.valueOf((char)object2[n7]) : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString("" + (char)object2[n7], string)) : HttpUtils.htmlEncode("" + (char)object2[n7])));
                                        ++n7;
                                    }
                                } else {
                                    stringBuffer.append(cArray, n4, n3 - n4 - 1).append(string2.charAt(0) == '.' ? object.toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(object.toString(), string)) : HttpUtils.htmlEncode(object.toString())));
                                }
                            }
                            n3 = n4 = n3 + 1;
                            n5 = 0;
                            break;
                        }
                        n5 = 2;
                        ++n3;
                    }
                }
            } while (n3 < n + n2 && n3 < cArray.length);
            if (n3 <= n4 - 1) break block36;
            stringBuffer.append(cArray, n4, n3 - n4);
        }
        return stringBuffer.toString();
    }

    public static void substitute(Writer writer, String string, HashMap hashMap, boolean bl, Properties properties) throws IOException {
        Substitutor.substitute(writer, string, hashMap, bl, null, properties, null);
    }

    public static void substitute(Writer writer, String string, HashMap hashMap, boolean bl, Properties properties, String string2) throws IOException {
        Substitutor.substitute(writer, string, hashMap, bl, null, properties, string2);
    }

    public static void substitute(Writer writer, String string, HashMap hashMap, boolean bl, String string2, Properties properties, String string3) throws IOException {
        byte[] byArray;
        String string4 = properties.getProperty(TEMPLATE_ROOT, "");
        if (!string4.endsWith("/") && !string4.endsWith("\\")) {
            string4 = string4 + '/';
        }
        if ((byArray = cachedReader.getContent(string4 + (string2 != null ? string2 + '/' : "") + string)) == null) {
            throw new IOException("Can't open template " + string4 + string + '.');
        }
        if (bl) {
            byArray = Substitutor.wrapUp(byArray, string4 + properties.getProperty(WRAPPER_NAME));
        }
        String string5 = ISO_8859_1;
        if ((byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
            string5 = "UTF-8";
        } else if ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
            string5 = "UTF-16";
        }
        if ((byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
            string5 = "UNICODE";
        }
        char[] cArray = null;
        try {
            if (hashMap == null) {
                writer.write(new String(byArray, string5));
                return;
            }
            cArray = new String(byArray, string5).toCharArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(string5 + " is not supported, encoding exception.");
        }
        Substitutor.substitute(writer, cArray, 0, cArray.length, hashMap, properties, string3);
    }

    static void substitute(Writer writer, char[] cArray, int n, int n2, HashMap hashMap, Properties properties, String string) throws IOException {
        block36: {
            int n3;
            if (n >= cArray.length) {
                throw new IOException("An attempt to proceess after end of the buffer. (" + n + " >= " + cArray.length + ')');
            }
            int n4 = n3 = n;
            int n5 = 0;
            int n6 = -1;
            String string2 = null;
            do {
                switch (n5) {
                    case 0: {
                        if (cArray[n3] == '@') {
                            n5 = 1;
                        }
                        ++n3;
                        break;
                    }
                    case 1: {
                        n5 = cArray[n3] == '@' ? 0 : 2;
                        writer.write(cArray, n4, n3 - n4 - 1);
                        n4 = n3;
                        n3 = n4 + 1;
                        break;
                    }
                    case 2: {
                        Object object;
                        if (cArray[n3] == '@') {
                            n5 = 0;
                            string2 = new String(cArray, n4, n3 - n4);
                            object = hashMap.get(string2);
                            if (object == null) {
                                object = properties.getProperty(string2, "");
                            }
                            writer.write(string2.charAt(0) == '.' ? object.toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(object.toString(), string)) : HttpUtils.htmlEncode(object.toString())));
                            n3 = n4 = n3 + 1;
                            break;
                        }
                        if (cArray[n3] == '(') {
                            string2 = new String(cArray, n4, n3 - n4);
                            n5 = 3;
                            n3 = n4 = n3 + 1;
                            n6 = 1;
                            break;
                        }
                        ++n3;
                        break;
                    }
                    case 3: {
                        if (cArray[n3] == ')') {
                            if (--n6 == 0) {
                                n5 = 4;
                            }
                        } else if (cArray[n3] == '(') {
                            ++n6;
                        }
                        ++n3;
                        break;
                    }
                    case 4: {
                        Object object;
                        if (cArray[n3] == '@') {
                            object = hashMap.get(string2);
                            if (object != null) {
                                int n7;
                                Object object2;
                                if (object instanceof Object[]) {
                                    object2 = (Object[])object;
                                    n7 = 0;
                                    while (n7 < ((Object[])object2).length) {
                                        if (object2[n7] != null) {
                                            if (object2[n7] instanceof HashMap) {
                                                Substitutor.substitute(writer, cArray, n4, n3 - n4 - 1, (HashMap)object2[n7], properties, string);
                                            } else {
                                                writer.write(cArray, n4, n3 - n4 - 1);
                                                writer.write(string2.charAt(0) == '.' ? object2[n7].toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(object2[n7].toString(), string)) : HttpUtils.htmlEncode(object2[n7].toString())));
                                            }
                                        }
                                        ++n7;
                                    }
                                } else if (object instanceof HashMap) {
                                    Substitutor.substitute(writer, cArray, n4, n3 - n4 - 1, (HashMap)object, properties, string);
                                } else if (object instanceof AbstractList) {
                                    object2 = (AbstractList)object;
                                    n7 = 0;
                                    while (n7 < ((AbstractCollection)object2).size()) {
                                        Object e = ((AbstractList)object2).get(n7);
                                        if (e != null) {
                                            if (e instanceof HashMap) {
                                                Substitutor.substitute(writer, cArray, n4, n3 - n4 - 1, (HashMap)e, properties, string);
                                            } else {
                                                writer.write(cArray, n4, n3 - n4 - 1);
                                                writer.write(string2.charAt(0) == '.' ? e.toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(e.toString(), string)) : HttpUtils.htmlEncode(e.toString())));
                                            }
                                        }
                                        ++n7;
                                    }
                                } else if (object instanceof char[]) {
                                    object2 = (char[])object;
                                    n7 = 0;
                                    while (n7 < ((Object)object2).length) {
                                        writer.write(cArray, n4, n3 - n4 - 1);
                                        writer.write(string2.charAt(0) == '.' ? String.valueOf((char)object2[n7]) : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString("" + (char)object2[n7], string)) : HttpUtils.htmlEncode("" + (char)object2[n7])));
                                        ++n7;
                                    }
                                } else {
                                    writer.write(cArray, n4, n3 - n4 - 1);
                                    writer.write(string2.charAt(0) == '.' ? object.toString() : (string2.charAt(0) == ':' ? HttpUtils.urlEncode(Substitutor.encodeInString(object.toString(), string)) : HttpUtils.htmlEncode(object.toString())));
                                }
                            }
                            n3 = n4 = n3 + 1;
                            n5 = 0;
                            break;
                        }
                        n5 = 2;
                        ++n3;
                    }
                }
            } while (n3 < n + n2 && n3 < cArray.length);
            if (n3 <= n4 - 1) break block36;
            writer.write(cArray, n4, n3 - n4);
        }
    }

    static byte[] wrapUp(byte[] byArray, String string) {
        byte[] byArray2 = cachedReader.getContent(string);
        if (byArray2 == null) {
            return byArray;
        }
        int n = Substitutor.searchForPattern(byArray2, INCLUDE_DELIM);
        byte[] byArray3 = new byte[byArray2.length + byArray.length - INCLUDE_DELIM.length];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        System.arraycopy(byArray, 0, byArray3, n, byArray.length);
        System.arraycopy(byArray2, n + INCLUDE_DELIM.length, byArray3, byArray.length + n, byArray2.length - n - INCLUDE_DELIM.length);
        return byArray3;
    }

    public static int searchForPattern(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        byte[] byArray3 = new byte[255];
        int n3 = 0;
        while (n3 < 255) {
            byArray3[n3] = (byte)n;
            ++n3;
        }
        n3 = 0;
        while (n3 < n - 1) {
            byArray3[byArray2[n3] - -128] = (byte)(n - n3 - 1);
            ++n3;
        }
        n3 = n - 1;
        while (n3 < byArray.length) {
            int n4 = n - 1;
            n2 = n3;
            while (n4 >= 0 && byArray[n2] == byArray2[n4]) {
                --n2;
                --n4;
            }
            if (n4 == -1) {
                return ++n2;
            }
            n3 += byArray3[byArray[n3] - -128];
        }
        return 0;
    }

    public static String decodeInString(String string, String string2) {
        if (string2 != null) {
            try {
                string = new String(string.getBytes(ISO_8859_1), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String encodeInString(String string, String string2) {
        if (string2 != null) {
            try {
                return new String(string.getBytes(string2), ISO_8859_1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }
}

