/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import tools.BaseApplet;
import tools.Problem;
import tools.Retriever;
import tools.RetrieverListener;
import tools.TreeComponent;

public class Tree
implements Runnable,
RetrieverListener {
    public static String TextBegMark;
    public static String TextEndMark;
    static final String TreeFilePathName = "/tree.gz";
    public static final int MaxComplexity = 4;
    public static final int MaxReplication = 100;
    static boolean ready;
    static boolean error;
    static boolean loading;
    static Tree root;
    static Tree subtree;
    static Tree current;
    Tree parent;
    String name;
    String text;
    Vector nodes;
    boolean retrieving;
    boolean expanded;
    int[] order;

    public Tree(Tree tree, String string) {
        this.parent = tree;
        this.name = string;
        if (tree != null) {
            if (tree.nodes == null) {
                tree.nodes = new Vector();
            }
            tree.nodes.addElement(this);
        }
    }

    public static final boolean isReady() {
        if (ready) {
            return true;
        }
        if (loading) {
            return false;
        }
        loading = true;
        new Thread(root).start();
        return false;
    }

    public static final void reset() {
        subtree = null;
        current = null;
        root.reset_();
    }

    final void reset_() {
        this.expanded = false;
        this.order = null;
        if (this.nodes == null) {
            return;
        }
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            ((Tree)enumeration.nextElement()).reset_();
        }
    }

    public final void run() {
        Tree.load();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void load() {
        InputStream inputStream;
        block23: {
            block20: {
                block21: {
                    inputStream = null;
                    try {
                        try {
                            block22: {
                                Tree tree = root;
                                URL uRL = BaseApplet.makeURL(TreeFilePathName);
                                if (uRL == null) {
                                    Object var2_4 = null;
                                    if (inputStream == null) break block20;
                                    break block21;
                                }
                                URLConnection uRLConnection = uRL.openConnection();
                                inputStream = new GZIPInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
                                byte[] byArray = new byte[256];
                                int n = 0;
                                block13: while (true) {
                                    int n2;
                                    if ((n2 = inputStream.read()) == -1) {
                                        if (tree != root) {
                                            throw new Exception("Unexpected EOF in /tree.gz");
                                        }
                                        break block22;
                                    }
                                    switch (n2) {
                                        case 62: {
                                            tree = Tree.createNode(tree, byArray, n);
                                            n = 0;
                                            continue block13;
                                        }
                                        case 60: {
                                            if (n > 0) {
                                                Tree.createNode(tree, byArray, n);
                                            }
                                            n = 0;
                                            tree = tree.parent;
                                            continue block13;
                                        }
                                        case 10: {
                                            Tree.createNode(tree, byArray, n);
                                            n = 0;
                                            continue block13;
                                        }
                                    }
                                    byArray[n++] = (byte)n2;
                                    if (n == byArray.length) break;
                                }
                                throw new Exception("Too long name in /tree.gz");
                            }
                            ready = true;
                        }
                        catch (Exception exception) {
                            System.out.println(exception.toString());
                            error = true;
                        }
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var2_6 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        loading = false;
                        throw throwable;
                    }
                }
                try {}
                catch (Exception exception) {}
                inputStream.close();
            }
            loading = false;
            return;
        }
        Object var2_5 = null;
        if (inputStream != null) {
            try {}
            catch (Exception exception) {}
            inputStream.close();
        }
        loading = false;
    }

    static final Tree createNode(Tree tree, byte[] byArray, int n) throws Exception {
        if (tree == null) {
            throw new Exception("internal error during tree loading");
        }
        String string = new String(byArray, 0, n);
        if (!string.startsWith("problem")) {
            return new Tree(tree, string);
        }
        int n2 = string.indexOf("*");
        if (n2 == -1) {
            new Problem(tree, null, string, 1);
            return null;
        }
        String string2 = string.substring(0, n2);
        int n3 = 1;
        int n4 = 1;
        String string3 = null;
        String string4 = null;
        int n5 = string.indexOf("*", n2 + 1);
        if (n5 == -1) {
            string3 = string.substring(n2 + 1);
        } else {
            string3 = string.substring(n2 + 1, n5);
            string4 = string.substring(n5 + 1);
        }
        if (string3 != null) {
            try {
                n3 = Integer.valueOf(string3);
                if (n3 < 1) {
                    n3 = 1;
                }
                if (n3 > 4) {
                    n3 = 4;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (string4 != null) {
            try {
                n4 = Integer.valueOf(string4);
                if (n4 < 1) {
                    n4 = 1;
                }
                if (n4 > 100) {
                    n4 = 100;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Problem problem = new Problem(tree, null, string2, n3);
        int n6 = 0;
        while (n6 < n4 - 1) {
            new Problem(tree, problem, string2, n3);
            ++n6;
        }
        return null;
    }

    public final int[] countProblems() {
        int[] nArray = new int[4];
        return this.countProblems(nArray);
    }

    final int[] countProblems(int[] nArray) {
        if (this instanceof Problem) {
            int n = ((Problem)this).compl - 1;
            nArray[n] = nArray[n] + 1;
        }
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((Tree)enumeration.nextElement()).countProblems(nArray);
            }
        }
        return nArray;
    }

    public final int[] countProblemsAvailable() {
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = this.countProblemsAvailable(n);
            ++n;
        }
        return nArray;
    }

    final int countProblemsAvailable(int n) {
        int n2 = 0;
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                n2 += ((Tree)enumeration.nextElement())._countProblemsAvailable(n);
            }
        }
        return n2;
    }

    final int _countProblemsAvailable(int n) {
        if (this.order != null && this.order[n] != -1) {
            return this.order[n];
        }
        if (this instanceof Problem) {
            if (((Problem)this).compl - 1 == n) {
                return 1;
            }
            return 0;
        }
        int n2 = 0;
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                n2 += ((Tree)enumeration.nextElement())._countProblemsAvailable(n);
            }
        }
        return n2;
    }

    public final int[] countProblemsOrdered() {
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = this.order != null && this.order[n] != -1 ? this.order[n] : this.countProblemsOrderedInChildren(n);
            ++n;
        }
        return nArray;
    }

    final int countProblemsOrdered(int n) {
        if (this.order != null && this.order[n] != -1) {
            return this.order[n];
        }
        return this.countProblemsOrderedInChildren(n);
    }

    public final int[] countProblemsOrderedInChildren() {
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = this.countProblemsOrderedInChildren(n);
            ++n;
        }
        return nArray;
    }

    final int countProblemsOrderedInChildren(int n) {
        int n2 = -1;
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                int n3 = ((Tree)enumeration.nextElement()).countProblemsOrdered(n);
                if (n3 == -1) continue;
                if (n2 == -1) {
                    n2 = n3;
                    continue;
                }
                n2 += n3;
            }
        }
        return n2;
    }

    public final int[] getOrder() {
        if (this.order != null) {
            return this.order;
        }
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    public final void setOrder(int n, int n2) {
        if (n2 != -1) {
            int n3 = this.countProblemsAvailable(n);
            int n4 = this.countProblemsOrderedInChildren(n);
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 < n4) {
                n2 = n4;
            }
        }
        this._setOrder(n, n2);
        if (this.parent != null) {
            this.parent.chkOrder(n);
        }
        TreeComponent.redrawFlag1 = true;
    }

    final void chkOrder(int n) {
        if (this.order != null && this.order[n] != -1) {
            int n2 = this.order[n];
            int n3 = this.countProblemsAvailable(n);
            int n4 = this.countProblemsOrderedInChildren(n);
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 < n4) {
                n2 = n4;
            }
            this._setOrder(n, n2);
        }
        if (this.parent != null) {
            this.parent.chkOrder(n);
        }
    }

    final void _setOrder(int n, int n2) {
        int n3;
        if (n2 != -1 && this.order == null) {
            this.order = new int[4];
            n3 = 0;
            while (n3 < 4) {
                this.order[n3] = -1;
                ++n3;
            }
        }
        if (this.order != null) {
            this.order[n] = n2;
        }
        if (n2 == -1 && this.order != null) {
            n3 = 0;
            while (n3 < 4) {
                if (this.order[n3] != -1) {
                    return;
                }
                ++n3;
            }
            this.order = null;
        }
    }

    public final boolean isOrdered() {
        if (this.order != null) {
            return true;
        }
        if (this.nodes == null) {
            return false;
        }
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Tree)enumeration.nextElement()).isOrdered()) continue;
            return true;
        }
        return false;
    }

    public static final Tree find(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Tree tree = root;
        while (stringTokenizer.hasMoreTokens()) {
            if (tree.nodes == null) {
                return null;
            }
            String string2 = stringTokenizer.nextToken();
            Enumeration enumeration = tree.nodes.elements();
            tree = null;
            while (enumeration.hasMoreElements()) {
                Tree tree2 = (Tree)enumeration.nextElement();
                if (!string2.equals(tree2.name)) continue;
                tree = tree2;
                break;
            }
            if (tree != null) continue;
            return null;
        }
        return tree;
    }

    public final String getPath() {
        String string = "";
        Tree tree = this;
        while (tree != null) {
            string = String.valueOf(tree.name) + "/" + string;
            tree = tree.parent;
        }
        return String.valueOf(string) + (this instanceof Problem ? "problem.html" : "index.html");
    }

    public final int getDepth() {
        if (this.nodes == null) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Tree tree = (Tree)enumeration.nextElement();
            int n2 = tree.getDepth();
            if (n >= n2) continue;
            n = n2;
        }
        return n + 1;
    }

    public final int getLevel() {
        int n = 0;
        Tree tree = this;
        while (tree != root) {
            ++n;
            tree = tree.parent;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getText() {
        Tree tree = this;
        synchronized (tree) {
            if (this.text != null) {
                return this.text;
            }
            if (this.retrieving) {
                return null;
            }
            this.retrieving = true;
            Retriever.retrieve(BaseApplet.makeURL(this.getPath()), TextBegMark, TextEndMark, this);
            return null;
        }
    }

    public final void retrieved(String string) {
        this.text = string;
        this.retrieving = false;
    }

    public final void toggleExpanded() {
        if (this.expanded) {
            this.collapse();
            return;
        }
        this.collapse();
        this.expanded = true;
    }

    public final void expand() {
        this.collapse();
        this.expanded = true;
    }

    public final void collapse() {
        this.expanded = false;
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((Tree)enumeration.nextElement()).collapse();
            }
        }
    }

    public final void resetProblemsIndeces() {
        if (this instanceof Problem) {
            ((Problem)this).index = -1;
        }
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((Tree)enumeration.nextElement()).resetProblemsIndeces();
            }
        }
    }

    public static final void setIndeces(Problem[] problemArray) {
        if (problemArray != null) {
            int n = 0;
            while (n < problemArray.length) {
                if (problemArray[n] != null) {
                    problemArray[n].index = n;
                }
                ++n;
            }
        }
    }

    public final boolean hasIndexedProblems() {
        if (this instanceof Problem && ((Problem)this).index != -1) {
            return true;
        }
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Tree)enumeration.nextElement()).hasIndexedProblems()) continue;
                return true;
            }
        }
        return false;
    }

    public final Problem[] generateTest() {
        this.resetProblemsIndeces();
        int n = 0;
        while (n < 4) {
            this.chooseProblems(n, null);
            ++n;
        }
        Vector vector = new Vector();
        this.gatherMarkedProblems(vector);
        Object[] objectArray = new Problem[vector.size()];
        vector.copyInto(objectArray);
        Tree.shuffle(objectArray);
        return objectArray;
    }

    final int chooseProblems(int n, Vector vector) {
        if (this.order != null && this.order[n] == 0) {
            return 0;
        }
        if (this.order != null && this.order[n] != -1) {
            vector = new Vector<Tree>();
        }
        if (vector != null && this instanceof Problem && ((Problem)this).compl - 1 == n) {
            vector.addElement(this);
        }
        int n2 = 0;
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                n2 += ((Tree)enumeration.nextElement()).chooseProblems(n, vector);
            }
        }
        if (this.order != null && this.order[n] != -1 && this.order[n] != (n2 += Tree.randomChoose(vector, this.order[n] - n2))) {
            System.out.println("generateTest internal error");
        }
        return n2;
    }

    static final int randomChoose(Vector vector, int n) {
        int n2 = vector.size();
        if (n >= n2) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((Problem)enumeration.nextElement()).index = 1;
            }
            return n2;
        }
        boolean bl = n < n2 / 2;
        int n3 = bl ? n : n2 - n;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (int)((double)n2 * Math.random());
            Problem problem = (Problem)vector.elementAt(n5);
            if (problem.index == 1) continue;
            problem.index = 1;
            ++n4;
        }
        if (!bl) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((Problem)enumeration.nextElement()).index *= -1;
            }
        }
        return n;
    }

    final void gatherMarkedProblems(Vector vector) {
        if (this instanceof Problem && ((Problem)this).index == 1) {
            vector.addElement(this);
        }
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((Tree)enumeration.nextElement()).gatherMarkedProblems(vector);
            }
        }
    }

    static final void shuffle(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (int)((double)n * Math.random());
            int n4 = (int)((double)n * Math.random());
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
            ++n2;
        }
    }

    static {
        root = new Tree(null, "");
    }
}

