/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Component;
import java.awt.Event;
import java.awt.TextComponent;
import java.awt.TextField;
import tools.Control;
import tools.TypeConverter;

public final class Edit
extends Control {
    boolean isMin = false;
    boolean isMax = false;
    boolean isStp = false;
    boolean isRou = false;
    String value;
    String pValue;
    double min;
    double max;
    double step;
    int round;

    Component createComponent() {
        return new TextField();
    }

    void getProps(Component component) {
        super.getProps(component);
        String string = this.getParameter("value");
        this.value = string == null ? "" : (!(string instanceof Double) ? string.toString() : TypeConverter.double2String((Double)((Object)string), 2, false, false, false, false));
        string = this.getParameter("min");
        if (string != null) {
            this.isMin = true;
            this.min = TypeConverter.toDouble(string);
        }
        if ((string = this.getParameter("max")) != null) {
            this.isMax = true;
            this.max = TypeConverter.toDouble(string);
        }
        if ((string = this.getParameter("step")) != null) {
            this.isStp = true;
            this.step = Math.abs(TypeConverter.toDouble(string));
        }
        if ((string = this.getParameter("round")) != null) {
            this.isRou = true;
            this.round = TypeConverter.toInteger(string);
        }
        if (this.isMin && this.isMax && this.min > this.max) {
            double d = this.min;
            this.min = this.max;
            this.max = d;
        }
    }

    void setProps(Component component) {
        super.setProps(component);
        this.pValue = null;
        this.checkValue(component);
    }

    public Object get(String string) {
        if (string == null || "value".equals(string)) {
            return this.value;
        }
        if ("min".equals(string)) {
            if (this.isMin) {
                return new Double(this.min);
            }
            return null;
        }
        if ("max".equals(string)) {
            if (this.isMax) {
                return new Double(this.max);
            }
            return null;
        }
        if ("step".equals(string)) {
            if (this.isStp) {
                return new Double(this.step);
            }
            return null;
        }
        if ("round".equals(string)) {
            if (this.isRou) {
                return new Integer(this.round);
            }
            return null;
        }
        return super.get(string);
    }

    protected void set(Component component, Object object, String string) {
        if (component == null) {
            return;
        }
        if (string == null || "value".equals(string)) {
            this.value = this.isStp || this.isRou ? object.toString() : (object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false)));
            this.checkValue(component);
            return;
        }
        if ("min".equals(string)) {
            boolean bl = this.isMin = object != null;
            if (this.isMin) {
                this.min = TypeConverter.toDouble(object);
                if (this.isMax && this.max < this.min) {
                    this.max = this.min;
                }
            }
            this.checkValue(component);
            return;
        }
        if ("max".equals(string)) {
            boolean bl = this.isMax = object != null;
            if (this.isMax) {
                this.max = TypeConverter.toDouble(object);
                if (this.isMin && this.min > this.max) {
                    this.min = this.max;
                }
            }
            this.checkValue(component);
            return;
        }
        if ("step".equals(string)) {
            boolean bl = this.isStp = object != null;
            if (this.isStp) {
                this.step = Math.abs(TypeConverter.toDouble(object));
            }
            this.checkValue(component);
            return;
        }
        if ("round".equals(string)) {
            boolean bl = this.isRou = object != null;
            if (this.isRou) {
                this.round = TypeConverter.toInteger(object);
            }
            this.checkValue(component);
            return;
        }
        super.set(component, object, string);
    }

    public boolean action(Event event, Object object) {
        Component component = this.component;
        if (component == null) {
            return true;
        }
        this.value = this.pValue = ((TextField)component).getText();
        this.checkValue(component);
        this.event(null);
        return true;
    }

    public boolean lostFocus(Event event, Object object) {
        return this.action(event, object);
    }

    void checkValue(Component component) {
        if (this.isMin || this.isMax || this.isStp || this.isRou) {
            double d = TypeConverter.toDouble(this.value);
            if (this.isMin && d < this.min) {
                d = this.min;
            }
            if (this.isMax && d > this.max) {
                d = this.max;
            }
            if (this.isStp && this.isMin) {
                d = this.min + (double)((int)((d - this.min) / this.step + 0.5)) * this.step;
            }
            if (this.isStp && !this.isMin) {
                d = (double)((int)(d / this.step + 0.5)) * this.step;
            }
            if (this.isRou) {
                int n = this.round;
                this.value = TypeConverter.double2String(d, n, false, false, false, false);
            } else {
                this.value = TypeConverter.double2String(d, 8, false, false, false, true);
            }
        }
        if (component == null) {
            return;
        }
        if (!this.value.equals(this.pValue)) {
            ((TextComponent)((TextField)component)).setText(this.value);
            this.pValue = this.value;
        }
    }
}

