/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import java.util.Collection;
import java.util.Vector;

public final class ValueList
extends Value {
    private Vector vItems;

    public ValueList() {
        this.vItems = new Vector();
    }

    public ValueList(Vector items) {
        if (items != null) {
            this.setItems(items);
        }
    }

    public ValueList(Collection items) {
        if (items != null) {
            this.setItems(items);
        }
    }

    public ValueList(ValueList v) {
        this.vItems = new Vector();
        int size = v.getSize();
        for (int i = 0; i < size; ++i) {
            this.addItem(v.getItem(i + 1));
        }
    }

    public void setItems(Vector items) {
        this.vItems = items;
        this.makeString();
    }

    public void setItems(Collection items) {
        this.vItems = new Vector(items);
        this.makeString();
    }

    public Vector getItems() {
        return this.vItems;
    }

    public int getSize() {
        return this.vItems.size();
    }

    public void addItem(ValueType item) {
        this.vItems.add(item);
        this.makeString();
    }

    public void addItemList(Vector items) {
        this.vItems.addAll(items);
        this.makeString();
    }

    public void setItem(int num, ValueType val) {
        if (num == 0) {
            if (val instanceof ValueNumber) {
                this.vItems.setSize(((ValueNumber)val).getNumber());
            }
        } else if (this.vItems.size() > num - 1 && num - 1 >= 0) {
            this.vItems.setElementAt(val, num - 1);
        } else {
            Debug.error(109, "(Runtime) Attempted to access outside of list bounds.");
        }
        this.makeString();
    }

    public ValueType getItem(int num) {
        if (num == 0) {
            return new ValueNumber(this.vItems.size());
        }
        if (this.vItems.size() > num - 1 && num - 1 >= 0) {
            return (ValueType)this.vItems.elementAt(num - 1);
        }
        Debug.error(109, "(Runtime) Attempted to access outside of list bounds.");
        return ValueNothing.value;
    }

    public void insert(int num, Object o) {
        this.vItems.add(num - 1, o);
    }

    public void delete(int num) {
        this.vItems.removeElementAt(num - 1);
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueNumber) {
            if (op == "*") {
                ValueList nval = new ValueList(this);
                nval.insert(cmp.getNumber(), cmp);
                return nval;
            }
            if (op == "/") {
                ValueList nval = new ValueList(this);
                nval.delete(cmp.getNumber());
                return nval;
            }
            if (op == "+") {
                ValueList nval = new ValueList(this);
                nval.addItem(cmp);
                return nval;
            }
        } else if (cmp instanceof ValueList) {
            if (op == "+") {
                ValueList nval = new ValueList(this);
                for (int i = 0; i < ((ValueList)cmp).getSize(); ++i) {
                    nval.addItem(((ValueList)cmp).getItem(i + 1));
                }
                return nval;
            }
        } else if (op == "+") {
            ValueList nval = new ValueList(this);
            nval.addItem(cmp);
            return nval;
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for LIST type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Debug.error(101, "(WARNING) Incompatible comparison to LIST type : ".concat(String.valueOf(String.valueOf(val.string))));
        return 100;
    }

    public String toString() {
        this.sbuf.setLength(0);
        this.sbuf.append("{");
        if (this.vItems.size() > 0) {
            this.sbuf.append(((ValueType)this.vItems.elementAt(0)).toString());
            for (int i = 1; i < this.vItems.size(); ++i) {
                this.sbuf.append(", ");
                this.sbuf.append(((ValueType)this.vItems.elementAt(i)).toString());
            }
        }
        this.sbuf.append("}");
        return this.sbuf.toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

