/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command.Function;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.System.AllImports;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.ValuePacket;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueType;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;

public class WriteCommand
extends FuncCommand {
    public ValueType execute(EnvironmentSmall env) {
        super.execute(env);
        SystemModel m = env.getSystemModel();
        if (this.checkNumParams(2)) {
            ValueString file = this.getStringParam(0);
            ValuePacket packet = this.getPacketParam(1);
            if (m != null) {
                String path = AllImports.resolvePath(file.getValueString());
                ArrayList<Definition> a = new ArrayList<Definition>();
                int size = packet.getValues().size();
                for (int i = 0; i < size; ++i) {
                    Definition d = new Definition((String)packet.getLookup().get(i), (ValueType)packet.getValues().get(i));
                    a.add(d);
                }
                StringBuffer sBuf = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    sBuf.append(((Definition)a.get(i)).toX10GIMLI(0));
                }
                try {
                    File outFile = path != null ? new File(path) : new File(file.getValueString());
                    FileWriter outStream = new FileWriter(outFile);
                    outStream.write(sBuf.toString());
                    ((Writer)outStream).close();
                    Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"The file ").append(outFile.getAbsoluteFile()).append(" was written successfully.\""))));
                }
                catch (Exception e) {
                    Debug.error("There was a problem writing the file ".concat(String.valueOf(String.valueOf(file))));
                }
            }
        } else {
            Debug.error(100, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting file name and output packet for ").append(this.toString()).append("."))));
        }
        return null;
    }
}

