/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueList;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValuePacket;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueTime;
import X10Gimli.Value.ValueType;
import X10Gimli.Value.ValueX10;
import java.util.ArrayList;

public class FuncCommand
extends Command {
    private String sComm;
    private ArrayList vParams;
    private ArrayList vPreparedParams;
    private ValueType vParam;
    private String sParamString;

    public FuncCommand() {
        this.vParams = new ArrayList();
        this.vPreparedParams = this.vParams;
    }

    public FuncCommand(String command, ArrayList params) {
        this.setCommand(command);
        this.setParams(params);
    }

    public static Class findCommand(String command) {
        command = command.toLowerCase();
        String commclass = String.valueOf(String.valueOf(new StringBuffer("X10Gimli.Command.Function.").append(command.substring(0, 1).toUpperCase()).append(command.substring(1, command.length())).append("Command")));
        try {
            Class<?> clazz = Class.forName(commclass);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            Debug.printCallStack("Exception creating external command object.", e);
        }
        catch (NoClassDefFoundError e) {
            Debug.error("An error occurred loading the necessary classes for the function.");
        }
        return null;
    }

    public static boolean existsCommand(String command) {
        return FuncCommand.findCommand(command) != null;
    }

    public static FuncCommand InitCommand(String command, ArrayList params) {
        Class c = FuncCommand.findCommand(command);
        if (c != null) {
            try {
                FuncCommand func = (FuncCommand)c.newInstance();
                func.setCommand(command);
                func.setParams(params);
                FuncCommand funcCommand = func;
                return funcCommand;
            }
            catch (Exception e) {
                Debug.printCallStack("Problem generating FuncCommand object.", e);
            }
        }
        return new FuncCommand(command, params);
    }

    public void setCommand(String command) {
        this.sComm = command.toUpperCase().intern();
    }

    public void setParams(ArrayList params) {
        if (params != null) {
            this.vParams = params;
        }
        this.vPreparedParams = this.vParams;
        this.makeParamString();
    }

    public String getCommand() {
        return this.sComm;
    }

    protected ArrayList getActualParams() {
        return this.vParams;
    }

    public ArrayList getParams() {
        return this.vPreparedParams;
    }

    public void prepareParams() {
        this.vPreparedParams = new ArrayList();
        int size = this.vParams.size();
        for (int i = 0; i < size; ++i) {
            this.vPreparedParams.add(this.vParams.get(i));
        }
    }

    public void prepareParams(EnvironmentSmall env) {
        this.vPreparedParams = new ArrayList();
        int size = this.vParams.size();
        for (int i = 0; i < size; ++i) {
            this.vPreparedParams.add(((ValueType)this.vParams.get(i)).getValue(env));
        }
    }

    protected int getNumParams() {
        return this.vPreparedParams.size();
    }

    protected boolean checkNumParams(int num) {
        if (this.getNumParams() == num) {
            return true;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting ").append(num).append(" parameters for ").append(this.toString()).append("."))));
        return false;
    }

    protected ValueType getParam(int i) {
        this.vParam = null;
        if (this.vPreparedParams.size() > i && i >= 0) {
            this.vParam = (ValueType)this.vPreparedParams.get(i);
        }
        return this.vParam;
    }

    protected ValueIdent getIdentParam(int i) {
        if (this.getParam(i) instanceof ValueIdent) {
            return (ValueIdent)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting identifier as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueIdent();
    }

    protected ValueNumber getNumberParam(int i) {
        if (this.getParam(i) instanceof ValueNumber) {
            return (ValueNumber)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting number as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueNumber();
    }

    protected ValueX10 getX10Param(int i) {
        if (this.getParam(i) instanceof ValueX10) {
            return (ValueX10)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting X10 address as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueX10();
    }

    protected ValueString getStringParam(int i) {
        if (this.getParam(i) instanceof ValueString) {
            return (ValueString)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting string as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueString();
    }

    protected ValueTime getTimeParam(int i) {
        if (this.getParam(i) instanceof ValueTime) {
            return (ValueTime)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting time as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueTime();
    }

    protected ValueDay getDayParam(int i) {
        if (this.getParam(i) instanceof ValueDay) {
            return (ValueDay)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting day as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueDay();
    }

    protected ValueMonth getMonthParam(int i) {
        if (this.getParam(i) instanceof ValueMonth) {
            return (ValueMonth)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting month as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueMonth();
    }

    protected ValueCommand getCommandParam(int i) {
        if (this.getParam(i) instanceof ValueCommand) {
            return (ValueCommand)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting X10 command as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueCommand();
    }

    protected ValueDate getDateParam(int i) {
        if (this.getParam(i) instanceof ValueDate) {
            return (ValueDate)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting date as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueDate();
    }

    protected ValueList getListParam(int i) {
        if (this.getParam(i) instanceof ValueList) {
            return (ValueList)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting list as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValueList();
    }

    protected ValuePacket getPacketParam(int i) {
        if (this.getParam(i) instanceof ValuePacket) {
            return (ValuePacket)this.vParam;
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting packet as parameter ").append(i + 1).append(" of ").append(this.toString()).append("."))));
        return new ValuePacket();
    }

    public ValueType execute(EnvironmentSmall env) {
        this.prepareParams(env);
        return null;
    }

    private void makeParamString() {
        StringBuffer s = new StringBuffer(50);
        s.append("(");
        if (this.vParams.size() > 0) {
            s.append(((ValueType)this.vParams.get((int)0)).string);
            for (int i = 1; i < this.vParams.size(); ++i) {
                s.append(", ");
                s.append(((ValueType)this.vParams.get((int)i)).string);
            }
        }
        s.append(")");
        this.sParamString = s.toString();
    }

    protected void executionOutput() {
        this.sBuf.append(this.getCommand());
        this.sBuf.append(this.sParamString);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append(this.getCommand());
        this.sBuf.append("(");
        if (this.vParams.size() > 0) {
            this.sBuf.append(((ValueType)this.vParams.get(0)).toX10GIMLI());
            for (int i = 1; i < this.vParams.size(); ++i) {
                this.sBuf.append(", ");
                this.sBuf.append(((ValueType)this.vParams.get(i)).toX10GIMLI());
            }
        }
        this.sBuf.append(")");
        this.sBuf.append(";\n");
        return this.sBuf.toString();
    }
}

