/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.Debug;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueList;
import X10Gimli.Value.ValueType;
import java.util.Vector;

public final class ForEachCommand
extends Command {
    private String id = "loop";
    private ValueType val;
    private Command command;

    public void setIdentifier(String i) {
        this.id = i.toUpperCase().intern();
    }

    public void setValue(ValueType l) {
        this.val = l;
    }

    public void setCommand(Command c) {
        this.command = c;
    }

    public String getIdentifier() {
        return this.id;
    }

    public ValueType getValue() {
        return this.val;
    }

    public Command getCommand() {
        return this.command;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (env != null) {
            EnvironmentSmall exe = env.spawnEnvironment();
            Value l = this.val.getValue(env);
            if (l instanceof ValueList) {
                Vector v = ((ValueList)l).getItems();
                Definition d = new Definition(this.id, null);
                exe.addDefinition(d);
                int size = v.size();
                for (int i = 0; i < size; ++i) {
                    d.setValue((Value)v.elementAt(i));
                    exe.setDefinition(d);
                    exe.executeCommand(this.command);
                    d = exe.findDefinition(this.id);
                    v.setElementAt(d.getValue(), i);
                }
            } else {
                Debug.error("(Runtime) The range value must evaluate to a list.");
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("foreach ");
        this.sBuf.append(this.id);
        this.sBuf.append(" of ");
        this.sBuf.append(this.val.string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append("foreach ");
        this.sBuf.append(this.id);
        this.sBuf.append(" of ");
        this.sBuf.append(this.val.toX10GIMLI());
        this.sBuf.append(" do\r\n");
        this.sBuf.append(this.command.toX10GIMLI(depth + 1));
        return this.sBuf.toString();
    }
}

