/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Vector;
import org.webmacro.engine.Engine;
import org.webmacro.engine.List;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.TestObject;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.PropertyException;
import org.webmacro.util.PropertyMethod;
import org.webmacro.util.PropertyOperator;
import org.webmacro.util.java2.HashMap;

public class Variable
implements Macro {
    protected final String vname;
    private final Object[] myNames;

    public final String toString() {
        return "variable:" + this.vname;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evaluate(Object object) {
        try {
            Object object2 = this.getValue(object);
            if (object2 instanceof Macro) {
                return ((Macro)object2).evaluate(object);
            }
            return object2;
        }
        catch (NullPointerException nullPointerException) {
            Engine.log.exception(nullPointerException);
            Engine.log.warning("Variable: " + this.vname + " does not exist");
            return "<!--\n unable to access variable " + this.vname + ": not found in " + object + "\n -->";
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            Engine.log.warning("Variable: " + this.vname + " does not exist");
            return "<!--\n unable to access variable " + this.vname + ": " + exception + " \n-->";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        try {
            Object object2 = this.getValue(object);
            if (object2 instanceof Macro) {
                ((Macro)object2).write(writer, object);
                return;
            }
            writer.write(object2.toString());
            return;
        }
        catch (NullPointerException nullPointerException) {
            Engine.log.warning("Variable: " + this.vname + " is undefined");
            writer.write("<!--\n unable to access variable " + this.vname + ": does not exist-->");
            return;
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            Engine.log.warning("Variable: " + this.vname + " is undefined");
            writer.write("<!--\n warning: attempt to write undefined variable " + this.vname + ": " + exception + " \n-->");
        }
    }

    public static final Object parse(ParseTool parseTool) throws ParseException, IOException {
        Object object;
        Object object2;
        if (parseTool.ttype != 36) {
            return null;
        }
        parseTool.nextToken();
        boolean bl = parseTool.parseChar('$');
        Vector<String> vector = new Vector<String>();
        while ((object2 = parseTool.parseString()) != null) {
            if (parseTool.ttype == 40) {
                object = List.parse(parseTool);
                object2 = object instanceof Macro ? new PropertyMethod((String)object2, (Macro)object) : new PropertyMethod((String)object2, (Object[])object);
            }
            vector.addElement((String)object2);
            if (parseTool.ttype != 46) break;
            parseTool.nextToken();
        }
        if (vector.size() == 0) {
            parseTool.pushBack();
            return null;
        }
        parseTool.parseChar(';');
        if (bl) {
            if (vector.size() != 1) {
                throw new ParseException(parseTool, "Parameter names cannot include the dot operator character: .");
            }
            object = parseTool.getParamContext().get(vector.elementAt(0));
            if (object == null) {
                return Boolean.FALSE;
            }
            return object;
        }
        object = new Object[vector.size()];
        vector.copyInto((Object[])object);
        return new Variable((Object[])object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        try {
            String[] stringArray2 = new String[]{"$ten", "$ten xxxx", "$twenty; xxxx $a", "$bogus xxx", "$test.date.Month", "$test.Name", "$test.show($ten)", "$test.fname"};
            HashMap hashMap = new HashMap();
            System.out.println("Adding to context: ten=10");
            hashMap.put("ten", new Integer(10));
            System.out.println("Adding to context: twenty=20");
            hashMap.put("twenty", new Integer(20));
            System.out.println("Adding to context: test=TestObject(\"happy\")");
            hashMap.put("test", new TestObject("happy"));
            System.out.println();
            int n = 0;
            while (true) {
                ParseTool parseTool;
                if (n >= stringArray2.length) {
                    try {
                        System.out.println("Instantiating a variable v=$ten");
                        parseTool = new ParseTool("string", new StringReader("$ten"));
                        parseTool.nextToken();
                        Variable variable = (Variable)Variable.parse(parseTool);
                        System.out.println("Value of v: " + variable.evaluate(hashMap));
                        System.out.println("Setting v=TEN");
                        variable.setValue(hashMap, "TEN");
                        System.out.println("Value of v: " + variable.evaluate(hashMap));
                        variable = null;
                        System.out.println();
                        System.out.println("Instantiating a variable v=$test.fname");
                        parseTool = new ParseTool("string", new StringReader("$test.fname"));
                        parseTool.nextToken();
                        variable = (Variable)Variable.parse(parseTool);
                        System.out.println("Value of v: " + variable.evaluate(hashMap));
                        System.out.println("Setting v=HI MOM");
                        variable.setValue(hashMap, "HI MOM");
                        System.out.println("Value of v: " + variable.evaluate(hashMap));
                        variable = null;
                        System.out.println();
                        System.out.println("Instantiating a variable v=$test.Name");
                        parseTool = new ParseTool("string", new StringReader("$test.Name"));
                        parseTool.nextToken();
                        variable = (Variable)Variable.parse(parseTool);
                        System.out.println("Value of v: " + variable.evaluate(hashMap));
                        System.out.println("Setting v=HI AGAIN");
                        variable.setValue(hashMap, "HI AGAIN");
                        System.out.println("Value of v: " + variable.evaluate(hashMap));
                        variable = null;
                    }
                    catch (Exception exception) {
                        System.out.println("FAILED");
                        exception.printStackTrace();
                    }
                    break;
                }
                try {
                    System.out.println("Test " + n + ": " + stringArray2[n]);
                    parseTool = new ParseTool("string", new StringReader(stringArray2[n]));
                    parseTool.nextToken();
                    Variable variable = (Variable)Variable.parse(parseTool);
                    if (variable == null) {
                        System.out.println("Err: did not parse!");
                    } else {
                        System.out.println("Evaluates to: " + variable.evaluate(hashMap));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.out.println();
                ++n;
            }
            System.out.println();
            System.out.println("Done.");
            return;
        }
        catch (Exception exception) {
            System.out.println("MAIN CAUGHT AN EXCEPTION");
            exception.printStackTrace();
        }
    }

    private static final String makeName(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getValue(Object object) throws InvalidContextException {
        try {
            return PropertyOperator.getProperty(object, this.myNames);
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            String string = "Variable: unable to access " + this + ";";
            throw new InvalidContextException(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setValue(Object object, Object object2) throws InvalidContextException {
        try {
            String string;
            if (PropertyOperator.setProperty(object, this.myNames, object2)) return;
            StringBuffer stringBuffer = new StringBuffer().append("No method to set \"").append(this.vname).append("\" to type ");
            if (object2 == null) {
                string = "null";
                throw new PropertyException(stringBuffer.append(string).append(" in supplied context (").append(object).append(")").toString(), null);
            }
            string = object2.getClass().toString();
            throw new PropertyException(stringBuffer.append(string).append(" in supplied context (").append(object).append(")").toString(), null);
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            String string = "Variable.setValue: unable to access " + this + " (is it a public method/field?)";
            throw new InvalidContextException(string);
        }
    }

    Variable(Object[] objectArray) {
        this.vname = Variable.makeName(objectArray).intern();
        this.myNames = objectArray;
    }
}

